/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.github.ui;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.internal.github.ui.AvatarStore;
import org.eclipse.mylyn.internal.github.ui.pr.PullRequestContextSynchronizer;
import org.eclipse.mylyn.tasks.core.ITaskActivationListener;
import org.eclipse.mylyn.tasks.core.ITaskActivityManager;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class GitHubUi
extends AbstractUIPlugin {
    public static final String BUNDLE_ID = "org.eclipse.mylyn.github.ui";
    public static final String STORE_NAME = "avatars.ser";
    private PullRequestContextSynchronizer prSynchronize = new PullRequestContextSynchronizer();
    private static GitHubUi INSTANCE;
    private AvatarStore store = null;

    public static IStatus createStatus(int severity, String message) {
        return new Status(severity, BUNDLE_ID, message);
    }

    public static IStatus createStatus(int severity, String message, Throwable e) {
        return new Status(severity, BUNDLE_ID, message, e);
    }

    public static IStatus createErrorStatus(String message) {
        return GitHubUi.createStatus(4, message);
    }

    public static IStatus createErrorStatus(String message, Throwable t) {
        return GitHubUi.createStatus(4, message, t);
    }

    public static IStatus createErrorStatus(Throwable e) {
        return GitHubUi.createStatus(4, "Unexpected error: " + e.getMessage(), e);
    }

    public static void logError(String message, Throwable t) {
        INSTANCE.getLog().log(GitHubUi.createErrorStatus(message, t));
    }

    public static void logError(Throwable t) {
        INSTANCE.getLog().log(GitHubUi.createErrorStatus(t.getMessage(), t));
    }

    public static GitHubUi getDefault() {
        return INSTANCE;
    }

    public AvatarStore getStore() {
        return this.store;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        INSTANCE = this;
        this.loadAvatars(context);
        ITaskActivityManager activityManager = TasksUi.getTaskActivityManager();
        if (activityManager != null) {
            activityManager.addActivationListener((ITaskActivationListener)this.prSynchronize);
        }
    }

    protected void loadAvatars(BundleContext context) {
        block19: {
            IPath location = Platform.getStateLocation((Bundle)context.getBundle());
            File file = location.append(STORE_NAME).toFile();
            if (file.exists()) {
                ObjectInputStream stream = null;
                try {
                    stream = new ObjectInputStream(new FileInputStream(file));
                    this.store = (AvatarStore)stream.readObject();
                }
                catch (IOException e) {
                    GitHubUi.logError("Error reading avatar store", e);
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block19;
                }
                catch (ClassNotFoundException cnfe) {
                    try {
                        GitHubUi.logError("Error reading avatar store", cnfe);
                        break block19;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                }
                if (stream == null) break block19;
                try {
                    stream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        if (this.store == null) {
            this.store = new AvatarStore();
        }
    }

    protected void saveAvatars(BundleContext context) {
        block12: {
            IPath location = Platform.getStateLocation((Bundle)context.getBundle());
            File file = location.append(STORE_NAME).toFile();
            ObjectOutputStream stream = null;
            try {
                try {
                    stream = new ObjectOutputStream(new FileOutputStream(file));
                    stream.writeObject(this.store);
                }
                catch (IOException e) {
                    GitHubUi.logError("Error writing avatar store", e);
                    if (stream == null) break block12;
                    try {
                        stream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            finally {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        INSTANCE = null;
        this.saveAvatars(context);
        ITaskActivityManager activityManager = TasksUi.getTaskActivityManager();
        if (activityManager != null) {
            activityManager.removeActivationListener((ITaskActivationListener)this.prSynchronize);
        }
    }
}

