/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.explorer;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.php.core.libfolders.ILibraryFolderChangeListener;
import org.eclipse.php.core.libfolders.LibraryFolderManager;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.explorer.PHPExplorerPart;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class LibraryFolderChangeListener
implements ILibraryFolderChangeListener {
    public void foldersChanged(IFolder[] folders) {
        try {
            this.updatePHPExplorer(folders);
        }
        catch (CoreException e) {
            PHPUiPlugin.log(e);
        }
    }

    private void updatePHPExplorer(IFolder[] folders) throws CoreException {
        LibraryFolderManager lfm = LibraryFolderManager.getInstance();
        final IFolder[] subfolders = lfm.getAllSubfolders(folders);
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                PHPExplorerPart phpExplorer = LibraryFolderChangeListener.this.getPHPExplorer();
                if (phpExplorer != null) {
                    TreeViewer tree = phpExplorer.getTreeViewer();
                    IFolder[] iFolderArray = subfolders;
                    int n = subfolders.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IFolder subfolder = iFolderArray[n2];
                        IModelElement element = DLTKCore.create((IResource)subfolder);
                        if (element != null) {
                            tree.update((Object)element, null);
                        }
                        ++n2;
                    }
                }
            }
        });
    }

    private PHPExplorerPart getPHPExplorer() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        IWorkbenchPage page = window.getActivePage();
        if (page == null) {
            return null;
        }
        IViewReference[] iViewReferenceArray = page.getViewReferences();
        int n = iViewReferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IViewReference ref = iViewReferenceArray[n2];
            IWorkbenchPart part = ref.getPart(false);
            if (part != null && part instanceof PHPExplorerPart) {
                return (PHPExplorerPart)part;
            }
            ++n2;
        }
        return null;
    }
}

