/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.remote.telnet.internal.ui;

import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.remote.telnet.core.TelnetConnection;
import org.eclipse.remote.telnet.internal.ui.Messages;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class TelnetConnectionWizardPage
extends WizardPage {
    private String host;
    private int port = TelnetConnection.DEFAULT_PORT;
    private int timeout = TelnetConnection.DEFAULT_TIMEOUT;
    private Text hostText;
    private Text portText;
    private Text timeoutText;

    protected TelnetConnectionWizardPage() {
        super(TelnetConnectionWizardPage.class.getName());
        this.setDescription(Messages.TelnetConnectionWizardPage_0);
        this.setTitle(Messages.TelnetConnectionWizardPage_1);
    }

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout(2, false));
        Label nameLabel = new Label(comp, 0);
        nameLabel.setText(Messages.TelnetConnectionWizardPage_2);
        this.hostText = new Text(comp, 2052);
        this.hostText.setLayoutData((Object)new GridData(768));
        this.hostText.setText(this.host != null ? this.host : "");
        this.hostText.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                TelnetConnectionWizardPage.this.updateStatus();
            }

            public void keyPressed(KeyEvent e) {
            }
        });
        Label portLabel = new Label(comp, 0);
        portLabel.setText(Messages.TelnetConnectionWizardPage_3);
        this.portText = new Text(comp, 2052);
        this.portText.setLayoutData((Object)new GridData(768));
        this.portText.setText(this.port < 0 ? "" : Integer.toString(this.port));
        this.portText.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                TelnetConnectionWizardPage.this.updateStatus();
            }

            public void keyPressed(KeyEvent e) {
            }
        });
        Label timeoutLabel = new Label(comp, 0);
        timeoutLabel.setText(Messages.TelnetConnectionWizardPage_4);
        this.timeoutText = new Text(comp, 2052);
        this.timeoutText.setLayoutData((Object)new GridData(768));
        this.timeoutText.setText(this.timeout < 0 ? "" : Integer.toString(this.timeout));
        this.timeoutText.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                TelnetConnectionWizardPage.this.updateStatus();
            }

            public void keyPressed(KeyEvent e) {
            }
        });
        this.setControl((Control)comp);
        this.updateStatus();
    }

    private void updateStatus() {
        this.host = this.hostText.getText();
        try {
            this.port = Integer.parseInt(this.portText.getText());
        }
        catch (NumberFormatException numberFormatException) {
            this.port = -1;
        }
        try {
            this.timeout = Integer.parseInt(this.timeoutText.getText());
        }
        catch (NumberFormatException numberFormatException) {
            this.timeout = -1;
        }
        this.setPageComplete(!this.host.isEmpty());
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }
}

