/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.profile.ui.filters;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.php.internal.core.util.preferences.IXMLPreferencesStorable;
import org.eclipse.php.internal.core.util.preferences.XMLPreferencesReader;
import org.eclipse.php.internal.core.util.preferences.XMLPreferencesWriter;
import org.eclipse.php.internal.ui.preferences.util.Key;
import org.eclipse.php.profile.ui.ProfilerUiPlugin;
import org.eclipse.php.profile.ui.filters.ExecutionStatisticsFieldFilter;
import org.eclipse.php.profile.ui.filters.ExecutionStatisticsFilter;
import org.eclipse.php.profile.ui.filters.ExecutionStatisticsFilterCondition;
import org.eclipse.php.profile.ui.filters.ExecutionStatisticsFilterString;
import org.eclipse.ui.preferences.IWorkingCopyManager;

public class ExecutionStatisticsFiltersRegistry {
    private static final String EXTENSION_POINT_NAME = "phpProfilerExecutionStatisticsFilters";
    private static final String FILTER_TAG = "filter";
    private static final String ID_ATTRIBUTE = "id";
    private static final String NAME_ATTRIBUTE = "name";
    private static final String STANDARD_FILTER_TAG = "standardFilter";
    private static final String FILTER_STRING_TAG = "filterString";
    private static final String STRING_ATTRIBUTE = "string";
    private static final String CASE_SENSITIVE_ATTRIBUTE = "caseSensitive";
    private static final String FILTER_BY_ATTRIBUTE = "filterBy";
    private static final String FIELD_FILTER_TAG = "fieldFilter";
    private static final String DESCRIPTOR_ATTRIBUTE = "descriptor";
    private static final String NUMBER_ATTRIBUTE = "number";
    private static final String FIELD_ATTRIBUTE = "field";
    private static final String ADVANCED_FILTER_TAG = "advancedFilter";
    private static final String CONDITION_TAG = "condition";
    private static final String ATTRIBUTE_ATTRIBUTE = "attribute";
    private static final String OPERATOR_ATTRIBUTE = "operator";
    private static final String VALUE_ATTRIBUTE = "value";
    private static ExecutionStatisticsFilter[] fFilters;

    private ExecutionStatisticsFiltersRegistry() {
    }

    public static ExecutionStatisticsFilter[] getFilters() {
        if (fFilters == null) {
            ArrayList<ExecutionStatisticsFilter> filters = new ArrayList<ExecutionStatisticsFilter>();
            ExecutionStatisticsFiltersRegistry.getFilters(filters);
            fFilters = filters.toArray(new ExecutionStatisticsFilter[filters.size()]);
        }
        return fFilters;
    }

    public static void getFilters(List<ExecutionStatisticsFilter> filters) {
        ExecutionStatisticsFiltersRegistry.initFromPreferences(filters);
        if (filters.isEmpty()) {
            ExecutionStatisticsFiltersRegistry.initFromExtensions(filters);
        }
    }

    public static ExecutionStatisticsFilter getFilterByName(String name) {
        if (fFilters == null) {
            ExecutionStatisticsFiltersRegistry.getFilters();
        }
        int i = 0;
        while (i < fFilters.length) {
            if (fFilters[i].getName().equals(name)) {
                return fFilters[i];
            }
            ++i;
        }
        return null;
    }

    public static void saveFilters(ExecutionStatisticsFilter[] filters) {
        fFilters = filters;
        XMLPreferencesWriterUI.write(ProfilerUiPlugin.getDefault().getPreferenceStore(), "executionStatisticsViewFilters", filters);
    }

    private static void initFromPreferences(List<ExecutionStatisticsFilter> filters) {
        Map<String, Object>[] maps = XMLPreferencesReaderUI.read(ProfilerUiPlugin.getDefault().getPreferenceStore(), "executionStatisticsViewFilters");
        if (maps.length > 0) {
            int i = 0;
            while (i < maps.length) {
                ExecutionStatisticsFilter filter = new ExecutionStatisticsFilter();
                filter.restoreFromMap(maps[i]);
                filters.add(filter);
                ++i;
            }
        }
    }

    private static void initFromExtensions(List<ExecutionStatisticsFilter> filters) {
        IConfigurationElement[] elements;
        IConfigurationElement[] iConfigurationElementArray = elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.php.profile.ui", EXTENSION_POINT_NAME);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] children;
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (FILTER_TAG.equals(element.getName()) && (children = element.getChildren()).length > 0) {
                ExecutionStatisticsFilter filter = new ExecutionStatisticsFilter();
                filter.setName(element.getAttribute(NAME_ATTRIBUTE));
                filter.setId(element.getAttribute(ID_ATTRIBUTE));
                filter.setRemovable(false);
                int j = 0;
                while (j < children.length) {
                    if (STANDARD_FILTER_TAG.equals(children[j].getName())) {
                        IConfigurationElement[] fieldFilterElements;
                        IConfigurationElement[] filterStringElements = children[j].getChildren(FILTER_STRING_TAG);
                        if (filterStringElements.length > 0) {
                            filter.setFilterString(new ExecutionStatisticsFilterString(filterStringElements[0].getAttribute(STRING_ATTRIBUTE), filterStringElements[0].getAttribute(FILTER_BY_ATTRIBUTE), "true".equals(filterStringElements[0].getAttribute(CASE_SENSITIVE_ATTRIBUTE))));
                        }
                        if ((fieldFilterElements = children[j].getChildren(FIELD_FILTER_TAG)).length > 0) {
                            filter.setFieldFilter(new ExecutionStatisticsFieldFilter(fieldFilterElements[0].getAttribute(DESCRIPTOR_ATTRIBUTE), Integer.parseInt(fieldFilterElements[0].getAttribute(NUMBER_ATTRIBUTE)), fieldFilterElements[0].getAttribute(FIELD_ATTRIBUTE)));
                        }
                    } else if (ADVANCED_FILTER_TAG.equals(children[j].getName())) {
                        IConfigurationElement[] conditionElements = children[j].getChildren(CONDITION_TAG);
                        ArrayList<ExecutionStatisticsFilterCondition> conditions = new ArrayList<ExecutionStatisticsFilterCondition>(conditionElements.length);
                        int c = 0;
                        while (c < conditionElements.length) {
                            conditions.add(new ExecutionStatisticsFilterCondition(conditionElements[c].getAttribute(ATTRIBUTE_ATTRIBUTE), conditionElements[c].getAttribute(OPERATOR_ATTRIBUTE), conditionElements[c].getAttribute(VALUE_ATTRIBUTE)));
                            ++c;
                        }
                        filter.setFilterConditions(conditions.toArray(new ExecutionStatisticsFilterCondition[conditions.size()]));
                    }
                    ++j;
                }
                filters.add(filter);
            }
            ++n2;
        }
    }

    static class XMLPreferencesReaderUI
    extends XMLPreferencesReader {
        XMLPreferencesReaderUI() {
        }

        public static Map<String, Object>[] read(IPreferenceStore store, String prefsKey) {
            ArrayList<Map> maps = new ArrayList<Map>();
            StringTokenizer st = new StringTokenizer(store.getString(prefsKey), String.valueOf('\u0005'));
            while (st.hasMoreTokens()) {
                maps.add(XMLPreferencesReaderUI.read((String)st.nextToken(), (boolean)false));
            }
            return maps.toArray(new Map[maps.size()]);
        }
    }

    static class XMLPreferencesWriterUI
    extends XMLPreferencesWriter {
        XMLPreferencesWriterUI() {
        }

        public static void write(Key prefsKey, IXMLPreferencesStorable[] objects, ProjectScope projectScope, IWorkingCopyManager workingCopyManager) {
            StringBuilder sb = new StringBuilder();
            XMLPreferencesWriterUI.appendDelimitedString((StringBuilder)sb, (IXMLPreferencesStorable[])objects);
            prefsKey.setStoredValue((IScopeContext)projectScope, sb.toString(), workingCopyManager);
        }

        public static void write(IPreferenceStore store, String prefsKey, IXMLPreferencesStorable object) {
            StringBuilder sb = new StringBuilder();
            XMLPreferencesWriterUI.write((StringBuilder)sb, (Map)object.storeToMap());
            store.setValue(prefsKey, sb.toString());
        }

        public static void write(IPreferenceStore store, String prefsKey, IXMLPreferencesStorable[] objects) {
            StringBuilder sb = new StringBuilder();
            XMLPreferencesWriterUI.appendDelimitedString((StringBuilder)sb, (IXMLPreferencesStorable[])objects);
            store.setValue(prefsKey, sb.toString());
        }
    }
}

