/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.profile.validator.impl.wsdl;

import javax.wsdl.Types;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.schema.Schema;
import org.eclipse.wst.wsi.internal.core.WSIException;
import org.eclipse.wst.wsi.internal.core.WSITag;
import org.eclipse.wst.wsi.internal.core.profile.TestAssertion;
import org.eclipse.wst.wsi.internal.core.profile.validator.EntryContext;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.AssertionProcessVisitor;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.wsdl.WSDLValidatorImpl;
import org.eclipse.wst.wsi.internal.core.report.AssertionResult;
import org.eclipse.wst.wsi.internal.core.util.ErrorList;
import org.eclipse.wst.wsi.internal.core.wsdl.traversal.WSDLTraversal;
import org.eclipse.wst.wsi.internal.core.wsdl.traversal.WSDLTraversalContext;
import org.eclipse.wst.wsi.internal.core.xml.schema.XMLSchemaProcessor;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class BP4202
extends AssertionProcessVisitor
implements WSITag {
    private final WSDLValidatorImpl validator;
    private static final String ANNOTATION_KEY = "annotation";
    private ErrorList errorList = new ErrorList();
    private AnnotationProcessor processor;

    public BP4202(WSDLValidatorImpl impl) {
        super(impl);
        this.validator = impl;
    }

    public void visit(ExtensibilityElement obj, Object parent, WSDLTraversalContext ctx) {
        if (obj != null && obj instanceof Schema) {
            Schema el = (Schema)obj;
            try {
                this.processor.processAllSchema(el.getElement());
            }
            catch (WSIException wSIException) {}
        }
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        this.result = "passed";
        Types types = (Types)entryContext.getEntry().getEntryDetail();
        this.processor = new AnnotationProcessor(entryContext.getWSDLDocument().getDefinitions().getDocumentBaseURI());
        WSDLTraversal traversal = new WSDLTraversal();
        traversal.setVisitor(this);
        traversal.visitExtensibilityElement(true);
        traversal.ignoreReferences();
        traversal.traverse(types);
        if (this.errorList.isEmpty()) {
            return this.validator.createAssertionResult(testAssertion, "notApplicable", (String)null);
        }
        this.failureDetail = this.validator.createFailureDetail(String.valueOf(testAssertion.getFailureMessage()) + "\n\n" + this.errorList.toString(), entryContext);
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }

    class AnnotationProcessor
    extends XMLSchemaProcessor {
        public AnnotationProcessor(String context) {
            super(context, false);
        }

        protected void processSchema(Element element) {
            this.checkForAnnotation(element);
        }

        private void checkForAnnotation(Node node) {
            if (node.getLocalName() != null && node.getLocalName().equals(BP4202.ANNOTATION_KEY)) {
                BP4202.this.errorList.add(node.toString());
            }
            int i = 0;
            while (i < node.getChildNodes().getLength()) {
                this.checkForAnnotation(node.getChildNodes().item(i));
                ++i;
            }
        }
    }
}

