/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.ui.wizards;

import java.util.List;
import org.eclipse.epp.internal.mpc.ui.catalog.MarketplaceNodeCatalogItem;
import org.eclipse.epp.internal.mpc.ui.wizards.ActionLink;
import org.eclipse.epp.internal.mpc.ui.wizards.MarketplacePage;
import org.eclipse.epp.internal.mpc.ui.wizards.MarketplaceViewer;
import org.eclipse.epp.internal.mpc.ui.wizards.Messages;
import org.eclipse.epp.internal.mpc.ui.wizards.SelectionModel;
import org.eclipse.epp.mpc.ui.Operation;
import org.eclipse.equinox.internal.p2.discovery.model.CatalogItem;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;

public class InstallAllActionLink
extends ActionLink {
    private static final String INSTALL_ALL_ACTION_ID = "installAll";
    private final MarketplacePage marketplacePage;

    public InstallAllActionLink(MarketplacePage marketplacePage) {
        super(INSTALL_ALL_ACTION_ID, Messages.UserFavoritesInstallAllActionItem_installAllActionLabel, Messages.UserFavoritesInstallAllActionItem_installAllTooltip);
        this.marketplacePage = marketplacePage;
    }

    public void selected() {
        this.installAll();
    }

    protected void installAll() {
        MarketplaceViewer viewer = this.marketplacePage.getViewer();
        List items = viewer.getCatalog().getItems();
        SelectionModel selectionModel = viewer.getSelectionModel();
        for (CatalogItem catalogItem : items) {
            MarketplaceNodeCatalogItem nodeItem;
            if (!(catalogItem instanceof MarketplaceNodeCatalogItem) || selectionModel.getSelectedOperation(nodeItem = (MarketplaceNodeCatalogItem)catalogItem) != Operation.NONE) continue;
            selectionModel.select((CatalogItem)nodeItem, Operation.INSTALL);
        }
        viewer.setSelection((IStructuredSelection)new StructuredSelection(viewer.getCheckedItems()));
        if (!viewer.getSelection().isEmpty()) {
            this.marketplacePage.showNextPage();
        }
    }
}

