/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction;

import com.ibm.icu.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.internal.corext.template.java.CompilationUnitContext;
import org.eclipse.jdt.internal.corext.template.java.CompilationUnitContextType;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.JavaUIStatus;
import org.eclipse.jdt.internal.ui.text.correction.AssistContext;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.jdt.internal.ui.text.correction.SurroundWith;
import org.eclipse.jdt.internal.ui.text.template.contentassist.SurroundWithTemplateProposal;
import org.eclipse.jdt.internal.ui.text.template.contentassist.TemplateProposal;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.jdt.ui.text.java.IQuickAssistProcessor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.part.FileEditorInput;

public class QuickTemplateProcessor
implements IQuickAssistProcessor {
    private static final Pattern $_LINE_SELECTION_PATTERN = Pattern.compile("\\$\\{(.*:)?line_selection(\\(.*\\))?\\}");
    private static final Pattern $_WORD_SELECTION_PATTERN = Pattern.compile("\\$\\{(.*:)?word_selection(\\(.*\\))?\\}");

    @Override
    public boolean hasAssists(IInvocationContext context) throws CoreException {
        ICompilationUnit cu = context.getCompilationUnit();
        IDocument document = this.getDocument(cu);
        int offset = context.getSelectionOffset();
        int length = context.getSelectionLength();
        if (length == 0) {
            return false;
        }
        try {
            int startLine = document.getLineOfOffset(offset);
            int endLine = document.getLineOfOffset(offset + length);
            IRegion region = document.getLineInformation(endLine);
            return startLine < endLine || length > 0 && offset == region.getOffset() && length == region.getLength();
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public IJavaCompletionProposal[] getAssists(IInvocationContext context, IProblemLocation[] locations) throws CoreException {
        if (locations != null && locations.length > 0) {
            return new IJavaCompletionProposal[0];
        }
        try {
            int offset = context.getSelectionOffset();
            int length = context.getSelectionLength();
            if (length == 0) {
                return null;
            }
            ICompilationUnit cu = context.getCompilationUnit();
            IDocument document = this.getDocument(cu);
            String contentType = TextUtilities.getContentType((IDocument)document, (String)"___java_partitioning", (int)offset, (boolean)true);
            String contextId = contentType.equals("__java_javadoc") ? "javadoc" : "java";
            int startLine = document.getLineOfOffset(offset);
            int endLine = document.getLineOfOffset(offset + length);
            if (contextId.equals("java")) {
                IRegion endLineRegion = document.getLineInformation(endLine);
                if (endLine > startLine && endLineRegion.getOffset() == offset + length) {
                    endLineRegion = document.getLineInformation(--endLine);
                    length = endLineRegion.getOffset() + endLineRegion.getLength() - offset;
                }
                if (startLine == endLine) {
                    AssistContext invocationContext;
                    if (!(length != 0 && offset == endLineRegion.getOffset() && length == endLineRegion.getLength() || SurroundWith.isApplicable(invocationContext = new AssistContext(cu, offset, length)))) {
                        return null;
                    }
                } else {
                    offset = document.getLineOffset(startLine);
                    length = endLineRegion.getOffset() + endLineRegion.getLength() - offset;
                }
            }
            ArrayList<IJavaCompletionProposal> resultingCollections = new ArrayList<IJavaCompletionProposal>();
            this.collectSurroundTemplates(document, cu, offset, length, resultingCollections, contextId);
            this.sort(resultingCollections);
            return resultingCollections.toArray(new IJavaCompletionProposal[resultingCollections.size()]);
        }
        catch (BadLocationException e) {
            throw new CoreException(JavaUIStatus.createError(4, "", e));
        }
    }

    private void sort(ArrayList<IJavaCompletionProposal> proposals) {
        Collections.sort(proposals, new Comparator<IJavaCompletionProposal>(){

            @Override
            public int compare(IJavaCompletionProposal p1, IJavaCompletionProposal p2) {
                return Collator.getInstance().compare(p1.getDisplayString(), p2.getDisplayString());
            }
        });
    }

    private IDocument getDocument(ICompilationUnit cu) throws JavaModelException {
        IFile file = (IFile)cu.getResource();
        IDocument document = JavaUI.getDocumentProvider().getDocument((Object)new FileEditorInput(file));
        if (document == null) {
            return new Document(cu.getSource());
        }
        return document;
    }

    private void collectSurroundTemplates(IDocument document, ICompilationUnit cu, int offset, int length, Collection<IJavaCompletionProposal> result, String contextId) throws BadLocationException, CoreException {
        CompilationUnitContextType contextType = (CompilationUnitContextType)JavaPlugin.getDefault().getTemplateContextRegistry().getContextType(contextId);
        CompilationUnitContext context = contextType.createContext(document, offset, length, cu);
        context.setVariable("selection", document.get(offset, length));
        context.setForceEvaluation(true);
        int start = context.getStart();
        int end = context.getEnd();
        Region region = new Region(start, end - start);
        AssistContext invocationContext = new AssistContext(cu, start, end - start);
        ASTNode[] selectedNodes = SurroundWith.getValidSelectedNodes(invocationContext);
        Template[] templates = JavaPlugin.getDefault().getTemplateStore().getTemplates();
        int i = 0;
        while (i != templates.length) {
            Template currentTemplate = templates[i];
            if (this.canEvaluate((TemplateContext)context, currentTemplate)) {
                if (selectedNodes != null) {
                    Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
                    SurroundWithTemplateProposal proposal = new SurroundWithTemplateProposal(cu, currentTemplate, context, (IRegion)region, image, selectedNodes);
                    Object[] arg = new String[]{currentTemplate.getName(), currentTemplate.getDescription()};
                    String decorated = Messages.format(CorrectionMessages.QuickTemplateProcessor_surround_label, arg);
                    proposal.setDisplayString(StyledCellLabelProvider.styleDecoratedString((String)decorated, (StyledString.Styler)StyledString.QUALIFIER_STYLER, (StyledString)new StyledString(currentTemplate.getName())));
                    result.add(proposal);
                } else {
                    TemplateProposal proposal = new TemplateProposal(currentTemplate, (TemplateContext)context, (IRegion)region, JavaPluginImages.get("org.eclipse.jdt.ui.template_obj.gif")){

                        @Override
                        public boolean validate(IDocument doc, int off, DocumentEvent event) {
                            return false;
                        }
                    };
                    Object[] arg = new String[]{currentTemplate.getName(), currentTemplate.getDescription()};
                    String decorated = Messages.format(CorrectionMessages.QuickTemplateProcessor_surround_label, arg);
                    proposal.setDisplayString(StyledCellLabelProvider.styleDecoratedString((String)decorated, (StyledString.Styler)StyledString.QUALIFIER_STYLER, (StyledString)new StyledString(currentTemplate.getName())));
                    result.add(proposal);
                }
            }
            ++i;
        }
    }

    private boolean canEvaluate(TemplateContext context, Template template) {
        String contextId = context.getContextType().getId();
        Matcher wordSelectionMatcher = $_WORD_SELECTION_PATTERN.matcher(template.getPattern());
        Matcher lineSelectionMatcher = $_LINE_SELECTION_PATTERN.matcher(template.getPattern());
        if ("javadoc".equals(contextId) ? !template.matches("", contextId) || !lineSelectionMatcher.find() && !wordSelectionMatcher.find() : template.matches("", "javadoc") || !lineSelectionMatcher.find()) {
            return false;
        }
        TemplateContextType contextType = JavaPlugin.getDefault().getTemplateContextRegistry().getContextType(template.getContextTypeId());
        return contextType instanceof CompilationUnitContextType;
    }
}

