/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.wizards.buildpaths;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IModuleDescription;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.provisional.JavaModelAccess;
import org.eclipse.jdt.internal.core.manipulation.util.BasicElementLabels;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.refactoring.contentassist.ControlContentAssistHelper;
import org.eclipse.jdt.internal.ui.refactoring.contentassist.JavaPrecomputedNamesAssistProcessor;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListElement;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListElementAttribute;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.ModuleAddExportsDialog;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.ModuleAddReadsDialog;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.ModuleEncapsulationDetail;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IListAdapter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.SelectionButtonDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringDialogField;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.util.BidiUtils;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;

public class ModuleDialog
extends StatusDialog {
    private static final String NO_NAME = "";
    private final SelectionButtonDialogField fIsModuleCheckbox;
    private ModuleList[] fModuleLists = new ModuleList[3];
    private static final int IDX_AVAILABLE = 0;
    private static final int IDX_INCLUDED = 1;
    private static final int IDX_IMPLICITLY_INCLUDED = 2;
    private Button fAddIncludedButton;
    private Button fRemoveIncludedButton;
    private Button fPromoteIncludedButton;
    private final SelectionButtonDialogField fIsPatchCheckbox;
    private final StringDialogField fPatchedModule;
    private final ListDialogField<ModuleEncapsulationDetail.ModuleAddExport> fAddExportsList;
    private final ListDialogField<ModuleEncapsulationDetail.ModuleAddReads> fAddReadsList;
    private final CPListElement fCurrCPElement;
    private IJavaElement[] fJavaElements;
    private Set<String> fModuleNames;
    private Map<String, List<String>> fModule2RequiredModules;
    private static final int IDX_ADD = 0;
    private static final int IDX_EDIT = 1;
    private static final int IDX_REMOVE = 2;

    public ModuleDialog(Shell parent, CPListElement entryToEdit, IJavaElement[] selectedElements) {
        super(parent);
        this.fCurrCPElement = entryToEdit;
        this.fJavaElements = selectedElements;
        this.setTitle(NewWizardMessages.ModuleDialog_title);
        this.fIsModuleCheckbox = new SelectionButtonDialogField(32);
        this.fIsModuleCheckbox.setLabelText(NewWizardMessages.ModuleDialog_defines_modules_label);
        this.fIsModuleCheckbox.setSelection(entryToEdit.getAttribute("module") != null);
        this.fIsModuleCheckbox.setDialogFieldListener(field -> this.doSelectionChangedAllLists());
        this.fIsPatchCheckbox = new SelectionButtonDialogField(32);
        this.fIsPatchCheckbox.setLabelText(NewWizardMessages.ModuleDialog_patches_module_label);
        this.fIsPatchCheckbox.setDialogFieldListener(field -> this.doPatchSelectionChanged(field));
        this.fPatchedModule = new StringDialogField();
        this.fPatchedModule.setLabelText(NewWizardMessages.ModuleDialog_patched_module_label);
        this.fPatchedModule.setDialogFieldListener(field -> this.validateDetails(field));
        this.fAddExportsList = this.createDetailListContents(entryToEdit, NewWizardMessages.ModuleDialog_exports_label, new AddExportsAdapter(), ModuleEncapsulationDetail.ModuleAddExport.class);
        this.fAddReadsList = this.createDetailListContents(entryToEdit, NewWizardMessages.ModuleDialog_reads_label, new AddReadsAdapter(), ModuleEncapsulationDetail.ModuleAddReads.class);
        this.initializeValues();
        this.doPatchSelectionChanged(this.fIsPatchCheckbox);
        this.doSelectionChangedAllLists();
    }

    protected boolean isResizable() {
        return true;
    }

    private <T extends ModuleEncapsulationDetail> ListDialogField<T> createDetailListContents(CPListElement entryToEdit, String label, ListAdapter<T> adapter, Class<T> clazz) {
        String[] buttonLabels = new String[]{NewWizardMessages.ModuleDialog_detail_add, NewWizardMessages.ModuleDialog_detail_edit, NewWizardMessages.ModuleDialog_detail_remove};
        AddDetailsLabelProvider labelProvider = new AddDetailsLabelProvider();
        ListDialogField<T> detailsList = new ListDialogField<T>(adapter, buttonLabels, (ILabelProvider)labelProvider);
        detailsList.setLabelText(label);
        detailsList.setRemoveButtonIndex(2);
        detailsList.enableButton(1, false);
        detailsList.setElements(entryToEdit.getModuleEncapsulationDetails(clazz));
        detailsList.selectFirstElement();
        return detailsList;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout(1, true);
        layout.marginBottom = 0;
        composite.setLayout((Layout)layout);
        Label description = new Label(composite, 64);
        description.setText(this.getDescriptionString());
        GridData data = new GridData(4, 0x1000000, false, false, 3, 1);
        data.widthHint = this.convertWidthInCharsToPixels(100);
        description.setLayoutData((Object)data);
        this.fIsModuleCheckbox.doFillIntoGrid(composite, 3);
        TabFolder tabFolder = new TabFolder(composite, 0);
        tabFolder.setFont(composite.getFont());
        tabFolder.setLayoutData((Object)new GridData(4, 4, true, true));
        TabItem tabItemContents = new TabItem(tabFolder, 0);
        tabItemContents.setText(NewWizardMessages.ModuleDialog_contents_tab);
        tabItemContents.setImage(JavaPlugin.getImageDescriptorRegistry().get(JavaPluginImages.DESC_OBJS_MODULE));
        tabItemContents.setControl((Control)this.createContentsTab((Composite)tabFolder));
        TabItem tabItemDetails = new TabItem(tabFolder, 0);
        tabItemDetails.setText(NewWizardMessages.ModuleDialog_details_tab);
        tabItemDetails.setImage(JavaPlugin.getImageDescriptorRegistry().get(JavaPluginImages.DESC_OBJS_MODULE_ATTRIB));
        tabItemDetails.setControl((Control)this.createDetailsTab((Composite)tabFolder));
        tabFolder.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.validateTab(e.widget, (Widget)tabItemContents, (Widget)tabItemDetails)));
        ModuleDialog.applyDialogFont((Control)composite);
        return composite;
    }

    private String getDescriptionString() {
        String desc;
        String name = BasicElementLabels.getResourceName((String)this.fCurrCPElement.getPath().lastSegment());
        switch (this.fCurrCPElement.getEntryKind()) {
            case 5: {
                try {
                    name = JavaElementLabels.getContainerEntryLabel(this.fCurrCPElement.getPath(), this.fCurrCPElement.getJavaProject());
                }
                catch (JavaModelException javaModelException) {
                    name = BasicElementLabels.getPathLabel((IPath)this.fCurrCPElement.getPath(), (boolean)false);
                }
                desc = NewWizardMessages.ModuleDialog_container_description;
                break;
            }
            case 2: {
                desc = NewWizardMessages.ModuleDialog_project_description;
                break;
            }
            default: {
                desc = NewWizardMessages.ModuleDialog_description;
            }
        }
        return Messages.format(desc, name);
    }

    Composite createContentsTab(Composite parent) {
        Composite contentsPage = new Composite(parent, 0);
        contentsPage.setFont(parent.getFont());
        ModuleDialog.applyDialogFont((Control)contentsPage);
        GridLayout layout = new GridLayout();
        layout.marginTop = 5;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 3;
        contentsPage.setLayout((Layout)layout);
        contentsPage.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createContentListContents(contentsPage, NewWizardMessages.ModuleDialog_availableModules_list, NewWizardMessages.ModuleDialog_availableModules_tooltip, 0, 1);
        this.createHorizontalButtons(contentsPage);
        this.createContentListContents(contentsPage, NewWizardMessages.ModuleDialog_explicitlyIncludedModules_list, NewWizardMessages.ModuleDialog_explicitlyIncludedModules_tooltip, 1, 0);
        Label spacer = new Label(contentsPage, 0);
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        spacer.setLayoutData((Object)gd);
        Composite lowerRight = new Composite(contentsPage, 0);
        lowerRight.setLayout((Layout)new GridLayout(1, true));
        gd = new GridData(4, 4, true, true);
        lowerRight.setLayoutData((Object)gd);
        this.createVerticalButton(lowerRight);
        this.createContentListContents(lowerRight, NewWizardMessages.ModuleDialog_implicitelyIncludedModules_list, NewWizardMessages.ModuleDialog_implicitlyIncludedModule_tooltip, 2, 1);
        this.validateContents();
        return contentsPage;
    }

    Composite createDetailsTab(Composite parent) {
        Composite detailPage = new Composite(parent, 0);
        detailPage.setFont(parent.getFont());
        ModuleDialog.applyDialogFont((Control)detailPage);
        GridLayout layout = new GridLayout();
        layout.marginTop = 5;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 3;
        detailPage.setLayout((Layout)layout);
        detailPage.setLayoutData((Object)new GridData(1808));
        this.fIsPatchCheckbox.doFillIntoGrid(detailPage, 3);
        this.fPatchedModule.doFillIntoGrid(detailPage, 2);
        GridData data = (GridData)this.fPatchedModule.getLabelControl(null).getLayoutData();
        data.horizontalIndent = LayoutUtil.getIndent();
        Text patchedModuleText = this.fPatchedModule.getTextControl(null);
        BidiUtils.applyBidiProcessing((Text)patchedModuleText, (String)"java");
        if (this.fJavaElements != null) {
            ModuleDialog.configureModuleContentAssist(patchedModuleText, this.moduleNames());
        }
        ColumnLayoutData[] columnDta = new ColumnLayoutData[]{new ColumnWeightData(2), new ColumnWeightData(3), new ColumnWeightData(2)};
        String[] headers = new String[]{NewWizardMessages.ModuleDialog_source_module_header, NewWizardMessages.ModuleDialog_package_header, NewWizardMessages.ModuleDialog_target_module_header};
        this.fAddExportsList.setTableColumns(new ListDialogField.ColumnsDescription(columnDta, headers, true));
        this.fAddExportsList.doFillIntoGrid(detailPage, 4);
        LayoutUtil.setHorizontalSpan((Control)this.fAddExportsList.getLabelControl(null), 3);
        data = (GridData)this.fAddExportsList.getListControl(null).getLayoutData();
        data.grabExcessHorizontalSpace = true;
        data.heightHint = -1;
        columnDta = new ColumnWeightData[]{new ColumnWeightData(1), new ColumnWeightData(1)};
        headers = new String[]{NewWizardMessages.ModuleDialog_source_module_header, NewWizardMessages.ModuleDialog_target_module_header};
        this.fAddReadsList.setTableColumns(new ListDialogField.ColumnsDescription(columnDta, headers, true));
        this.fAddReadsList.doFillIntoGrid(detailPage, 4);
        LayoutUtil.setHorizontalSpan((Control)this.fAddReadsList.getLabelControl(null), 3);
        data = (GridData)this.fAddReadsList.getListControl(null).getLayoutData();
        data.grabExcessHorizontalSpace = true;
        data.heightHint = -1;
        return detailPage;
    }

    private void createContentListContents(Composite parent, String title, String tooltip, int idx, int targetIdx) {
        Composite box = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginBottom = 0;
        box.setLayout((Layout)layout);
        GridData gd = new GridData(4, 4, true, true);
        gd.minimumWidth = 0;
        box.setLayoutData((Object)gd);
        Label label = new Label(box, 0);
        label.setText(title);
        label.setToolTipText(tooltip);
        TableViewer tableViewer = new TableViewer(box, 2050);
        tableViewer.setContentProvider((IContentProvider)new ListContentProvider());
        tableViewer.setLabelProvider((IBaseLabelProvider)new ModulesLabelProvider());
        tableViewer.addDoubleClickListener(e -> this.moveModuleEntry(idx, targetIdx));
        tableViewer.setInput(this.fModuleLists[idx].fNames);
        tableViewer.addSelectionChangedListener(e -> this.validateContents());
        tableViewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                return ((String)e1).compareTo((String)e2);
            }
        });
        PixelConverter converter = new PixelConverter((Control)parent);
        gd = new GridData(4, 4, true, true);
        gd.widthHint = converter.convertWidthInCharsToPixels(30);
        gd.heightHint = converter.convertHeightInCharsToPixels(6);
        tableViewer.getControl().setLayoutData((Object)gd);
        this.fModuleLists[idx].fViewer = tableViewer;
    }

    private void createHorizontalButtons(Composite parent) {
        ISharedImages sharedImages = JavaPlugin.getDefault().getWorkbench().getSharedImages();
        Composite box = new Composite(parent, 0);
        box.setLayout((Layout)new GridLayout(1, true));
        this.fAddIncludedButton = new Button(box, 8);
        this.fAddIncludedButton.setImage(sharedImages.getImage("IMG_TOOL_FORWARD"));
        this.fAddIncludedButton.setToolTipText(NewWizardMessages.ModuleDialog_addToIncluded_tooltip);
        this.fAddIncludedButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.moveModuleEntry(0, 1)));
        this.fRemoveIncludedButton = new Button(box, 8);
        this.fRemoveIncludedButton.setImage(sharedImages.getImage("IMG_TOOL_BACK"));
        this.fRemoveIncludedButton.setToolTipText(NewWizardMessages.ModuleDialog_removeFromIncluded_tooltip);
        this.fRemoveIncludedButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.moveModuleEntry(1, 0)));
    }

    private void createVerticalButton(Composite parent) {
        this.fPromoteIncludedButton = new Button(parent, 8);
        this.fPromoteIncludedButton.setImage(JavaPlugin.getImageDescriptorRegistry().get(JavaPluginImages.DESC_BUTTON_MOVE_UP));
        this.fPromoteIncludedButton.setToolTipText(NewWizardMessages.ModuleDialog_addToExplicitlyIncluded_tooltip);
        this.fPromoteIncludedButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.moveModuleEntry(2, 1)));
        GridData gd = new GridData();
        gd.horizontalAlignment = 0x1000000;
        this.fPromoteIncludedButton.setLayoutData((Object)gd);
    }

    private boolean canRemoveIncludedModules() {
        if (this.fModuleLists[1].fViewer.getSelection().isEmpty()) {
            return false;
        }
        return this.fModuleLists[1].fNames.size() + this.fModuleLists[0].fNames.size() > 1;
    }

    private void moveModuleEntry(int sourceIdx, int targetIdx) {
        ISelection selection = this.fModuleLists[sourceIdx].fViewer.getSelection();
        if (selection instanceof IStructuredSelection) {
            if (sourceIdx == 1 && !this.canRemoveIncludedModules()) {
                return;
            }
            List<String> sourceList = this.fModuleLists[sourceIdx].fNames;
            List<String> targetList = this.fModuleLists[targetIdx].fNames;
            for (Object selected : (IStructuredSelection)selection) {
                if (!(selected instanceof String)) continue;
                sourceList.remove(selected);
                targetList.add((String)selected);
            }
            this.updateImplicitlyIncluded();
            this.fModuleLists[0].fViewer.refresh();
            this.fModuleLists[1].fViewer.refresh();
            this.fModuleLists[2].fViewer.refresh();
            this.validateContents();
        }
    }

    public static void configureModuleContentAssist(Text textControl, Set<String> moduleNames) {
        if (moduleNames.size() == 1) {
            textControl.setText(moduleNames.iterator().next());
        } else if (!moduleNames.isEmpty()) {
            Image image = JavaPlugin.getImageDescriptorRegistry().get(JavaPluginImages.DESC_OBJS_MODULE);
            JavaPrecomputedNamesAssistProcessor processor = new JavaPrecomputedNamesAssistProcessor(moduleNames, image);
            ControlContentAssistHelper.createTextContentAssistant(textControl, (IContentAssistProcessor)processor);
        }
    }

    protected void doPatchSelectionChanged(DialogField field) {
        this.fPatchedModule.setEnabled(this.fIsPatchCheckbox.isSelected() && this.moduleNames().size() != 1);
        this.validateDetails(field);
    }

    protected void doSelectionChangedAllLists() {
        this.doSelectionChanged(this.fAddExportsList);
        this.doSelectionChanged(this.fAddReadsList);
    }

    protected void doSelectionChanged(ListDialogField<? extends ModuleEncapsulationDetail> field) {
        boolean isModular = this.fIsModuleCheckbox.isSelected();
        List<? extends ModuleEncapsulationDetail> selected = field.getSelectedElements();
        field.enableButton(0, isModular && this.fJavaElements != null);
        field.enableButton(1, isModular && this.canEdit(selected));
        field.enableButton(2, isModular && selected.size() > 0);
        this.validateDetails(field);
    }

    private boolean canEdit(List<? extends ModuleEncapsulationDetail> selected) {
        return selected.size() == 1;
    }

    private void validateTab(Widget widget, Widget contentItem, Widget detailsItem) {
        if (widget instanceof TabFolder) {
            TabItem[] selected;
            TabItem[] tabItemArray = selected = ((TabFolder)widget).getSelection();
            int n = selected.length;
            int n2 = 0;
            while (n2 < n) {
                TabItem selectedItem = tabItemArray[n2];
                if (selectedItem == contentItem) {
                    this.validateContents();
                    return;
                }
                if (selectedItem == detailsItem) {
                    this.validateDetails(null);
                    return;
                }
                ++n2;
            }
        }
    }

    private void validateContents() {
        this.fAddIncludedButton.setEnabled(!this.fModuleLists[0].fViewer.getSelection().isEmpty());
        this.fRemoveIncludedButton.setEnabled(this.canRemoveIncludedModules());
        this.fPromoteIncludedButton.setEnabled(!this.fModuleLists[2].fViewer.getSelection().isEmpty());
        IStatus status = this.computeContentsStatus();
        this.updateStatus(status);
        if (status.isOK() && (status = this.computeDetailsStatus(null)).getSeverity() == 4) {
            this.updateStatus(new StatusInfo(4, NewWizardMessages.ModuleDialog_errorOnDetailsTab_error));
        }
    }

    private IStatus computeContentsStatus() {
        StatusInfo info = new StatusInfo();
        if (this.fIsModuleCheckbox.isSelected()) {
            if (this.fJavaElements != null) {
                if (this.fModuleLists[1].fNames.isEmpty()) {
                    info.setError(NewWizardMessages.ModuleDialog_mustIncludeModule_error);
                } else if (this.fModuleLists[1].fNames.size() + this.fModuleLists[0].fNames.size() == 1) {
                    info.setInfo(NewWizardMessages.ModuleDialog_cannotLimitSingle_error);
                }
            } else {
                info.setInfo(NewWizardMessages.ModuleDialog_unknownModules_info);
            }
        }
        return info;
    }

    private void validateDetails(DialogField field) {
        StatusInfo status = this.computeDetailsStatus(field);
        this.updateStatus(status);
        if (status.isOK() && (status = this.computeContentsStatus()).getSeverity() == 4) {
            this.updateStatus(new StatusInfo(4, NewWizardMessages.ModuleDialog_errorOnContentsTab_error));
        }
    }

    private StatusInfo computeDetailsStatus(DialogField field) {
        HashSet<String> packages = new HashSet<String>();
        StatusInfo status = new StatusInfo();
        if (this.fIsPatchCheckbox.isSelected()) {
            String patchedModule = this.fPatchedModule.getText().trim();
            if (patchedModule.isEmpty()) {
                if (field == this.fIsPatchCheckbox) {
                    status = ModuleDialog.newSilentError();
                } else {
                    status.setError(NewWizardMessages.ModuleDialog_missingPatch_error);
                }
                Shell shell = this.getShell();
                if (shell != null) {
                    this.fPatchedModule.getTextControl((Composite)shell).setFocus();
                }
            } else if (!this.moduleNames().isEmpty() && !this.moduleNames().contains(patchedModule)) {
                status.setError(Messages.format(NewWizardMessages.ModuleDialog_wrongPatch_error, patchedModule));
            } else if (this.isModuleExcluded(patchedModule)) {
                status.setError(Messages.format(NewWizardMessages.ModuleDialog_patchedModuleExcluded_error, patchedModule));
            }
        }
        if (status.isOK()) {
            for (ModuleEncapsulationDetail.ModuleAddExport export : this.fAddExportsList.getElements()) {
                if (!packages.add(export.fPackage)) {
                    status.setError(Messages.format(NewWizardMessages.ModuleDialog_duplicatePackage_error, export.fPackage));
                    break;
                }
                if (!this.isModuleExcluded(export.fSourceModule)) continue;
                status.setError(Messages.format(NewWizardMessages.ModuleDialog_exportSourceModuleExcluded_error, new String[]{export.fPackage, export.fSourceModule}));
            }
        }
        if (status.isOK()) {
            HashSet<String> readModules = new HashSet<String>();
            for (ModuleEncapsulationDetail.ModuleAddReads reads : this.fAddReadsList.getElements()) {
                if (!readModules.add(reads.toString())) {
                    status.setError(Messages.format(NewWizardMessages.ModuleDialog_duplicateReads_error, reads.toString()));
                    break;
                }
                if (!this.isModuleExcluded(reads.fSourceModule)) continue;
                status.setError(Messages.format(NewWizardMessages.ModuleDialog_readsSourceModuleExcluded_error, reads.fSourceModule));
            }
        }
        if (status.isOK() && this.fJavaElements == null) {
            status.setInfo(NewWizardMessages.ModuleDialog_cannotEditDetails_info);
        }
        return status;
    }

    private boolean isModuleExcluded(String moduleName) {
        return this.fModuleLists[0].fNames.contains(moduleName);
    }

    private void initializeValues() {
        List<ModuleEncapsulationDetail.ModulePatch> patchedModules;
        this.fModule2RequiredModules = new HashMap<String, List<String>>();
        boolean isJava9JRE = this.isJava9JRE();
        ArrayList<String> availableNames = new ArrayList<String>(this.moduleNames());
        List<Object> includedNames = new ArrayList();
        List<ModuleEncapsulationDetail.LimitModules> limits = this.fCurrCPElement.getModuleEncapsulationDetails(ModuleEncapsulationDetail.LimitModules.class);
        if (!limits.isEmpty()) {
            for (ModuleEncapsulationDetail.LimitModules limitModules : limits) {
                includedNames.addAll(limitModules.fExplicitlyIncludedModules);
                availableNames.removeAll(limitModules.fExplicitlyIncludedModules);
            }
        } else if (isJava9JRE && this.isUnnamedModule()) {
            includedNames = this.defaultIncludedModuleNamesForUnnamedModule();
            availableNames.removeAll(includedNames);
        } else {
            includedNames = availableNames;
            availableNames = new ArrayList();
        }
        this.fModuleLists[0] = new ModuleList(availableNames);
        this.fModuleLists[1] = new ModuleList(new ArrayList<Object>(includedNames));
        this.fModuleLists[2] = new ModuleList(new ArrayList<String>());
        this.updateImplicitlyIncluded();
        if (isJava9JRE) {
            this.fIsModuleCheckbox.setEnabled(false);
        }
        this.fIsPatchCheckbox.setSelection(!(patchedModules = this.fCurrCPElement.getModuleEncapsulationDetails(ModuleEncapsulationDetail.ModulePatch.class)).isEmpty());
        if (patchedModules.size() == 1) {
            this.fPatchedModule.setText(patchedModules.iterator().next().fModule);
        }
    }

    private boolean isJava9JRE() {
        IPackageFragmentRoot[] roots;
        return this.fCurrCPElement.getEntryKind() == 5 && (roots = this.findRoots(this.fCurrCPElement)).length > 1 && roots[0].getModuleDescription() != null;
    }

    private IPackageFragmentRoot[] findRoots(CPListElement element) {
        IClasspathEntry entry = element.getClasspathEntry();
        IPackageFragmentRoot[] roots = element.getJavaProject().findPackageFragmentRoots(entry);
        if (roots.length == 0 && (entry = this.copyCPEntryWithoutModuleAttribute(entry)) != null) {
            roots = element.getJavaProject().findPackageFragmentRoots(entry);
        }
        return roots;
    }

    private IClasspathEntry copyCPEntryWithoutModuleAttribute(IClasspathEntry entry) {
        IClasspathAttribute[] oldAttributes = entry.getExtraAttributes();
        IClasspathAttribute[] newAttributes = new IClasspathAttribute[oldAttributes.length];
        int count = 0;
        int i = 0;
        while (i < oldAttributes.length) {
            if (!oldAttributes[i].getName().equals("module")) {
                newAttributes[count++] = oldAttributes[i];
            }
            ++i;
        }
        if (count == oldAttributes.length) {
            return null;
        }
        newAttributes = count == 0 ? new IClasspathAttribute[]{} : Arrays.copyOf(newAttributes, count);
        return JavaCore.newContainerEntry((IPath)entry.getPath(), (IAccessRule[])entry.getAccessRules(), (IClasspathAttribute[])newAttributes, (boolean)entry.isExported());
    }

    private Set<String> moduleNames() {
        if (this.fModuleNames != null) {
            return this.fModuleNames;
        }
        HashSet<String> moduleNames = new HashSet<String>();
        if (this.fJavaElements != null) {
            int i = 0;
            while (i < this.fJavaElements.length) {
                IModuleDescription module;
                if (this.fJavaElements[i] instanceof IPackageFragmentRoot) {
                    module = ((IPackageFragmentRoot)this.fJavaElements[i]).getModuleDescription();
                    if (module != null) {
                        this.recordModule(module, moduleNames);
                    } else {
                        try {
                            this.recordModule(JavaModelAccess.getAutomaticModuleDescription((IJavaElement)this.fJavaElements[i]), moduleNames);
                        }
                        catch (JavaModelException e) {
                            JavaPlugin.log(e);
                        }
                    }
                } else if (this.fJavaElements[i] instanceof IJavaProject) {
                    try {
                        module = ((IJavaProject)this.fJavaElements[i]).getModuleDescription();
                        if (module != null) {
                            this.recordModule(module, moduleNames);
                        } else {
                            this.recordModule(JavaModelAccess.getAutomaticModuleDescription((IJavaElement)this.fJavaElements[i]), moduleNames);
                        }
                    }
                    catch (JavaModelException e) {
                        JavaPlugin.log(e);
                    }
                }
                ++i;
            }
        }
        this.fModuleNames = moduleNames;
        return this.fModuleNames;
    }

    private List<String> defaultIncludedModuleNamesForUnnamedModule() {
        if (this.fJavaElements != null) {
            ArrayList<IPackageFragmentRoot> roots = new ArrayList<IPackageFragmentRoot>();
            int i = 0;
            while (i < this.fJavaElements.length) {
                if (this.fJavaElements[i] instanceof IPackageFragmentRoot) {
                    roots.add((IPackageFragmentRoot)this.fJavaElements[i]);
                }
                ++i;
            }
            return JavaModelAccess.defaultRootModules(roots);
        }
        return Collections.emptyList();
    }

    private void recordModule(IModuleDescription module, Set<String> moduleNames) {
        String moduleName = module.getElementName();
        if (moduleNames.add(moduleName)) {
            try {
                String[] stringArray = JavaModelAccess.getRequiredModules((IModuleDescription)module);
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String required = stringArray[n2];
                    List<String> requiredModules = this.fModule2RequiredModules.get(moduleName);
                    if (requiredModules == null) {
                        requiredModules = new ArrayList<String>();
                        this.fModule2RequiredModules.put(moduleName, requiredModules);
                    }
                    requiredModules.add(required);
                    ++n2;
                }
            }
            catch (JavaModelException e) {
                JavaPlugin.log(e);
            }
        }
    }

    private void updateImplicitlyIncluded() {
        List<String> implicitNames = this.fModuleLists[2].fNames;
        this.fModuleLists[0].fNames.addAll(implicitNames);
        implicitNames.clear();
        for (String explicitName : this.fModuleLists[1].fNames) {
            if (implicitNames.contains(explicitName)) continue;
            this.collectRequired(explicitName);
        }
    }

    private void collectRequired(String explicitName) {
        List<String> requireds = this.fModule2RequiredModules.get(explicitName);
        if (requireds == null) {
            return;
        }
        List<String> implicitNames = this.fModuleLists[2].fNames;
        for (String required : requireds) {
            if (this.fModuleLists[1].fNames.contains(required) || implicitNames.contains(required) || !this.fModuleLists[0].fNames.remove(required)) continue;
            implicitNames.add(required);
            this.collectRequired(required);
        }
    }

    private String getSourceModuleName() {
        if (this.fJavaElements == null || this.fJavaElements.length != 1) {
            return NO_NAME;
        }
        IModuleDescription module = null;
        switch (this.fJavaElements[0].getElementType()) {
            case 2: {
                try {
                    module = ((IJavaProject)this.fJavaElements[0]).getModuleDescription();
                }
                catch (JavaModelException e) {
                    JavaPlugin.log(e);
                }
                break;
            }
            case 3: {
                module = ((IPackageFragmentRoot)this.fJavaElements[0]).getModuleDescription();
            }
        }
        return module != null ? module.getElementName() : NO_NAME;
    }

    private String getCurrentModuleName() {
        IModuleDescription module = null;
        try {
            module = this.fCurrCPElement.getJavaProject().getModuleDescription();
        }
        catch (JavaModelException e) {
            JavaPlugin.log(e);
        }
        return module != null ? module.getElementName() : "ALL-UNNAMED";
    }

    private boolean isUnnamedModule() {
        IModuleDescription module = null;
        try {
            module = this.fCurrCPElement.getJavaProject().getModuleDescription();
        }
        catch (JavaModelException e) {
            JavaPlugin.log(e);
        }
        return module == null;
    }

    public ModuleEncapsulationDetail[] getAllDetails() {
        String patchedModule;
        if (!this.fIsModuleCheckbox.isSelected()) {
            return null;
        }
        CPListElementAttribute attribute = this.fCurrCPElement.findAttributeElement("module");
        ArrayList<ModuleEncapsulationDetail> allElements = new ArrayList<ModuleEncapsulationDetail>();
        allElements.addAll(this.fAddExportsList.getElements());
        allElements.addAll(this.fAddReadsList.getElements());
        if (this.fIsPatchCheckbox.isSelected() && !(patchedModule = this.fPatchedModule.getText().trim()).isEmpty()) {
            allElements.add(ModuleEncapsulationDetail.ModulePatch.fromString(attribute, patchedModule));
        }
        if (this.modifiesContents()) {
            allElements.add(new ModuleEncapsulationDetail.LimitModules(this.fModuleLists[1].fNames, attribute));
        }
        return allElements.toArray(new ModuleEncapsulationDetail[allElements.size()]);
    }

    private boolean modifiesContents() {
        if (this.fModuleLists[0].fNames.isEmpty() && this.fModuleLists[2].fNames.isEmpty()) {
            return false;
        }
        if (this.isUnnamedModule()) {
            HashSet<String> initialNames = new HashSet<String>(this.defaultIncludedModuleNamesForUnnamedModule());
            for (String name : this.fModuleLists[1].fNames) {
                if (initialNames.remove(name)) continue;
                return true;
            }
            return !initialNames.isEmpty();
        }
        return true;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        String helpContextId = this.fCurrCPElement.getEntryKind() == 2 ? "org.eclipse.jdt.ui.access_rules_dialog_combine_rules_context" : "org.eclipse.jdt.ui.access_rules_dialog_context";
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)newShell, helpContextId);
    }

    public static StatusInfo newSilentError() {
        return new StatusInfo(4, NO_NAME);
    }

    public class AddDetailsLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof ModuleEncapsulationDetail.ModuleAddExport) {
                ModuleEncapsulationDetail.ModuleAddExport export = (ModuleEncapsulationDetail.ModuleAddExport)element;
                switch (columnIndex) {
                    case 0: {
                        return export.fSourceModule;
                    }
                    case 1: {
                        return export.fPackage;
                    }
                    case 2: {
                        return export.fTargetModules;
                    }
                }
                throw new IllegalArgumentException("Illegal column index " + columnIndex);
            }
            if (element instanceof ModuleEncapsulationDetail.ModuleAddReads) {
                ModuleEncapsulationDetail.ModuleAddReads reads = (ModuleEncapsulationDetail.ModuleAddReads)element;
                switch (columnIndex) {
                    case 0: {
                        return reads.fSourceModule;
                    }
                    case 1: {
                        return reads.fTargetModule;
                    }
                }
                throw new IllegalArgumentException("Illegal column index " + columnIndex);
            }
            return ModuleDialog.NO_NAME;
        }
    }

    private class AddExportsAdapter
    extends ListAdapter<ModuleEncapsulationDetail.ModuleAddExport> {
        private AddExportsAdapter() {
        }

        @Override
        void addEntry(ListDialogField<ModuleEncapsulationDetail.ModuleAddExport> field) {
            ModuleEncapsulationDetail.ModuleAddExport export;
            ModuleEncapsulationDetail.ModuleAddExport initialValue = new ModuleEncapsulationDetail.ModuleAddExport(ModuleDialog.this.getSourceModuleName(), ModuleDialog.NO_NAME, ModuleDialog.this.getCurrentModuleName(), null);
            ModuleAddExportsDialog dialog = new ModuleAddExportsDialog(ModuleDialog.this.getShell(), ModuleDialog.this.fJavaElements, initialValue);
            if (dialog.open() == 0 && (export = dialog.getExport(ModuleDialog.this.fCurrCPElement.findAttributeElement("module"))) != null) {
                field.addElement(export);
            }
        }

        @Override
        void editEntry(ListDialogField<ModuleEncapsulationDetail.ModuleAddExport> field, ModuleEncapsulationDetail.ModuleAddExport export) {
            ModuleAddExportsDialog dialog = new ModuleAddExportsDialog(ModuleDialog.this.getShell(), ModuleDialog.this.fJavaElements, export);
            if (dialog.open() == 0) {
                ModuleEncapsulationDetail.ModuleAddExport newExport = dialog.getExport(ModuleDialog.this.fCurrCPElement.findAttributeElement("module"));
                if (newExport != null) {
                    field.replaceElement(export, newExport);
                } else {
                    field.removeElement(export);
                }
            }
        }
    }

    private class AddReadsAdapter
    extends ListAdapter<ModuleEncapsulationDetail.ModuleAddReads> {
        private AddReadsAdapter() {
        }

        @Override
        void addEntry(ListDialogField<ModuleEncapsulationDetail.ModuleAddReads> field) {
            ModuleEncapsulationDetail.ModuleAddReads reads;
            ModuleEncapsulationDetail.ModuleAddReads initialValue = new ModuleEncapsulationDetail.ModuleAddReads(ModuleDialog.this.getSourceModuleName(), ModuleDialog.NO_NAME, null);
            ModuleAddReadsDialog dialog = new ModuleAddReadsDialog(ModuleDialog.this.getShell(), ModuleDialog.this.fJavaElements, initialValue);
            if (dialog.open() == 0 && (reads = dialog.getReads(ModuleDialog.this.fCurrCPElement.findAttributeElement("module"))) != null) {
                field.addElement(reads);
            }
        }

        @Override
        void editEntry(ListDialogField<ModuleEncapsulationDetail.ModuleAddReads> field, ModuleEncapsulationDetail.ModuleAddReads reads) {
            ModuleAddReadsDialog dialog = new ModuleAddReadsDialog(ModuleDialog.this.getShell(), ModuleDialog.this.fJavaElements, reads);
            if (dialog.open() == 0) {
                ModuleEncapsulationDetail.ModuleAddReads newReads = dialog.getReads(ModuleDialog.this.fCurrCPElement.findAttributeElement("module"));
                if (newReads != null) {
                    field.replaceElement(reads, newReads);
                } else {
                    field.removeElement(reads);
                }
            }
        }
    }

    private abstract class ListAdapter<T extends ModuleEncapsulationDetail>
    implements IListAdapter<T> {
        private ListAdapter() {
        }

        @Override
        public void customButtonPressed(ListDialogField<T> field, int index) {
            if (index == 0) {
                this.addEntry(field);
            } else if (index == 1) {
                this.doubleClicked(field);
            }
        }

        @Override
        public void selectionChanged(ListDialogField<T> field) {
            ModuleDialog.this.doSelectionChanged(field);
        }

        @Override
        public void doubleClicked(ListDialogField<T> field) {
            List<T> selElements = field.getSelectedElements();
            if (selElements.size() != 1) {
                return;
            }
            this.editEntry(field, (ModuleEncapsulationDetail)selElements.get(0));
        }

        abstract void addEntry(ListDialogField<T> var1);

        abstract void editEntry(ListDialogField<T> var1, T var2);
    }

    static class ListContentProvider
    implements IStructuredContentProvider {
        List<?> fContents;

        ListContentProvider() {
        }

        public Object[] getElements(Object input) {
            if (this.fContents != null && this.fContents == input) {
                return this.fContents.toArray();
            }
            return new Object[0];
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.fContents = newInput instanceof List ? (List)newInput : null;
        }
    }

    static class ModuleList {
        TableViewer fViewer;
        List<String> fNames;

        public ModuleList(List<String> names) {
            this.fNames = names;
        }
    }

    static class ModulesLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        ModulesLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return JavaPlugin.getImageDescriptorRegistry().get(JavaPluginImages.DESC_OBJS_MODULE);
        }

        public String getColumnText(Object element, int columnIndex) {
            return element.toString();
        }
    }
}

