/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.actions;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.ui.actions.FindAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;

public class WorkingSetFindAction
extends FindAction {
    private FindAction fAction;

    public WorkingSetFindAction(IWorkbenchSite site, FindAction action, String workingSetName) {
        super(site);
        this.init(action, workingSetName);
    }

    public WorkingSetFindAction(JavaEditor editor, FindAction action, String workingSetName) {
        super(editor);
        this.init(action, workingSetName);
    }

    @Override
    Class<?>[] getValidTypes() {
        return null;
    }

    @Override
    void init() {
    }

    private void init(FindAction action, String workingSetName) {
        Assert.isNotNull((Object)((Object)action));
        this.fAction = action;
        this.setText(workingSetName);
        this.setImageDescriptor(action.getImageDescriptor());
        this.setToolTipText(action.getToolTipText());
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.jdt.ui.working_set_find_action");
    }

    @Override
    public void run(IJavaElement element) {
        this.fAction.run(element);
    }

    @Override
    public void run(IJavaElement[] elements) {
        this.fAction.run(elements);
    }

    @Override
    boolean canOperateOn(IJavaElement element) {
        return this.fAction.canOperateOn(element);
    }

    @Override
    boolean canOperateOn(IStructuredSelection sel) {
        IJavaElement[] elements;
        if (sel == null || sel.isEmpty()) {
            return false;
        }
        IJavaElement[] iJavaElementArray = elements = this.getJavaElements(sel, true);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElement iJavaElement = iJavaElementArray[n2];
            if (!this.fAction.canOperateOn(iJavaElement)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Override
    int getLimitTo() {
        return -1;
    }

    @Override
    String getOperationUnavailableMessage() {
        return this.fAction.getOperationUnavailableMessage();
    }
}

