/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.s.jaxws;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.eclipse.scout.sdk.core.s.jaxws.JaxWsUtils;
import org.eclipse.scout.sdk.core.s.util.CoreScoutUtils;
import org.eclipse.scout.sdk.core.s.util.maven.MavenBuild;
import org.eclipse.scout.sdk.core.s.util.maven.MavenRunner;
import org.eclipse.scout.sdk.core.util.CoreUtils;
import org.eclipse.scout.sdk.core.util.SdkLog;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public final class JaxWsModuleNewHelper {
    private JaxWsModuleNewHelper() {
    }

    public static File getParentPomOf(File modulePomFile, Document modulePomDocument) {
        Element relPat;
        Element parent = CoreUtils.getFirstChildElement((Element)modulePomDocument.getDocumentElement(), (String)"parent");
        if (parent != null && (relPat = CoreUtils.getFirstChildElement((Element)parent, (String)"relativePath")) != null) {
            String path = relPat.getTextContent();
            if (StringUtils.isBlank((CharSequence)path)) {
                return null;
            }
            if (!path.endsWith("pom.xml")) {
                if (path.charAt(path.length() - 1) != '/') {
                    path = String.valueOf(path) + '/';
                }
                path = String.valueOf(path) + "pom.xml";
            }
            return modulePomFile.getParentFile().toPath().resolve(path).normalize().toFile();
        }
        return new File(modulePomFile.getParentFile().getParentFile(), "pom.xml");
    }

    public static File getParentPomOf(File projectPomFile) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilder docBuilder = CoreUtils.createDocumentBuilder();
        Document doc = docBuilder.parse(projectPomFile);
        return JaxWsModuleNewHelper.getParentPomOf(projectPomFile, doc);
    }

    public static File createModule(File targetModulePomFile, String artifactId) throws IOException {
        try {
            return JaxWsModuleNewHelper.createModuleImpl(targetModulePomFile, artifactId);
        }
        catch (ParserConfigurationException | SAXException e) {
            throw new IOException(e);
        }
    }

    static File createModuleImpl(File targetModulePomFile, String artifactId) throws IOException, ParserConfigurationException, SAXException {
        Validate.notNull((Object)targetModulePomFile);
        Validate.isTrue((boolean)targetModulePomFile.isFile(), (String)"Target module pom file could not be found.", (Object[])new Object[0]);
        Validate.notNull((Object)artifactId);
        File targetDirectory = targetModulePomFile.getParentFile().getParentFile();
        Validate.notNull((Object)targetDirectory);
        Validate.isTrue((boolean)targetDirectory.isDirectory(), (String)"Target directory could not be found.", (Object[])new Object[0]);
        DocumentBuilder docBuilder = CoreUtils.createDocumentBuilder();
        Document targetModulePomDocument = docBuilder.parse(targetModulePomFile);
        String groupId = CoreScoutUtils.getGroupIdOfPom(targetModulePomDocument);
        if (StringUtils.isBlank((CharSequence)groupId)) {
            throw new IOException("Unable to calculate groupId for new module.");
        }
        String version = CoreScoutUtils.getVersionOfPom(targetModulePomDocument);
        if (StringUtils.isBlank((CharSequence)version)) {
            throw new IOException("Unable to calculate version for new module.");
        }
        String parentArtifactId = CoreScoutUtils.getParentArtifactId(targetModulePomDocument);
        if (StringUtils.isBlank((CharSequence)version)) {
            throw new IOException("Unable to calculate parent for new module.");
        }
        String displayName = null;
        Element nameElement = CoreUtils.getFirstChildElement((Element)targetModulePomDocument.getDocumentElement(), (String)"name");
        displayName = nameElement != null ? nameElement.getTextContent() : "Server Web Services";
        File tempDirectory = Files.createTempDirectory("jaxws-module-tmp", new FileAttribute[0]).toFile();
        String createdProjectName = null;
        try {
            MavenBuild archetypeBuild = new MavenBuild().withWorkingDirectory(tempDirectory).withGoal("archetype:generate").withOption('B').withProperty("archetypeGroupId", "org.eclipse.scout.archetypes").withProperty("archetypeArtifactId", "scout-jaxws-module").withProperty("archetypeVersion", "7.0.300.005_Oxygen_3").withProperty("groupId", groupId).withProperty("artifactId", artifactId).withProperty("version", version).withProperty("package", "not.used").withProperty("displayName", displayName).withProperty("parentArtifactId", parentArtifactId);
            MavenRunner.execute(archetypeBuild);
            File[] listFiles = tempDirectory.listFiles();
            if (listFiles == null || listFiles.length < 1) {
                throw new IOException("created project dir not found. Project creation failed.");
            }
            File createdProjectDir = listFiles[0];
            JaxWsModuleNewHelper.deleteGitKeepFiles(createdProjectDir);
            createdProjectName = createdProjectDir.getName();
            CoreUtils.moveDirectory((File)createdProjectDir, (File)targetDirectory);
        }
        finally {
            CoreUtils.deleteDirectory((File)tempDirectory);
        }
        JaxWsModuleNewHelper.registerNewModuleInParent(targetModulePomFile, targetModulePomDocument, groupId, artifactId, version, parentArtifactId);
        JaxWsModuleNewHelper.addDependencyToTargetModule(targetModulePomFile, groupId, artifactId);
        return new File(targetDirectory, createdProjectName);
    }

    static void deleteGitKeepFiles(File createdProjectDir) throws IOException {
        String gitkeep1Location = "src/main/resources/WEB-INF/wsdl/.gitkeep";
        File gitkeep = new File(createdProjectDir, gitkeep1Location);
        if (!gitkeep.isFile()) {
            throw new IOException(String.valueOf(gitkeep1Location) + " file not found.");
        }
        Files.delete(gitkeep.toPath());
        String gitkeep2Location = "src/main/java/.gitkeep";
        gitkeep = new File(createdProjectDir, gitkeep2Location);
        if (!gitkeep.isFile()) {
            throw new IOException(String.valueOf(gitkeep2Location) + " file not found.");
        }
        Files.delete(gitkeep.toPath());
    }

    static void registerNewModuleInParent(File targetModulePomFile, Document targetModulePom, String groupId, String artifactId, String version, String parentArtifactId) throws IOException {
        File parentPomFile = JaxWsModuleNewHelper.getParentPomOf(targetModulePomFile, targetModulePom);
        if (parentPomFile == null || !parentPomFile.isFile()) {
            SdkLog.warning((String)"Parent pom for new JAX-WS module could not be found. New module will not be registered.", (Object[])new Object[0]);
            return;
        }
        try {
            DocumentBuilder createDocumentBuilder = CoreUtils.createDocumentBuilder();
            Document parentPom = createDocumentBuilder.parse(parentPomFile);
            Element modulesElement = JaxWsUtils.getOrCreateElement(parentPom.getDocumentElement(), "modules");
            Element newModuleElement = parentPom.createElement("module");
            newModuleElement.setTextContent("../" + artifactId);
            modulesElement.appendChild(newModuleElement);
            Element dependencyManagementElement = JaxWsUtils.getOrCreateElement(parentPom.getDocumentElement(), "dependencyManagement");
            Element dependenciesElement = JaxWsUtils.getOrCreateElement(dependencyManagementElement, "dependencies");
            Element newDependencyElement = parentPom.createElement("dependency");
            dependenciesElement.appendChild(newDependencyElement);
            Element newGroupIdElement = JaxWsUtils.getOrCreateElement(newDependencyElement, "groupId");
            newGroupIdElement.setTextContent(groupId);
            Element newArtifactIdElement = JaxWsUtils.getOrCreateElement(newDependencyElement, "artifactId");
            newArtifactIdElement.setTextContent(artifactId);
            Element newVersionElement = JaxWsUtils.getOrCreateElement(newDependencyElement, "version");
            Element properties = CoreUtils.getFirstChildElement((Element)parentPom.getDocumentElement(), (String)"properties");
            if (properties != null) {
                String[] suffixes;
                String[] stringArray = suffixes = new String[]{".version", "_version"};
                int n = suffixes.length;
                int n2 = 0;
                while (n2 < n) {
                    String suffix = stringArray[n2];
                    String versionPropertyName = String.valueOf(groupId) + '.' + parentArtifactId + suffix;
                    if (CoreUtils.getFirstChildElement((Element)properties, (String)versionPropertyName) != null) {
                        newVersionElement.setTextContent("${" + versionPropertyName + '}');
                        break;
                    }
                    ++n2;
                }
            }
            if (StringUtils.isEmpty((CharSequence)newVersionElement.getTextContent())) {
                newVersionElement.setTextContent(version);
            }
            JaxWsModuleNewHelper.writeDocument(parentPom, parentPomFile);
        }
        catch (ParserConfigurationException | TransformerException | SAXException e) {
            throw new IOException(e);
        }
    }

    static void writeDocument(Document document, File file) throws TransformerException {
        Transformer transformer = CoreUtils.createTransformer((boolean)true);
        transformer.transform(new DOMSource(document), new StreamResult(file));
    }

    static void addDependencyToTargetModule(File targetModulePomFile, String groupId, String artifactId) throws IOException {
        try {
            DocumentBuilder createDocumentBuilder = CoreUtils.createDocumentBuilder();
            Document pom = createDocumentBuilder.parse(targetModulePomFile);
            Element dependenciesElement = JaxWsUtils.getOrCreateElement(pom.getDocumentElement(), "dependencies");
            Element newDependencyElement = pom.createElement("dependency");
            dependenciesElement.appendChild(newDependencyElement);
            Element newGroupIdElement = JaxWsUtils.getOrCreateElement(newDependencyElement, "groupId");
            newGroupIdElement.setTextContent(groupId);
            Element newArtifactIdElement = JaxWsUtils.getOrCreateElement(newDependencyElement, "artifactId");
            newArtifactIdElement.setTextContent(artifactId);
            JaxWsModuleNewHelper.writeDocument(pom, targetModulePomFile);
        }
        catch (ParserConfigurationException | TransformerException | SAXException e) {
            throw new IOException(e);
        }
    }
}

