/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.s.model;

import org.eclipse.jdt.internal.compiler.util.SuffixConstants;
import org.eclipse.scout.sdk.core.importvalidator.IImportValidator;
import org.eclipse.scout.sdk.core.s.annotation.FormDataAnnotation;
import org.eclipse.scout.sdk.core.sourcebuilder.ISourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.RawSourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.annotation.AnnotationSourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.annotation.IAnnotationSourceBuilder;
import org.eclipse.scout.sdk.core.util.CoreUtils;
import org.eclipse.scout.sdk.core.util.PropertyMap;

public final class ScoutAnnotationSourceBuilderFactory {
    private ScoutAnnotationSourceBuilderFactory() {
    }

    public static IAnnotationSourceBuilder createOrder(double orderNr) {
        AnnotationSourceBuilder orderAnnoation = new AnnotationSourceBuilder("org.eclipse.scout.rt.platform.Order");
        String orderStr = Double.toString(orderNr);
        String zeroSuffix = ".0";
        if (orderStr.endsWith(".0")) {
            orderStr = orderStr.substring(0, orderStr.length() - ".0".length());
        }
        orderAnnoation.putElement("value", orderStr);
        return orderAnnoation;
    }

    public static IAnnotationSourceBuilder createClassId(String classIdValue) {
        AnnotationSourceBuilder classIdAnnoation = new AnnotationSourceBuilder("org.eclipse.scout.rt.platform.classid.ClassId");
        classIdAnnoation.putElement("value", CoreUtils.toStringLiteral((String)classIdValue));
        return classIdAnnoation;
    }

    public static IAnnotationSourceBuilder createBefore() {
        AnnotationSourceBuilder sourceBuilder = new AnnotationSourceBuilder("org.junit.Before");
        return sourceBuilder;
    }

    public static IAnnotationSourceBuilder createApplicationScoped() {
        AnnotationSourceBuilder sourceBuilder = new AnnotationSourceBuilder("org.eclipse.scout.rt.platform.ApplicationScoped");
        return sourceBuilder;
    }

    public static IAnnotationSourceBuilder createBeanMock() {
        AnnotationSourceBuilder sourceBuilder = new AnnotationSourceBuilder("org.eclipse.scout.rt.testing.platform.mock.BeanMock");
        return sourceBuilder;
    }

    public static IAnnotationSourceBuilder createTunnelToServer() {
        AnnotationSourceBuilder sourceBuilder = new AnnotationSourceBuilder("org.eclipse.scout.rt.shared.TunnelToServer");
        return sourceBuilder;
    }

    public static IAnnotationSourceBuilder createTest() {
        return new AnnotationSourceBuilder("org.junit.Test");
    }

    public static IAnnotationSourceBuilder createRunWithSubject(ISourceBuilder valueBuilder) {
        if (valueBuilder == null) {
            valueBuilder = new RawSourceBuilder(CoreUtils.toStringLiteral((String)"anonymous"));
        }
        AnnotationSourceBuilder sourceBuilder = new AnnotationSourceBuilder("org.eclipse.scout.rt.testing.platform.runner.RunWithSubject");
        sourceBuilder.putElement("value", valueBuilder);
        return sourceBuilder;
    }

    public static IAnnotationSourceBuilder createRunWithClientSession(final String clientSessionSignature) {
        AnnotationSourceBuilder sourceBuilder = new AnnotationSourceBuilder("org.eclipse.scout.rt.testing.client.runner.RunWithClientSession");
        sourceBuilder.putElement("value", new ISourceBuilder(){

            public void createSource(StringBuilder source, String lineDelimiter, PropertyMap context, IImportValidator validator) {
                if (clientSessionSignature == null) {
                    source.append(validator.useName("org.eclipse.scout.rt.client.testenvironment.TestEnvironmentClientSession"));
                } else {
                    source.append(validator.useSignature(clientSessionSignature));
                }
                source.append(SuffixConstants.SUFFIX_class);
            }
        });
        return sourceBuilder;
    }

    public static IAnnotationSourceBuilder createRunWithServerSession(final String serverSessionSignature) {
        AnnotationSourceBuilder sourceBuilder = new AnnotationSourceBuilder("org.eclipse.scout.rt.testing.server.runner.RunWithServerSession");
        sourceBuilder.putElement("value", new ISourceBuilder(){

            public void createSource(StringBuilder source, String lineDelimiter, PropertyMap context, IImportValidator validator) {
                source.append(validator.useSignature(serverSessionSignature)).append(SuffixConstants.SUFFIX_class);
            }
        });
        return sourceBuilder;
    }

    public static IAnnotationSourceBuilder createRunWith(final String runnerSignature) {
        AnnotationSourceBuilder sourceBuilder = new AnnotationSourceBuilder("org.junit.runner.RunWith");
        sourceBuilder.putElement("value", new ISourceBuilder(){

            public void createSource(StringBuilder source, String lineDelimiter, PropertyMap context, IImportValidator validator) {
                source.append(validator.useSignature(runnerSignature)).append(SuffixConstants.SUFFIX_class);
            }
        });
        return sourceBuilder;
    }

    public static IAnnotationSourceBuilder createData(final String pageDataTypeSignature) {
        AnnotationSourceBuilder asb = new AnnotationSourceBuilder("org.eclipse.scout.rt.client.dto.Data");
        asb.putElement("value", new ISourceBuilder(){

            public void createSource(StringBuilder source, String lineDelimiter, PropertyMap context, IImportValidator validator) {
                source.append(validator.useSignature(pageDataTypeSignature)).append(SuffixConstants.SUFFIX_class);
            }
        });
        return asb;
    }

    public static IAnnotationSourceBuilder createFormData() {
        return ScoutAnnotationSourceBuilderFactory.createFormData(null, null, null);
    }

    public static IAnnotationSourceBuilder createFormData(final String formDataSignature, FormDataAnnotation.SdkCommand sdkCommand, FormDataAnnotation.DefaultSubtypeSdkCommand defaultSubtypeCommand) {
        AnnotationSourceBuilder formDataAnnot = new AnnotationSourceBuilder("org.eclipse.scout.rt.client.dto.FormData");
        if (formDataSignature != null && !"Ljava.lang.Object;".equals(formDataSignature)) {
            formDataAnnot.putElement("value", new ISourceBuilder(){

                public void createSource(StringBuilder source, String lineDelimiter, PropertyMap context, IImportValidator validator) {
                    source.append(validator.useSignature(formDataSignature)).append(SuffixConstants.SUFFIX_class);
                }
            });
        }
        if (sdkCommand != null && !FormDataAnnotation.SdkCommand.DEFAULT.equals((Object)sdkCommand)) {
            formDataAnnot.putElement("sdkCommand", new ISourceBuilder((IAnnotationSourceBuilder)formDataAnnot, sdkCommand){
                private final /* synthetic */ IAnnotationSourceBuilder val$formDataAnnot;
                private final /* synthetic */ FormDataAnnotation.SdkCommand val$sdkCommand;
                {
                    this.val$formDataAnnot = iAnnotationSourceBuilder;
                    this.val$sdkCommand = sdkCommand;
                }

                public void createSource(StringBuilder source, String lineDelimiter, PropertyMap context, IImportValidator validator) {
                    String formDataTypeRef = validator.useName(this.val$formDataAnnot.getName());
                    source.append(formDataTypeRef);
                    source.append(".SdkCommand.");
                    source.append(this.val$sdkCommand.name());
                }
            });
        }
        if (defaultSubtypeCommand != null && !FormDataAnnotation.DefaultSubtypeSdkCommand.DEFAULT.equals((Object)defaultSubtypeCommand)) {
            formDataAnnot.putElement("defaultSubtypeSdkCommand", new ISourceBuilder((IAnnotationSourceBuilder)formDataAnnot, defaultSubtypeCommand){
                private final /* synthetic */ IAnnotationSourceBuilder val$formDataAnnot;
                private final /* synthetic */ FormDataAnnotation.DefaultSubtypeSdkCommand val$defaultSubtypeCommand;
                {
                    this.val$formDataAnnot = iAnnotationSourceBuilder;
                    this.val$defaultSubtypeCommand = defaultSubtypeSdkCommand;
                }

                public void createSource(StringBuilder source, String lineDelimiter, PropertyMap context, IImportValidator validator) {
                    String formDataTypeRef = validator.useName(this.val$formDataAnnot.getName());
                    source.append(formDataTypeRef);
                    source.append(".DefaultSubtypeSdkCommand.");
                    source.append(this.val$defaultSubtypeCommand.name());
                }
            });
        }
        return formDataAnnot;
    }

    public static IAnnotationSourceBuilder createReplace() {
        AnnotationSourceBuilder sourceBuilder = new AnnotationSourceBuilder("org.eclipse.scout.rt.platform.Replace");
        return sourceBuilder;
    }
}

