/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.importvalidator;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.eclipse.scout.sdk.core.importcollector.IImportCollector;
import org.eclipse.scout.sdk.core.importvalidator.IImportValidator;
import org.eclipse.scout.sdk.core.model.api.IType;
import org.eclipse.scout.sdk.core.signature.Signature;
import org.eclipse.scout.sdk.core.signature.SignatureDescriptor;

public class ImportValidator
implements IImportValidator {
    private IImportCollector m_importCollector;

    public ImportValidator(IImportCollector collector) {
        this.m_importCollector = collector;
    }

    @Override
    public void setImportCollector(IImportCollector collector) {
        this.m_importCollector = collector;
    }

    @Override
    public IImportCollector getImportCollector() {
        return this.m_importCollector;
    }

    @Override
    public String useType(IType type) {
        return this.useSignature(((IType)Validate.notNull((Object)type)).signature());
    }

    @Override
    public String useName(String fullyQualifiedName) {
        return this.useSignature(Signature.createTypeSignature(fullyQualifiedName));
    }

    @Override
    public String useSignature(String signature) {
        StringBuilder result = new StringBuilder(128);
        this.useSignatureInternal(signature, false, result);
        return result.toString();
    }

    protected void useSignatureInternal(String signature, boolean isTypeArg, StringBuilder sigBuilder) {
        int arrayCount = 0;
        switch (Signature.getTypeSignatureKind(signature)) {
            case 5: {
                sigBuilder.append('?');
                if (signature.length() <= 1) break;
                sigBuilder.append(" extends ");
                this.useSignatureInternal(signature.substring(1), false, sigBuilder);
                break;
            }
            case 4: {
                arrayCount = Signature.getArrayCount(signature);
                this.useSignatureInternal(signature.substring(arrayCount), false, sigBuilder);
                break;
            }
            case 2: {
                sigBuilder.append(Signature.getSignatureSimpleName(signature));
                break;
            }
            case 3: {
                String[] typeParameterBounds = Signature.getTypeParameterBounds(signature);
                String name = Signature.getTypeVariable(signature);
                sigBuilder.append(name);
                if (typeParameterBounds.length <= 0) break;
                sigBuilder.append(" extends ");
                this.useSignatureInternal(typeParameterBounds[0], false, sigBuilder);
                int i = 1;
                while (i < typeParameterBounds.length) {
                    sigBuilder.append(" & ");
                    this.useSignatureInternal(typeParameterBounds[i], false, sigBuilder);
                    ++i;
                }
                break;
            }
            default: {
                int i;
                List<String> segments = ImportValidator.getSegments(signature);
                String signatureToImport = signature;
                int firstParameterizedSegmentIndex = ImportValidator.getIndexOfFirstSegmentWithTypeArguments(segments);
                if (firstParameterizedSegmentIndex >= 0) {
                    StringBuilder segmentsToFirstParameterized = new StringBuilder();
                    i = 0;
                    while (i <= firstParameterizedSegmentIndex) {
                        if (i != 0) {
                            segmentsToFirstParameterized.append('.');
                        }
                        segmentsToFirstParameterized.append(segments.get(i));
                        ++i;
                    }
                    if (segmentsToFirstParameterized.charAt(segmentsToFirstParameterized.length() - 1) != ';') {
                        segmentsToFirstParameterized.append(';');
                    }
                    signatureToImport = segmentsToFirstParameterized.toString();
                }
                SignatureDescriptor cand = new SignatureDescriptor(Signature.getTypeErasure(signatureToImport));
                sigBuilder.append(this.getReferenceFor(cand, isTypeArg));
                this.appendTypeArguments(signatureToImport, sigBuilder);
                if (firstParameterizedSegmentIndex < 0) break;
                i = firstParameterizedSegmentIndex + 1;
                while (i < segments.size()) {
                    String segmentSig = String.valueOf('L') + segments.get(i) + ';';
                    sigBuilder.append('.');
                    this.useSignatureInternal(segmentSig, false, sigBuilder);
                    ++i;
                }
                break block0;
            }
        }
        int i = 0;
        while (i < arrayCount) {
            sigBuilder.append("[]");
            ++i;
        }
    }

    protected void appendTypeArguments(String signatureToImport, StringBuilder sigBuilder) {
        String[] typeArguments = Signature.getTypeArguments(signatureToImport);
        if (typeArguments.length > 0) {
            sigBuilder.append('<');
            this.useSignatureInternal(typeArguments[0], true, sigBuilder);
            int i = 1;
            while (i < typeArguments.length) {
                sigBuilder.append(", ");
                this.useSignatureInternal(typeArguments[i], true, sigBuilder);
                ++i;
            }
            sigBuilder.append('>');
        }
    }

    protected String getReferenceFor(SignatureDescriptor cand, boolean isTypeArg) {
        IImportCollector collector = this.getImportCollector();
        String use = collector.checkExistingImports(cand);
        if (use == null) {
            boolean inSamePackage;
            use = collector.checkCurrentScope(cand);
            boolean foundInCurrentScope = use != null && use.indexOf(46) < 0;
            boolean bl = inSamePackage = Objects.equals(collector.getQualifier(), cand.getQualifier()) || StringUtils.isBlank((CharSequence)collector.getQualifier()) && StringUtils.isBlank((CharSequence)cand.getQualifier());
            if (isTypeArg && foundInCurrentScope && inSamePackage) {
                collector.registerElement(cand);
            }
        }
        if (use == null) {
            use = collector.registerElement(cand);
        }
        return use;
    }

    protected static int getIndexOfFirstSegmentWithTypeArguments(List<String> segments) {
        int i = 0;
        while (i < segments.size()) {
            if (segments.get(i).indexOf(60) >= 0) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected static List<String> getSegments(String signature) {
        ArrayList<String> segments = new ArrayList<String>();
        StringBuilder segmentBuilder = new StringBuilder();
        char[] sig = signature.toCharArray();
        int argCount = 0;
        int i = 0;
        while (i < sig.length) {
            char curChar = sig[i];
            switch (curChar) {
                case '.': {
                    boolean insideTypeArg;
                    boolean bl = insideTypeArg = argCount > 0;
                    if (insideTypeArg) {
                        segmentBuilder.append(curChar);
                        break;
                    }
                    segments.add(segmentBuilder.toString());
                    segmentBuilder.delete(0, segmentBuilder.length());
                    break;
                }
                case '<': {
                    ++argCount;
                    segmentBuilder.append(curChar);
                    break;
                }
                case '>': {
                    --argCount;
                    segmentBuilder.append(curChar);
                    break;
                }
                default: {
                    segmentBuilder.append(curChar);
                }
            }
            ++i;
        }
        segments.add(segmentBuilder.toString());
        return segments;
    }
}

