/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.model.api.internal;

import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.scout.sdk.core.model.api.Flags;
import org.eclipse.scout.sdk.core.model.api.IAnnotation;
import org.eclipse.scout.sdk.core.model.api.ICompilationUnit;
import org.eclipse.scout.sdk.core.model.api.IPackage;
import org.eclipse.scout.sdk.core.model.api.ISourceRange;
import org.eclipse.scout.sdk.core.model.api.IType;
import org.eclipse.scout.sdk.core.model.api.internal.AbstractMemberImplementor;
import org.eclipse.scout.sdk.core.model.api.internal.JavaEnvironmentImplementor;
import org.eclipse.scout.sdk.core.model.api.internal.JavaModelPrinter;
import org.eclipse.scout.sdk.core.model.api.internal.WrappedList;
import org.eclipse.scout.sdk.core.model.spi.AnnotatableSpi;
import org.eclipse.scout.sdk.core.model.spi.JavaElementSpi;
import org.eclipse.scout.sdk.core.model.spi.TypeSpi;
import org.eclipse.scout.sdk.core.model.sugar.AnnotationQuery;
import org.eclipse.scout.sdk.core.model.sugar.FieldQuery;
import org.eclipse.scout.sdk.core.model.sugar.MethodQuery;
import org.eclipse.scout.sdk.core.model.sugar.SuperTypeQuery;
import org.eclipse.scout.sdk.core.model.sugar.TypeQuery;
import org.eclipse.scout.sdk.core.signature.Signature;
import org.eclipse.scout.sdk.core.util.CoreUtils;

public class TypeImplementor
extends AbstractMemberImplementor<TypeSpi>
implements IType {
    private String m_signature;
    private static final Pattern PRIMITIVE_TYPE_ASSIGNABLE_PAT = Pattern.compile("(char=(char|Character)|byte=(byte|Byte)|short=(short|Short)|int=(int|Integer)|long=(long|Long)|float=(float|Float)|double=(double|Double)|Character=(char|Character)|Byte=(byte|Byte)|Short=(short|Short)|Integer=(int|Integer)|Long=(long|Long)|Float=(float|Float)|Double=(double|Double))");

    public TypeImplementor(TypeSpi spi) {
        super(spi);
    }

    @Override
    public boolean isArray() {
        return ((TypeSpi)this.m_spi).isArray();
    }

    @Override
    public int arrayDimension() {
        return ((TypeSpi)this.m_spi).getArrayDimension();
    }

    @Override
    public IType leafComponentType() {
        return JavaEnvironmentImplementor.wrapType(((TypeSpi)this.m_spi).getLeafComponentType());
    }

    @Override
    public boolean isPrimitive() {
        return ((TypeSpi)this.m_spi).isPrimitive();
    }

    @Override
    public boolean isParameterType() {
        return ((TypeSpi)this.m_spi).isAnonymous();
    }

    @Override
    public String name() {
        return ((TypeSpi)this.m_spi).getName();
    }

    @Override
    public IPackage containingPackage() {
        return ((TypeSpi)this.m_spi).getPackage().wrap();
    }

    @Override
    public IType superClass() {
        return JavaEnvironmentImplementor.wrapType(((TypeSpi)this.m_spi).getSuperClass());
    }

    @Override
    public List<IType> superInterfaces() {
        return new WrappedList<IType>(((TypeSpi)this.m_spi).getSuperInterfaces());
    }

    @Override
    public List<IType> typeArguments() {
        return new WrappedList<IType>(((TypeSpi)this.m_spi).getTypeArguments());
    }

    @Override
    public IType originalType() {
        return ((TypeSpi)this.m_spi).getOriginalType().wrap();
    }

    @Override
    public ICompilationUnit compilationUnit() {
        return ((TypeSpi)this.m_spi).getCompilationUnit().wrap();
    }

    @Override
    public boolean isWildcardType() {
        return ((TypeSpi)this.m_spi).isWildcardType();
    }

    @Override
    public ISourceRange sourceOfStaticInitializer() {
        return ((TypeSpi)this.m_spi).getSourceOfStaticInitializer();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        JavaModelPrinter.print(this, sb);
        return sb.toString();
    }

    @Override
    public void internalSetSpi(JavaElementSpi spi) {
        super.internalSetSpi(spi);
        this.m_signature = null;
    }

    @Override
    public boolean isVoid() {
        return this.name().equals("void");
    }

    @Override
    public boolean isInterface() {
        return Flags.isInterface(this.flags());
    }

    @Override
    public String signature() {
        if (this.m_signature == null) {
            StringBuilder builder = new StringBuilder();
            TypeImplementor.buildSignatureRec(this, builder);
            int len = builder.length();
            char[] expr = new char[len];
            builder.getChars(0, len, expr, 0);
            this.m_signature = Signature.createTypeSignature(expr, true);
        }
        return this.m_signature;
    }

    protected static void buildSignatureRec(IType type, StringBuilder builder) {
        List<IType> typeArgs;
        boolean isWildCardOnly;
        if (type.isArray()) {
            TypeImplementor.buildSignatureRec(type.leafComponentType(), builder);
            int i = 0;
            while (i < type.arrayDimension()) {
                builder.append('[');
                builder.append(']');
                ++i;
            }
            return;
        }
        String name = type.name();
        boolean bl = isWildCardOnly = name == null;
        if (type.isWildcardType()) {
            builder.append('?');
            if (isWildCardOnly) {
                return;
            }
            builder.append(" extends ");
        }
        if (!isWildCardOnly) {
            builder.append(name);
        }
        if ((typeArgs = type.typeArguments()).size() > 0) {
            builder.append('<');
            TypeImplementor.buildSignatureRec(typeArgs.get(0), builder);
            int i = 1;
            while (i < typeArgs.size()) {
                builder.append(',');
                TypeImplementor.buildSignatureRec(typeArgs.get(i), builder);
                ++i;
            }
            builder.append('>');
        }
    }

    @Override
    public AnnotationQuery<IAnnotation> annotations() {
        return new AnnotationQuery<IAnnotation>(this, (AnnotatableSpi)this.m_spi);
    }

    @Override
    public SuperTypeQuery superTypes() {
        return new SuperTypeQuery(this);
    }

    @Override
    public TypeQuery innerTypes() {
        return new TypeQuery(new WrappedList<IType>(((TypeSpi)this.m_spi).getTypes()));
    }

    @Override
    public MethodQuery methods() {
        return new MethodQuery(this);
    }

    @Override
    public FieldQuery fields() {
        return new FieldQuery(this);
    }

    @Override
    public boolean isInstanceOf(String queryType) {
        return this.superTypes().withName(queryType).existsAny();
    }

    @Override
    public boolean isAssignableFrom(IType specificClass) {
        if (this.isPrimitive() || specificClass.isPrimitive()) {
            return PRIMITIVE_TYPE_ASSIGNABLE_PAT.matcher(String.valueOf(this.elementName()) + '=' + specificClass.elementName()).matches();
        }
        if (this.isArray() || specificClass.isArray()) {
            return this.name().equals(specificClass.name());
        }
        return specificClass.superTypes().withName(this.name()).existsAny();
    }

    @Override
    public IType boxPrimitiveType() {
        if (!this.isPrimitive()) {
            return this;
        }
        String boxedFqn = CoreUtils.boxPrimitive(this.name());
        if (boxedFqn == null) {
            return this;
        }
        return this.javaEnvironment().findType(boxedFqn);
    }

    @Override
    public IType unboxPrimitiveType() {
        String s = this.name();
        if (s.length() > 19) {
            return null;
        }
        String unboxed = CoreUtils.unboxToPrimitive(s);
        if (unboxed == null) {
            return null;
        }
        return this.javaEnvironment().findType(unboxed);
    }
}

