/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.model.spi.internal;

import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.eclipse.scout.sdk.core.model.api.ICompilationUnit;
import org.eclipse.scout.sdk.core.model.api.ISourceRange;
import org.eclipse.scout.sdk.core.model.api.internal.CompilationUnitImplementor;
import org.eclipse.scout.sdk.core.model.spi.CompilationUnitSpi;
import org.eclipse.scout.sdk.core.model.spi.ImportSpi;
import org.eclipse.scout.sdk.core.model.spi.JavaElementSpi;
import org.eclipse.scout.sdk.core.model.spi.PackageSpi;
import org.eclipse.scout.sdk.core.model.spi.TypeSpi;
import org.eclipse.scout.sdk.core.model.spi.internal.AbstractJavaElementWithJdt;
import org.eclipse.scout.sdk.core.model.spi.internal.BindingTypeWithJdt;
import org.eclipse.scout.sdk.core.model.spi.internal.JavaEnvironmentWithJdt;

public class SyntheticCompilationUnitWithJdt
extends AbstractJavaElementWithJdt<ICompilationUnit>
implements CompilationUnitSpi {
    private final TypeSpi m_mainType;

    SyntheticCompilationUnitWithJdt(JavaEnvironmentWithJdt env, BindingTypeWithJdt mainType) {
        super(env);
        this.m_mainType = (TypeSpi)Validate.notNull((Object)mainType);
    }

    @Override
    protected JavaElementSpi internalFindNewElement(JavaEnvironmentWithJdt newEnv) {
        TypeSpi newType = newEnv.findType(this.m_mainType.getName());
        if (newType != null) {
            return newType.getCompilationUnit();
        }
        return null;
    }

    @Override
    protected ICompilationUnit internalCreateApi() {
        return new CompilationUnitImplementor(this);
    }

    protected static char[] computeUniqueKey(BindingTypeWithJdt mainType) {
        return mainType.getName().toCharArray();
    }

    @Override
    public boolean isSynthetic() {
        return true;
    }

    @Override
    public PackageSpi getPackage() {
        return this.m_mainType.getPackage();
    }

    @Override
    public TypeSpi findTypeBySimpleName(String simpleName) {
        throw new UnsupportedOperationException("not supported in synthetic binary compilation unit");
    }

    @Override
    public String getElementName() {
        return String.valueOf(this.m_mainType.getElementName()) + ".java";
    }

    @Override
    public TypeSpi getMainType() {
        return this.m_mainType;
    }

    public List<TypeSpi> getTypes() {
        return Collections.singletonList(this.m_mainType);
    }

    public List<ImportSpi> getImports() {
        return Collections.emptyList();
    }

    @Override
    public ISourceRange getSource() {
        return ISourceRange.NO_SOURCE;
    }

    @Override
    public ISourceRange getJavaDoc() {
        return ISourceRange.NO_SOURCE;
    }
}

