/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.model.sugar;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import org.eclipse.scout.sdk.core.model.api.IType;
import org.eclipse.scout.sdk.core.model.api.internal.WrappedList;

public class TypeQuery {
    private final List<IType> m_types;
    private boolean m_includeRecursiveInnerTypes = false;
    private String m_name;
    private String m_simpleName;
    private String m_instanceOfFqn;
    private Predicate<IType> m_filter;
    private int m_flags = -1;
    private int m_maxResultCount = Integer.MAX_VALUE;

    public TypeQuery(List<IType> types) {
        this.m_types = types;
    }

    public TypeQuery withRecursiveInnerTypes(boolean b) {
        this.m_includeRecursiveInnerTypes = b;
        return this;
    }

    public TypeQuery withFlags(int flags) {
        this.m_flags = flags;
        return this;
    }

    public TypeQuery withName(String fullyQualifiedName) {
        this.m_name = fullyQualifiedName;
        return this;
    }

    public TypeQuery withSimpleName(String simpleName) {
        this.m_simpleName = simpleName;
        return this;
    }

    public TypeQuery withInstanceOf(String typeFqn) {
        this.m_instanceOfFqn = typeFqn;
        return this;
    }

    public TypeQuery withFilter(Predicate<IType> filter) {
        this.m_filter = filter;
        return this;
    }

    public TypeQuery withMaxResultCount(int maxResultCount) {
        this.m_maxResultCount = maxResultCount;
        return this;
    }

    protected boolean accept(IType t) {
        if (this.m_name != null && !this.m_name.equals(t.name())) {
            return false;
        }
        if (this.m_simpleName != null && !this.m_simpleName.equals(t.elementName())) {
            return false;
        }
        if (this.m_flags >= 0 && (t.flags() & this.m_flags) != this.m_flags) {
            return false;
        }
        if (this.m_filter != null && !this.m_filter.test(t)) {
            return false;
        }
        return this.m_instanceOfFqn == null || t.isInstanceOf(this.m_instanceOfFqn);
    }

    protected void visitRec(List<IType> types, List<IType> result, int maxCount) {
        if (types == null || types.isEmpty()) {
            return;
        }
        for (IType t : types) {
            if (!this.accept(t)) continue;
            result.add(t);
            if (result.size() < maxCount) continue;
            return;
        }
        if (this.m_includeRecursiveInnerTypes) {
            for (IType t : types) {
                this.visitRec(new WrappedList<IType>(t.unwrap().getTypes()), result, maxCount);
                if (result.size() < maxCount) continue;
                return;
            }
        }
    }

    public boolean existsAny() {
        return this.first() != null;
    }

    public IType first() {
        ArrayList<IType> result = new ArrayList<IType>(1);
        this.visitRec(this.m_types, result, 1);
        return result.isEmpty() ? null : (IType)result.get(0);
    }

    public List<IType> list() {
        ArrayList<IType> result = new ArrayList<IType>(this.m_types.size());
        this.visitRec(this.m_types, result, this.m_maxResultCount);
        return result;
    }
}

