/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.text.translate.AggregateTranslator;
import org.apache.commons.lang3.text.translate.CharSequenceTranslator;
import org.apache.commons.lang3.text.translate.EntityArrays;
import org.apache.commons.lang3.text.translate.LookupTranslator;
import org.eclipse.scout.sdk.core.importcollector.ImportCollector;
import org.eclipse.scout.sdk.core.importvalidator.ImportValidator;
import org.eclipse.scout.sdk.core.model.api.IJavaEnvironment;
import org.eclipse.scout.sdk.core.model.api.IMethod;
import org.eclipse.scout.sdk.core.model.api.IMethodParameter;
import org.eclipse.scout.sdk.core.model.api.IPropertyBean;
import org.eclipse.scout.sdk.core.model.api.IType;
import org.eclipse.scout.sdk.core.model.api.internal.PropertyBean;
import org.eclipse.scout.sdk.core.signature.SignatureUtils;
import org.eclipse.scout.sdk.core.sourcebuilder.ISourceBuilder;
import org.eclipse.scout.sdk.core.util.PropertyMap;
import org.eclipse.scout.sdk.core.util.SdkLog;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class CoreUtils {
    public static final Pattern BEAN_METHOD_NAME = Pattern.compile("(get|set|is)([A-Z].*)");
    private static final Pattern REGEX_COMMENT_REMOVE_1 = Pattern.compile("\\/\\/.*?\\\r\\\n");
    private static final Pattern REGEX_COMMENT_REMOVE_2 = Pattern.compile("\\/\\/.*?\\\n");
    private static final Pattern REGEX_COMMENT_REMOVE_3 = Pattern.compile("(?s)\\/\\*.*?\\*\\/");
    private static final Pattern PATH_SEGMENT_SPLIT_PATTERN = Pattern.compile("\\/");
    private static final ThreadLocal<String> CURRENT_USER_NAME = new ThreadLocal();
    private static volatile Set<String> javaKeyWords = null;

    private CoreUtils() {
    }

    public static String[] generateKeyPair() throws GeneralSecurityException {
        KeyPairGenerator keyGen = KeyPairGenerator.getInstance("EC", "SunEC");
        SecureRandom random = SecureRandom.getInstance("SHA1PRNG", "SUN");
        ECGenParameterSpec spec = new ECGenParameterSpec("secp256k1");
        keyGen.initialize(spec, random);
        KeyPair keyPair = keyGen.generateKeyPair();
        X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(keyPair.getPublic().getEncoded());
        PKCS8EncodedKeySpec pkcs8EncodedKeySpec = new PKCS8EncodedKeySpec(keyPair.getPrivate().getEncoded());
        Base64.Encoder base64Encoder = Base64.getEncoder();
        return new String[]{base64Encoder.encodeToString(pkcs8EncodedKeySpec.getEncoded()), base64Encoder.encodeToString(x509EncodedKeySpec.getEncoded())};
    }

    public static void deleteDirectory(File toDelete) throws IOException {
        Validate.notNull((Object)toDelete);
        if (!toDelete.exists()) {
            return;
        }
        Files.walkFileTree(toDelete.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public static String removeComments(String methodBody) {
        if (methodBody == null) {
            return null;
        }
        String retVal = methodBody;
        retVal = REGEX_COMMENT_REMOVE_1.matcher(retVal).replaceAll("");
        retVal = REGEX_COMMENT_REMOVE_2.matcher(retVal).replaceAll("");
        retVal = REGEX_COMMENT_REMOVE_3.matcher(retVal).replaceAll("");
        return retVal;
    }

    public static StringBuilder inputStreamToString(InputStream is, String charsetName) throws IOException {
        if (!Charset.isSupported(charsetName)) {
            throw new IOException("Charset '" + charsetName + "' is not supported.");
        }
        return CoreUtils.inputStreamToString(is, Charset.forName(charsetName));
    }

    public static String getGetterMethodPrefix(String returnTypeSignature) {
        if ("Z".equals(returnTypeSignature)) {
            return "is";
        }
        return "get";
    }

    public static StringBuilder inputStreamToString(InputStream is, Charset charset) throws IOException {
        char[] buffer = new char[8192];
        StringBuilder out = new StringBuilder();
        int length = 0;
        InputStreamReader in = new InputStreamReader(is, charset);
        while ((length = in.read(buffer)) != -1) {
            out.append(buffer, 0, length);
        }
        return out;
    }

    public static String fromStringLiteral(String s) {
        if (s == null) {
            return null;
        }
        int len = s.length();
        if (len < 2 || s.charAt(0) != '\"' || s.charAt(len - 1) != '\"') {
            return null;
        }
        return CoreUtils.replaceLiterals(s.substring(1, len - 1), true);
    }

    private static String replaceLiterals(String result, boolean fromLiteral) {
        String[] a = new String[]{"\b", "\t", "\n", "\f", "\r", "\"", "\\", "\u0000", "\u0001", "\u0002", "\u0003", "\u0004", "\u0005", "\u0006", "\u0007"};
        String[] b = new String[]{"\\b", "\\t", "\\n", "\\f", "\\r", "\\\"", "\\\\", "\\0", "\\1", "\\2", "\\3", "\\4", "\\5", "\\6", "\\7"};
        if (fromLiteral) {
            return StringUtils.replaceEach((String)result, (String[])b, (String[])a);
        }
        return StringUtils.replaceEach((String)result, (String[])a, (String[])b);
    }

    public static String toStringLiteral(String s) {
        if (s == null) {
            return null;
        }
        StringBuilder b = new StringBuilder(s.length() * 2);
        b.append('\"');
        b.append(CoreUtils.replaceLiterals(s, false));
        b.append('\"');
        return b.toString();
    }

    public static String ensureStartWithLowerCase(String name) {
        if (StringUtils.isBlank((CharSequence)name)) {
            return name;
        }
        char firstChar = name.charAt(0);
        if (Character.isLowerCase(firstChar)) {
            return name;
        }
        StringBuilder sb = new StringBuilder(name.length());
        sb.append(Character.toLowerCase(firstChar));
        if (name.length() > 1) {
            sb.append(name.substring(1));
        }
        return sb.toString();
    }

    public static String ensureStartWithUpperCase(String name) {
        if (StringUtils.isBlank((CharSequence)name)) {
            return name;
        }
        char firstChar = name.charAt(0);
        if (Character.isUpperCase(firstChar)) {
            return name;
        }
        StringBuilder sb = new StringBuilder(name.length());
        sb.append(Character.toUpperCase(firstChar));
        if (name.length() > 1) {
            sb.append(name.substring(1));
        }
        return sb.toString();
    }

    public static String getCommentBlock(String content) {
        StringBuilder builder = new StringBuilder();
        builder.append("// TODO ");
        String username = CoreUtils.getUsername();
        if (StringUtils.isNotBlank((CharSequence)username)) {
            builder.append('[').append(username).append("] ");
        }
        builder.append(content);
        return builder.toString();
    }

    public static String getCommentAutoGeneratedMethodStub() {
        return CoreUtils.getCommentBlock("Auto-generated method stub.");
    }

    public static String getUsername() {
        String name = CURRENT_USER_NAME.get();
        if (name == null) {
            name = SystemUtils.USER_NAME;
        }
        return name;
    }

    public static void setUsernameForThread(String newUsernameForCurrentThread) {
        CURRENT_USER_NAME.set(newUsernameForCurrentThread);
    }

    public static String getDefaultValueOf(String signature) {
        if (signature == null) {
            return null;
        }
        if (signature.length() == 1) {
            switch (signature.charAt(0)) {
                case 'Z': {
                    return Boolean.FALSE.toString();
                }
                case 'B': 
                case 'C': 
                case 'I': 
                case 'S': {
                    return "0";
                }
                case 'D': {
                    return "0.0";
                }
                case 'J': {
                    return "0L";
                }
                case 'F': {
                    return "0.0f";
                }
            }
            return null;
        }
        switch (signature) {
            case "Ljava.lang.Boolean;": {
                return "Boolean.FALSE";
            }
            case "Ljava.lang.Byte;": {
                return "Byte.valueOf((byte)0)";
            }
            case "Ljava.lang.Character;": {
                return "Character.valueOf((char)0)";
            }
            case "Ljava.lang.Double;": {
                return "Double.valueOf(0.0)";
            }
            case "Ljava.lang.Float;": {
                return "Float.valueOf(0.0f)";
            }
            case "Ljava.lang.Integer;": {
                return "Integer.valueOf(0)";
            }
            case "Ljava.lang.Long;": {
                return "Long.valueOf(0L)";
            }
            case "Ljava.lang.Short;": {
                return "Short.valueOf((short)0)";
            }
            case "Ljava.lang.Void;": {
                return null;
            }
        }
        return "null";
    }

    public static String ensureValidParameterName(String parameterName) {
        if (CoreUtils.isReservedJavaKeyword(parameterName)) {
            return String.valueOf(parameterName) + "Value";
        }
        return parameterName;
    }

    public static boolean isReservedJavaKeyword(String word) {
        if (word == null) {
            return false;
        }
        return CoreUtils.getJavaKeyWords().contains(word.toLowerCase());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Set<String> getJavaKeyWords() {
        if (javaKeyWords != null) return javaKeyWords;
        Class<CoreUtils> clazz = CoreUtils.class;
        synchronized (CoreUtils.class) {
            if (javaKeyWords != null) return javaKeyWords;
            String[] keyWords = new String[]{"abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "enum", "extends", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "try", "void", "volatile", "while", "false", "null", "true"};
            HashSet<String> tmp = new HashSet<String>(keyWords.length);
            String[] stringArray = keyWords;
            int n = keyWords.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                tmp.add(s);
                ++n2;
            }
            javaKeyWords = Collections.unmodifiableSet(tmp);
            // ** MonitorExit[var0] (shouldn't be in output)
            return javaKeyWords;
        }
    }

    public static List<String> getResolvedTypeParamValueSignature(IType focusType, String levelFqn, int typeParamIndex) {
        List<IType> typeParamsValue = CoreUtils.getResolvedTypeParamValue(focusType, levelFqn, typeParamIndex);
        if (typeParamsValue.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>(typeParamsValue.size());
        for (IType t : typeParamsValue) {
            result.add(SignatureUtils.getTypeSignature(t));
        }
        return result;
    }

    public static List<IType> getResolvedTypeParamValue(IType focusType, String levelFqn, int typeParamIndex) {
        IType levelType = focusType.superTypes().withName(levelFqn).first();
        return CoreUtils.getResolvedTypeParamValue(focusType, levelType, typeParamIndex);
    }

    public static List<IType> getResolvedTypeParamValue(IType focusType, IType levelType, int typeParamIndex) {
        if (levelType == null) {
            return Collections.emptyList();
        }
        List<IType> typeArguments = levelType.typeArguments();
        if (typeArguments.size() <= typeParamIndex) {
            return Collections.emptyList();
        }
        IType item = typeArguments.get(typeParamIndex);
        if (!item.isParameterType()) {
            return Arrays.asList(item);
        }
        IType superClassGeneric = item.superClass();
        List<IType> superIfcGenerics = item.superInterfaces();
        ArrayList<IType> result = null;
        if (superClassGeneric != null) {
            result = new ArrayList(superIfcGenerics.size() + 1);
            result.add(superClassGeneric);
        } else {
            result = new ArrayList<IType>(superIfcGenerics.size());
        }
        result.addAll(superIfcGenerics);
        return result;
    }

    public static IType findInnerTypeInSuperHierarchy(IType declaringType, Predicate<IType> filter) {
        if (declaringType == null) {
            return null;
        }
        IType innerType = declaringType.innerTypes().withFilter(filter).first();
        if (innerType != null) {
            return innerType;
        }
        return CoreUtils.findInnerTypeInSuperHierarchy(declaringType.superClass(), filter);
    }

    public static List<IPropertyBean> getPropertyBeans(IType type, Predicate<IPropertyBean> propertyFilter, Comparator<IPropertyBean> comparator) {
        List<IMethod> methods = type.methods().withFlags(1).withName(BEAN_METHOD_NAME).list();
        HashMap<String, PropertyBean> beans = new HashMap<String, PropertyBean>(methods.size());
        for (IMethod m : methods) {
            PropertyBean desc;
            boolean isBool;
            Matcher matcher = BEAN_METHOD_NAME.matcher(m.elementName());
            if (!matcher.matches()) continue;
            String kind = matcher.group(1);
            String name = matcher.group(2);
            List<IMethodParameter> parameterTypes = m.parameters().list();
            IType returnType = m.returnType();
            if ("get".equals(kind) && parameterTypes.size() == 0 && !returnType.isVoid()) {
                PropertyBean desc2 = (PropertyBean)beans.get(name);
                if (desc2 == null) {
                    desc2 = new PropertyBean(type, name);
                    beans.put(name, desc2);
                }
                if (desc2.readMethod() != null) continue;
                desc2.setReadMethod(m);
                continue;
            }
            boolean bl = isBool = "java.lang.Boolean".equals(returnType.name()) || "boolean".equals(returnType.name());
            if ("is".equals(kind) && parameterTypes.size() == 0 && isBool) {
                desc = (PropertyBean)beans.get(name);
                if (desc == null) {
                    desc = new PropertyBean(type, name);
                    beans.put(name, desc);
                }
                if (desc.readMethod() != null) continue;
                desc.setReadMethod(m);
                continue;
            }
            if (!"set".equals(kind) || parameterTypes.size() != 1 || !returnType.isVoid()) continue;
            desc = (PropertyBean)beans.get(name);
            if (desc == null) {
                desc = new PropertyBean(type, name);
                beans.put(name, desc);
            }
            if (desc.writeMethod() != null) continue;
            desc.setWriteMethod(m);
        }
        ArrayList<IPropertyBean> l = new ArrayList<IPropertyBean>(beans.size());
        if (propertyFilter == null) {
            l.addAll(beans.values());
        } else {
            for (PropertyBean bean : beans.values()) {
                if (!propertyFilter.test(bean)) continue;
                l.add(bean);
            }
        }
        if (comparator != null && !l.isEmpty()) {
            Collections.sort(l, comparator);
        }
        return l;
    }

    public static boolean isOnClasspath(IJavaEnvironment env, String typeToSearchFqn) {
        if (StringUtils.isBlank((CharSequence)typeToSearchFqn)) {
            return false;
        }
        return env.findType(typeToSearchFqn) != null;
    }

    public static boolean isOnClasspath(IJavaEnvironment env, IType typeToSearch) {
        if (typeToSearch == null) {
            return false;
        }
        return CoreUtils.isOnClasspath(env, typeToSearch.name());
    }

    public static IType getPrimaryType(IType t) {
        IType result = null;
        IType tmp = t;
        while (tmp != null) {
            result = tmp;
            tmp = tmp.declaringType();
        }
        return result;
    }

    public static String boxPrimitive(String name) {
        if (name == null) {
            return null;
        }
        switch (name) {
            case "boolean": {
                return "java.lang.Boolean";
            }
            case "char": {
                return "java.lang.Character";
            }
            case "byte": {
                return "java.lang.Byte";
            }
            case "short": {
                return "java.lang.Short";
            }
            case "int": {
                return "java.lang.Integer";
            }
            case "long": {
                return "java.lang.Long";
            }
            case "float": {
                return "java.lang.Float";
            }
            case "double": {
                return "java.lang.Double";
            }
            case "void": {
                return "java.lang.Void";
            }
            case "java.lang.Integer": 
            case "java.lang.Float": 
            case "java.lang.Short": 
            case "java.lang.Character": 
            case "java.lang.Boolean": 
            case "java.lang.Byte": 
            case "java.lang.Long": 
            case "java.lang.Void": 
            case "java.lang.Double": {
                return name;
            }
        }
        return null;
    }

    public static String unboxToPrimitive(String fqn) {
        if (fqn == null) {
            return null;
        }
        switch (fqn) {
            case "java.lang.Boolean": {
                return "boolean";
            }
            case "java.lang.Character": {
                return "char";
            }
            case "java.lang.Byte": {
                return "byte";
            }
            case "java.lang.Short": {
                return "short";
            }
            case "java.lang.Integer": {
                return "int";
            }
            case "java.lang.Long": {
                return "long";
            }
            case "java.lang.Float": {
                return "float";
            }
            case "java.lang.Double": {
                return "double";
            }
            case "java.lang.Void": {
                return "void";
            }
            case "double": 
            case "int": 
            case "byte": 
            case "char": 
            case "long": 
            case "void": 
            case "boolean": 
            case "float": 
            case "short": {
                return fqn;
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getThrowableAsString(Throwable t) {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try {
                StringWriter w = new StringWriter();
                try {
                    String string;
                    block16: {
                        PrintWriter p = new PrintWriter(w);
                        try {
                            p.println();
                            t.printStackTrace(p);
                            string = w.toString();
                            return string;
                        }
                        finally {
                            if (p == null) break block16;
                            p.close();
                        }
                    }
                    if (w != null) {
                        w.close();
                    }
                    return string;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (w == null) throw throwable;
                    w.close();
                    throw throwable;
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                }
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
                throw throwable;
            }
        }
        catch (IOException e) {
            return String.valueOf('[') + e.toString() + ']' + t.toString();
        }
    }

    public static String createJavaCode(ISourceBuilder srcBuilder, IJavaEnvironment env, String lineSeparator, PropertyMap context) {
        if (srcBuilder == null || env == null) {
            return null;
        }
        if (lineSeparator == null) {
            lineSeparator = "\n";
        }
        ImportValidator validator = new ImportValidator(new ImportCollector(env));
        StringBuilder sourceBuilder = new StringBuilder();
        srcBuilder.createSource(sourceBuilder, lineSeparator, context, validator);
        return sourceBuilder.toString();
    }

    public static String escapeHtml(CharSequence html) {
        return new AggregateTranslator(new CharSequenceTranslator[]{new LookupTranslator((CharSequence[][])new String[][]{{"/", "&#47;"}}), new LookupTranslator((CharSequence[][])EntityArrays.BASIC_ESCAPE()), new LookupTranslator((CharSequence[][])EntityArrays.APOS_ESCAPE())}).translate(html);
    }

    public static DocumentBuilder createDocumentBuilder() throws ParserConfigurationException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        HashMap<String, Boolean> features = new HashMap<String, Boolean>(5);
        features.put("http://apache.org/xml/features/disallow-doctype-decl", Boolean.TRUE);
        features.put("http://xml.org/sax/features/external-general-entities", Boolean.FALSE);
        features.put("http://xml.org/sax/features/external-parameter-entities", Boolean.FALSE);
        features.put("http://apache.org/xml/features/nonvalidating/load-external-dtd", Boolean.FALSE);
        features.put("http://javax.xml.XMLConstants/feature/secure-processing", Boolean.TRUE);
        dbf.setXIncludeAware(false);
        dbf.setExpandEntityReferences(false);
        dbf.setNamespaceAware(true);
        try {
            dbf.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        }
        catch (IllegalArgumentException e) {
            SdkLog.debug("Attribute '{}' is not supported in the current DocumentBuilderFactory: {}", "http://javax.xml.XMLConstants/property/accessExternalDTD", dbf.getClass().getName(), e);
        }
        try {
            dbf.setAttribute("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
        }
        catch (IllegalArgumentException e) {
            SdkLog.debug("Attribute '{}' is not supported in the current DocumentBuilderFactory: {}", "http://javax.xml.XMLConstants/property/accessExternalDTD", dbf.getClass().getName(), e);
        }
        for (Map.Entry a : features.entrySet()) {
            String feature = (String)a.getKey();
            boolean enabled = (Boolean)a.getValue();
            try {
                dbf.setFeature(feature, enabled);
            }
            catch (ParserConfigurationException e) {
                SdkLog.debug("Feature '{}' is not supported in the current XML parser. Skipping.", feature, e);
            }
        }
        return dbf.newDocumentBuilder();
    }

    public static Transformer createTransformer(boolean format) throws TransformerConfigurationException {
        TransformerFactory tf = TransformerFactory.newInstance();
        int indent = 2;
        try {
            tf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        }
        catch (TransformerConfigurationException e) {
            SdkLog.debug("Feature '{}' is not supported in the current TransformerFactory: {}", "http://javax.xml.XMLConstants/feature/secure-processing", tf.getClass().getName(), e);
        }
        HashMap<String, Object> attribs = new HashMap<String, Object>(3);
        attribs.put("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        attribs.put("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
        if (format) {
            attribs.put("indent-number", 2);
        }
        for (Map.Entry a : attribs.entrySet()) {
            try {
                tf.setAttribute((String)a.getKey(), a.getValue());
            }
            catch (IllegalArgumentException e) {
                SdkLog.debug("Attribute '{}' is not supported in the current TransformerFactory: {}", a.getKey(), tf.getClass().getName(), e);
            }
        }
        Transformer transformer = tf.newTransformer();
        HashMap<String, String> outputProps = new HashMap<String, String>(4);
        outputProps.put("encoding", StandardCharsets.UTF_8.name());
        outputProps.put("method", "xml");
        if (format) {
            outputProps.put("indent", "yes");
            outputProps.put("{http://xml.apache.org/xslt}indent-amount", Integer.toString(2));
        } else {
            outputProps.put("indent", "no");
        }
        for (Map.Entry o : outputProps.entrySet()) {
            try {
                transformer.setOutputProperty((String)o.getKey(), (String)o.getValue());
            }
            catch (IllegalArgumentException e) {
                SdkLog.debug("Error applying output property '{}' on transformer of class '{}'.", o.getKey(), transformer.getClass().getName(), e);
            }
        }
        return transformer;
    }

    public static void moveDirectory(File sourceDir, File targetDir) throws IOException {
        Validate.notNull((Object)sourceDir);
        Validate.isTrue((boolean)sourceDir.isDirectory());
        Validate.notNull((Object)targetDir);
        Validate.isTrue((boolean)targetDir.isDirectory());
        final Path sourcePath = sourceDir.toPath();
        final Path targetPath = new File(targetDir, sourceDir.getName()).toPath();
        Files.createDirectories(targetPath, new FileAttribute[0]);
        if (Objects.equals(Files.getFileStore(sourcePath), Files.getFileStore(targetPath))) {
            Files.move(sourcePath, targetPath, StandardCopyOption.REPLACE_EXISTING);
        } else {
            Files.walkFileTree(sourcePath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Files.copy(file, targetPath.resolve(sourcePath.relativize(file)), new CopyOption[0]);
                    Files.delete(file);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    Files.createDirectories(targetPath.resolve(sourcePath.relativize(dir)), new FileAttribute[0]);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    Files.delete(dir);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
    }

    public static Element getFirstChildElement(Element parent, String tagName) {
        if (parent == null) {
            return null;
        }
        if (tagName == null) {
            return null;
        }
        NodeList children = parent.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node n = children.item(i);
            String nodeName = n.getLocalName();
            if (n.getNodeType() == 1 && Objects.equals(nodeName, tagName)) {
                return (Element)n;
            }
            ++i;
        }
        return null;
    }

    public static List<Element> evaluateXPath(String xPath, Document applyToDocument) throws XPathExpressionException {
        return CoreUtils.evaluateXPath(xPath, applyToDocument, null);
    }

    public static List<Element> evaluateXPath(String xPath, Document applyToDocument, String prefix, String namespace) throws XPathExpressionException {
        return CoreUtils.evaluateXPath(xPath, applyToDocument, Collections.singletonMap(prefix, namespace));
    }

    public static List<Element> evaluateXPath(String xPath, final Document applyToDocument, final Map<String, String> usedPprefixToNamespaceMap) throws XPathExpressionException {
        if (applyToDocument == null || StringUtils.isBlank((CharSequence)xPath)) {
            return Collections.emptyList();
        }
        XPathFactory xPathfactory = XPathFactory.newInstance();
        XPath xpath = xPathfactory.newXPath();
        xpath.setNamespaceContext(new NamespaceContext(){

            @Override
            public String getNamespaceURI(String prefix) {
                String ns;
                if (usedPprefixToNamespaceMap != null && (ns = (String)usedPprefixToNamespaceMap.get(prefix)) != null) {
                    return ns;
                }
                return applyToDocument.lookupNamespaceURI(prefix);
            }

            public Iterator<?> getPrefixes(String val) {
                return Collections.singletonList(this.getPrefix(val)).iterator();
            }

            @Override
            public String getPrefix(String uri) {
                if (usedPprefixToNamespaceMap != null) {
                    for (Map.Entry entry : usedPprefixToNamespaceMap.entrySet()) {
                        if (!((String)entry.getValue()).equals(uri)) continue;
                        return (String)entry.getKey();
                    }
                }
                return applyToDocument.lookupPrefix(uri);
            }
        });
        XPathExpression expr = xpath.compile(xPath);
        NodeList result = (NodeList)expr.evaluate(applyToDocument, XPathConstants.NODESET);
        int size = result.getLength();
        if (size < 1) {
            return Collections.emptyList();
        }
        ArrayList<Element> elements = new ArrayList<Element>(size);
        int i = 0;
        while (i < size) {
            Node n = result.item(i);
            if (n.getNodeType() == 1) {
                elements.add((Element)n);
            }
            ++i;
        }
        return elements;
    }

    public static URI relativizeURI(URI base, URI child) {
        if (!Objects.equals(base.getAuthority(), child.getAuthority()) || !Objects.equals(base.getScheme(), child.getScheme())) {
            return child;
        }
        base = base.normalize();
        child = child.normalize();
        String[] bParts = PATH_SEGMENT_SPLIT_PATTERN.split(base.getRawPath());
        String[] cParts = PATH_SEGMENT_SPLIT_PATTERN.split(child.getRawPath());
        if (bParts.length > 0 && !base.getPath().endsWith("/")) {
            bParts = Arrays.copyOf(bParts, bParts.length - 1);
        }
        int i = 0;
        while (i < bParts.length && i < cParts.length && bParts[i].equals(cParts[i])) {
            ++i;
        }
        StringBuilder sb = new StringBuilder();
        int j = 0;
        while (j < bParts.length - i) {
            sb.append("../");
            ++j;
        }
        j = i;
        while (j < cParts.length) {
            if (j != i) {
                sb.append('/');
            }
            sb.append(cParts[j]);
            ++j;
        }
        return URI.create(sb.toString()).normalize();
    }

    public static URI getParentURI(URI uri) {
        if (uri == null) {
            return null;
        }
        if (uri.getPath().endsWith("/")) {
            return uri.resolve("..");
        }
        return uri.resolve(".");
    }

    public static String xmlDocumentToString(Document document, boolean format) throws TransformerException {
        StringWriter out = new StringWriter();
        Transformer transformer = CoreUtils.createTransformer(format);
        transformer.transform(new DOMSource(document), new StreamResult(out));
        return out.toString();
    }
}

