/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.nls.internal.simpleproject;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.scout.sdk.core.util.SdkLog;
import org.eclipse.scout.sdk.s2e.nls.NlsCore;
import org.eclipse.scout.sdk.s2e.nls.internal.simpleproject.AbstractNlsFile;
import org.eclipse.scout.sdk.s2e.nls.internal.simpleproject.NlsType;
import org.eclipse.scout.sdk.s2e.nls.internal.simpleproject.SimpleNlsProject;
import org.eclipse.scout.sdk.s2e.nls.model.INlsProjectProvider;
import org.eclipse.scout.sdk.s2e.nls.project.INlsProject;
import org.eclipse.scout.sdk.s2e.util.S2eUtils;

public class SimpleNlsProjectProvider
implements INlsProjectProvider {
    private final Map<String, INlsProject> m_projects = new HashMap<String, INlsProject>();
    private static final Object LOCK = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected INlsProject getNlsProject(IType type) {
        if (type == null) {
            SdkLog.error((String)"NLS type cannot be null.", (Object[])new Object[0]);
            return null;
        }
        if (!type.exists()) {
            SdkLog.error((String)"NLS type '{}' does not exist.", (Object[])new Object[]{type.getFullyQualifiedName()});
            return null;
        }
        Object object = LOCK;
        synchronized (object) {
            NlsType t;
            INlsProject nlsProject = this.m_projects.get(type.getFullyQualifiedName());
            if (nlsProject == null && (t = new NlsType(type)).getTranslationsFolderName() != null) {
                nlsProject = new SimpleNlsProject(t);
                this.m_projects.put(type.getFullyQualifiedName(), nlsProject);
            }
            return nlsProject;
        }
    }

    @Override
    public INlsProject getProject(Object[] args) {
        if (args != null && args.length == 1) {
            IFile f;
            if (args[0] instanceof IType) {
                IType t = (IType)args[0];
                return this.getNlsProject(t);
            }
            if (args[0] instanceof IFile && (f = (IFile)args[0]).getName().toLowerCase().endsWith(".nls")) {
                try {
                    IJavaProject jp;
                    AbstractNlsFile nlsFile = AbstractNlsFile.loadNlsFile(f);
                    if (nlsFile.getNlsTypeName() != null && (jp = JavaCore.create((IProject)nlsFile.getProject())) != null) {
                        IType type = jp.findType(nlsFile.getNlsTypeName());
                        if (S2eUtils.exists((IJavaElement)type)) {
                            INlsProject simpleProj = this.getNlsProject(type);
                            if (simpleProj != null) {
                                return simpleProj;
                            }
                            return NlsCore.getNlsWorkspace().getNlsProject(type);
                        }
                        SdkLog.warning((String)"Could not find type '{}'.", (Object[])new Object[]{nlsFile.getNlsTypeName()});
                    }
                }
                catch (JavaModelException e) {
                    SdkLog.warning((String)"Could not load NlsFile: {}", (Object[])new Object[]{f.getFullPath().toString(), e});
                }
            }
        }
        return null;
    }
}

