/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.builder;

import java.io.IOException;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import org.eclipse.jdt.internal.compiler.classfmt.ExternalAnnotationDecorator;
import org.eclipse.jdt.internal.compiler.env.AccessRuleSet;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.env.IModule;
import org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;
import org.eclipse.jdt.internal.compiler.util.SimpleLookupTable;
import org.eclipse.jdt.internal.compiler.util.SuffixConstants;
import org.eclipse.jdt.internal.compiler.util.Util;
import org.eclipse.jdt.internal.core.builder.ClasspathLocation;

public class ClasspathDirectory
extends ClasspathLocation {
    IContainer binaryFolder;
    boolean isOutputFolder;
    SimpleLookupTable directoryCache;
    String[] missingPackageHolder = new String[1];
    AccessRuleSet accessRuleSet;
    ZipFile annotationZipFile;
    String externalAnnotationPath;

    ClasspathDirectory(IContainer binaryFolder, boolean isOutputFolder, AccessRuleSet accessRuleSet, IPath externalAnnotationPath, boolean isOnModulePath) {
        this.binaryFolder = binaryFolder;
        this.isOutputFolder = isOutputFolder || binaryFolder.getProjectRelativePath().isEmpty();
        this.directoryCache = new SimpleLookupTable(5);
        this.accessRuleSet = accessRuleSet;
        if (externalAnnotationPath != null) {
            this.externalAnnotationPath = externalAnnotationPath.toOSString();
        }
        this.isOnModulePath = isOnModulePath;
    }

    @Override
    public void cleanup() {
        if (this.annotationZipFile != null) {
            try {
                this.annotationZipFile.close();
            }
            catch (IOException iOException) {}
            this.annotationZipFile = null;
        }
        this.directoryCache = null;
    }

    IModule initializeModule() {
        IResource[] members = null;
        try {
            members = this.binaryFolder.members();
            if (members != null) {
                int i = 0;
                int l = members.length;
                while (i < l) {
                    IResource m = members[i];
                    String name = m.getName();
                    if (m.getType() == 1 && Util.isClassFileName(name) && name.equalsIgnoreCase("module-info.class")) {
                        try {
                            ClassFileReader cfr = org.eclipse.jdt.internal.core.util.Util.newClassFileReader(m);
                            return cfr.getModuleDeclaration();
                        }
                        catch (IOException | ClassFormatException e) {
                            e.printStackTrace();
                        }
                    }
                    ++i;
                }
            }
        }
        catch (CoreException e1) {
            e1.printStackTrace();
        }
        return null;
    }

    String[] directoryList(String qualifiedPackageName) {
        String[] dirList = (String[])this.directoryCache.get(qualifiedPackageName);
        if (dirList == this.missingPackageHolder) {
            return null;
        }
        if (dirList != null) {
            return dirList;
        }
        try {
            IResource container = this.binaryFolder.findMember(qualifiedPackageName);
            if (container instanceof IContainer) {
                IResource[] members = ((IContainer)container).members();
                dirList = new String[members.length];
                int index = 0;
                int i = 0;
                int l = members.length;
                while (i < l) {
                    IResource m = members[i];
                    String name = m.getName();
                    if (m.getType() == 1 && Util.isClassFileName(name)) {
                        dirList[index++] = name;
                    }
                    ++i;
                }
                if (index < dirList.length) {
                    String[] stringArray = dirList;
                    dirList = new String[index];
                    System.arraycopy(stringArray, 0, dirList, 0, index);
                }
                this.directoryCache.put(qualifiedPackageName, dirList);
                return dirList;
            }
        }
        catch (CoreException coreException) {}
        this.directoryCache.put(qualifiedPackageName, this.missingPackageHolder);
        return null;
    }

    boolean doesFileExist(String fileName, String qualifiedPackageName, String qualifiedFullName) {
        String[] dirList = this.directoryList(qualifiedPackageName);
        if (dirList == null) {
            return false;
        }
        int i = dirList.length;
        while (--i >= 0) {
            if (!fileName.equals(dirList[i])) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClasspathDirectory)) {
            return false;
        }
        ClasspathDirectory dir = (ClasspathDirectory)o;
        if (!(this.accessRuleSet == dir.accessRuleSet || this.accessRuleSet != null && this.accessRuleSet.equals(dir.accessRuleSet))) {
            return false;
        }
        if (this.isOnModulePath != dir.isOnModulePath) {
            return false;
        }
        return this.binaryFolder.equals((Object)dir.binaryFolder) && this.areAllModuleOptionsEqual(dir);
    }

    @Override
    public NameEnvironmentAnswer findClass(String binaryFileName, String qualifiedPackageName, String moduleName, String qualifiedBinaryFileName, boolean asBinaryOnly) {
        if (!this.doesFileExist(binaryFileName, qualifiedPackageName, qualifiedBinaryFileName)) {
            return null;
        }
        IBinaryType reader = null;
        try {
            reader = org.eclipse.jdt.internal.core.util.Util.newClassFileReader((IResource)this.binaryFolder.getFile((IPath)new Path(qualifiedBinaryFileName)));
        }
        catch (CoreException coreException) {
            return null;
        }
        catch (ClassFormatException classFormatException) {
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
        if (reader != null) {
            char[] modName;
            char[] cArray = modName = this.module == null ? null : this.module.name();
            if (reader instanceof ClassFileReader) {
                ClassFileReader cfReader = reader;
                if (cfReader.moduleName == null) {
                    cfReader.moduleName = modName;
                } else {
                    modName = cfReader.moduleName;
                }
            }
            String fileNameWithoutExtension = qualifiedBinaryFileName.substring(0, qualifiedBinaryFileName.length() - SuffixConstants.SUFFIX_CLASS.length);
            if (this.externalAnnotationPath != null) {
                try {
                    if (this.annotationZipFile == null) {
                        this.annotationZipFile = ExternalAnnotationDecorator.getAnnotationZipFile(this.externalAnnotationPath, null);
                    }
                    reader = ExternalAnnotationDecorator.create(reader, this.externalAnnotationPath, fileNameWithoutExtension, this.annotationZipFile);
                }
                catch (IOException iOException) {}
            }
            if (this.accessRuleSet == null) {
                return this.module == null ? new NameEnvironmentAnswer(reader, null) : new NameEnvironmentAnswer(reader, null, modName);
            }
            return new NameEnvironmentAnswer(reader, this.accessRuleSet.getViolatedRestriction(fileNameWithoutExtension.toCharArray()), modName);
        }
        return null;
    }

    @Override
    public IPath getProjectRelativePath() {
        return this.binaryFolder.getProjectRelativePath();
    }

    public int hashCode() {
        return this.binaryFolder == null ? super.hashCode() : this.binaryFolder.hashCode();
    }

    protected boolean isExcluded(IResource resource) {
        return false;
    }

    @Override
    public boolean isOutputFolder() {
        return this.isOutputFolder;
    }

    @Override
    public boolean isPackage(String qualifiedPackageName, String moduleName) {
        if (!(moduleName == null || this.module != null && moduleName.equals(String.valueOf(this.module.name())))) {
            return false;
        }
        return this.directoryList(qualifiedPackageName) != null;
    }

    @Override
    public boolean hasCompilationUnit(String qualifiedPackageName, String moduleName) {
        String[] dirList = this.directoryList(qualifiedPackageName);
        if (dirList != null) {
            String[] stringArray = dirList;
            int n = dirList.length;
            int n2 = 0;
            while (n2 < n) {
                String entry = stringArray[n2];
                String entryLC = entry.toLowerCase();
                if (entryLC.endsWith(".class") || entryLC.endsWith(".java")) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    @Override
    public void reset() {
        this.directoryCache = new SimpleLookupTable(5);
    }

    public String toString() {
        String start = "Binary classpath directory " + this.binaryFolder.getFullPath().toString();
        if (this.accessRuleSet == null) {
            return start;
        }
        return String.valueOf(start) + " with " + this.accessRuleSet;
    }

    @Override
    public String debugPathString() {
        return this.binaryFolder.getFullPath().toString();
    }

    @Override
    public NameEnvironmentAnswer findClass(String typeName, String qualifiedPackageName, String moduleName, String qualifiedBinaryFileName) {
        return this.findClass(typeName, qualifiedPackageName, moduleName, qualifiedBinaryFileName, false);
    }
}

