/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit.model;

import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jdt.internal.junit.JUnitCorePlugin;
import org.eclipse.jdt.internal.junit.model.ITestSessionListener;
import org.eclipse.jdt.internal.junit.model.TestCaseElement;
import org.eclipse.jdt.internal.junit.model.TestElement;
import org.eclipse.jdt.internal.junit.model.TestRunSession;
import org.eclipse.jdt.junit.TestRunListener;
import org.eclipse.jdt.junit.model.ITestCaseElement;

public class TestRunListenerAdapter
implements ITestSessionListener {
    private final TestRunSession fSession;

    public TestRunListenerAdapter(TestRunSession session) {
        this.fSession = session;
    }

    private ListenerList<TestRunListener> getListenerList() {
        return JUnitCorePlugin.getDefault().getNewTestRunListeners();
    }

    private void fireSessionStarted() {
        for (TestRunListener listener : this.getListenerList()) {
            listener.sessionStarted(this.fSession);
        }
    }

    private void fireSessionFinished() {
        for (TestRunListener listener : this.getListenerList()) {
            listener.sessionFinished(this.fSession);
        }
    }

    private void fireTestCaseStarted(ITestCaseElement testCaseElement) {
        for (TestRunListener listener : this.getListenerList()) {
            listener.testCaseStarted(testCaseElement);
        }
    }

    private void fireTestCaseFinished(ITestCaseElement testCaseElement) {
        for (TestRunListener listener : this.getListenerList()) {
            listener.testCaseFinished(testCaseElement);
        }
    }

    @Override
    public void sessionStarted() {
    }

    @Override
    public void sessionEnded(long elapsedTime) {
        this.fireSessionFinished();
        this.fSession.swapOut();
    }

    @Override
    public void sessionStopped(long elapsedTime) {
        this.fireSessionFinished();
        this.fSession.swapOut();
    }

    @Override
    public void sessionTerminated() {
        this.fSession.swapOut();
    }

    @Override
    public void testAdded(TestElement testElement) {
    }

    @Override
    public void runningBegins() {
        this.fireSessionStarted();
    }

    @Override
    public void testStarted(TestCaseElement testCaseElement) {
        this.fireTestCaseStarted(testCaseElement);
    }

    @Override
    public void testEnded(TestCaseElement testCaseElement) {
        this.fireTestCaseFinished(testCaseElement);
    }

    @Override
    public void testFailed(TestElement testElement, TestElement.Status status, String trace, String expected, String actual) {
    }

    @Override
    public void testReran(TestCaseElement testCaseElement, TestElement.Status status, String trace, String expectedResult, String actualResult) {
    }

    @Override
    public boolean acceptsSwapToDisk() {
        return true;
    }
}

