/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.s.jaxws;

import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.scout.sdk.core.s.IMavenConstants;
import org.eclipse.scout.sdk.core.s.jaxws.ParsedWsdl;
import org.eclipse.scout.sdk.core.util.CoreUtils;
import org.eclipse.scout.sdk.core.util.SdkLog;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class JaxWsUtils
implements IMavenConstants {
    public static final String WSDL_FILE_EXTENSION = ".wsdl";
    public static final String ENTRY_POINT_DEFINITION_ENDPOINTINTERFACE_ATTRIBUTE = "endpointInterface";
    public static final String ENTRY_POINT_DEFINITION_NAME_ATTRIBUTE = "entryPointName";
    public static final String ENTRY_POINT_DEFINITION_PACKAGE_ATTRIBUTE = "entryPointPackage";
    public static final String ENTRY_POINT_DEFINITION_AUTH_ATTRIBUTE = "authentication";
    public static final String ENTRY_POINT_DEFINITION_HANDLER_CHAIN_ATTRIBUTE = "handlerChain";
    public static final String BINDINGS_NAME_ATTRIBUTE = "name";
    public static final String BINDINGS_CLASS_ELEMENT_NAME = "class";
    public static final String BINDING_PACKAGE_ELEMENT_NAME = "package";
    public static final String BINDINGS_NODE_ATTRIBUTE_NAME = "node";
    public static final String JAX_WS_NAMESPACE = "http://java.sun.com/xml/ns/jaxws";
    public static final String JAX_B_NAMESPACE = "http://java.sun.com/xml/ns/jaxb";
    public static final String BINDINGS_ELEMENT_NAME = "bindings";
    public static final String GENERATE_ELEMENT_ATTRIBUTE_NAME = "generateElementProperty";
    public static final String GLOBAL_BINDINGS_ELEMENT_NAME = "globalBindings";
    public static final String MODULE_REL_WEBINF_FOLDER_PATH = "src/main/resources/WEB-INF";
    public static final String BINDING_FILE_ELEMENT_NAME = "bindingFile";
    public static final String BINDING_FILES_ELEMENT_NAME = "bindingFiles";
    public static final String WSDL_FILE_ELEMENT_NAME = "wsdlFile";
    public static final String WSDL_FILES_ELEMENT_NAME = "wsdlFiles";
    public static final String WSDL_LOCATION = "wsdlLocation";
    public static final String GLOBAL_BINDINGS_FILE_NAME = "global-binding.xml";
    public static final String JAXB_BINDINGS_FILE_NAME = "jaxb-binding.xml";
    public static final String JAXWS_BINDINGS_FILE_NAME = "jaxws-binding.xml";
    public static final String WSDL_FOLDER_NAME = "wsdl";
    public static final String BINDING_FOLDER_NAME = "binding";
    public static final String WSIMPORT_TOOL_NAME = "wsimport";
    public static final String CODEHAUS_GROUP_ID = "org.codehaus.mojo";
    public static final String JAXWS_MAVEN_PLUGIN_ARTIFACT_ID = "jaxws-maven-plugin";
    public static final String PACKAGE_XPATH = "wsdl:definitions";
    private static final String WEB_SERVICE_XPATH_START = "wsdl:definitions/wsdl:service[@name='";
    private static final String PORT_TYPE_XPATH_START = "wsdl:definitions/wsdl:portType[@name='";
    private static final String XPATH_END = "']";

    private JaxWsUtils() {
    }

    public static StringBuilder getJaxbBindingContent(String lineDelimiter) {
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>").append(lineDelimiter);
        sb.append("<!-- binding to customize xsd schema artifacts (jaxb-namespace: http://java.sun.com/xml/ns/jaxb) -->").append(lineDelimiter);
        sb.append("<bindings xmlns=\"http://java.sun.com/xml/ns/jaxb\" version=\"2.1\">").append(lineDelimiter);
        sb.append("</bindings>").append(lineDelimiter);
        return sb;
    }

    public static StringBuilder getEmptyWsdl(String name, String packageName, String lineDelimiter) {
        Object[] parts = packageName.split("\\.");
        if (parts.length > 0 && name.equalsIgnoreCase((String)parts[parts.length - 1])) {
            parts = (String[])Arrays.copyOf(parts, parts.length - 1);
        }
        ArrayUtils.reverse((Object[])parts);
        String nameSpace = StringUtils.join((Object[])parts, (char)'.');
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>").append(lineDelimiter);
        sb.append("<wsdl:definitions name=\"").append(name).append("\"").append(lineDelimiter);
        sb.append("  xmlns:soap=\"http://schemas.xmlsoap.org/wsdl/soap/\"").append(lineDelimiter);
        sb.append("  xmlns:tns=\"http://").append(nameSpace).append('/').append(name).append("/\"").append(lineDelimiter);
        sb.append("  xmlns:wsdl=\"http://schemas.xmlsoap.org/wsdl/\"").append(lineDelimiter);
        sb.append("  xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"").append(lineDelimiter);
        sb.append("  targetNamespace=\"http://").append(nameSpace).append('/').append(name).append("/\">").append(lineDelimiter);
        sb.append("  <wsdl:types>").append(lineDelimiter);
        sb.append("    <xsd:schema targetNamespace=\"http://").append(nameSpace).append('/').append(name).append("/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\">").append(lineDelimiter);
        sb.append("      <xsd:element name=\"InElement\" type=\"xsd:string\"/>").append(lineDelimiter);
        sb.append("      <xsd:element name=\"OutElement\" type=\"xsd:string\"/>").append(lineDelimiter);
        sb.append("    </xsd:schema>").append(lineDelimiter);
        sb.append("  </wsdl:types>").append(lineDelimiter);
        sb.append("  <wsdl:message name=\"NewOperationRequest\">").append(lineDelimiter);
        sb.append("    <wsdl:part element=\"tns:InElement\" name=\"in\"/>").append(lineDelimiter);
        sb.append("  </wsdl:message>").append(lineDelimiter);
        sb.append("  <wsdl:message name=\"NewOperationResponse\">").append(lineDelimiter);
        sb.append("    <wsdl:part element=\"tns:OutElement\" name=\"ret\"/>").append(lineDelimiter);
        sb.append("  </wsdl:message>").append(lineDelimiter);
        sb.append("  <wsdl:portType name=\"").append(name).append("PortType\">").append(lineDelimiter);
        sb.append("    <wsdl:operation name=\"NewOperation\">").append(lineDelimiter);
        sb.append("      <wsdl:input message=\"tns:NewOperationRequest\"/>").append(lineDelimiter);
        sb.append("      <wsdl:output message=\"tns:NewOperationResponse\"/>").append(lineDelimiter);
        sb.append("    </wsdl:operation>").append(lineDelimiter);
        sb.append("  </wsdl:portType>").append(lineDelimiter);
        sb.append("  <wsdl:binding name=\"").append(name).append("PortSoapBinding\" type=\"tns:").append(name).append("PortType\">").append(lineDelimiter);
        sb.append("    <soap:binding style=\"document\" transport=\"http://schemas.xmlsoap.org/soap/http\"/>").append(lineDelimiter);
        sb.append("    <wsdl:operation name=\"NewOperation\">").append(lineDelimiter);
        sb.append("      <soap:operation soapAction=\"http://").append(nameSpace).append('/').append(name).append("/NewOperation\"/>").append(lineDelimiter);
        sb.append("      <wsdl:input>").append(lineDelimiter);
        sb.append("        <soap:body use=\"literal\"/>").append(lineDelimiter);
        sb.append("      </wsdl:input>").append(lineDelimiter);
        sb.append("      <wsdl:output>").append(lineDelimiter);
        sb.append("        <soap:body use=\"literal\"/>").append(lineDelimiter);
        sb.append("      </wsdl:output>").append(lineDelimiter);
        sb.append("    </wsdl:operation>").append(lineDelimiter);
        sb.append("  </wsdl:binding>").append(lineDelimiter);
        sb.append("  <wsdl:service name=\"").append(name).append("WebService\">").append(lineDelimiter);
        sb.append("    <wsdl:port binding=\"tns:").append(name).append("PortSoapBinding\" name=\"").append(name).append("Port\">").append(lineDelimiter);
        sb.append("      <soap:address location=\"http://").append(nameSpace).append("/\"/>").append(lineDelimiter);
        sb.append("    </wsdl:port>").append(lineDelimiter);
        sb.append("  </wsdl:service>").append(lineDelimiter);
        sb.append("</wsdl:definitions>").append(lineDelimiter);
        return sb;
    }

    public static Map<Path, StringBuilder> getJaxwsBindingContents(ParsedWsdl parsedWsdl, URI rootWsdlUri, String lineDelimiter, String targetPackage) {
        HashMap bindingsByFile = new HashMap();
        for (Map.Entry<Service, URI> service : parsedWsdl.getWebServices().entrySet()) {
            ParsedWsdl.WebServiceNames names = parsedWsdl.getServiceNames().get(service.getKey());
            Set<JaxWsBindingMapping> bindings = (HashSet<JaxWsBindingMapping>)bindingsByFile.get(service.getValue());
            if (bindings == null) {
                bindings = new HashSet<JaxWsBindingMapping>();
                bindingsByFile.put(service.getValue(), bindings);
            }
            bindings.add(new JaxWsBindingMapping(false, names.getWebServiceNameFromWsdl(), names.getWebServiceClassName()));
            Set<PortType> portTypesByService = parsedWsdl.getPortTypes(service.getKey());
            for (PortType portType : portTypesByService) {
                URI uriOfPortType = parsedWsdl.getPortTypes().get(portType);
                bindings = (Set)bindingsByFile.get(uriOfPortType);
                if (bindings == null) {
                    bindings = new HashSet();
                    bindingsByFile.put(uriOfPortType, bindings);
                }
                String portTypeName = portType.getQName().getLocalPart();
                bindings.add(new JaxWsBindingMapping(true, portTypeName, names.getPortTypeClassName(portTypeName)));
            }
        }
        HashMap<Path, StringBuilder> result = new HashMap<Path, StringBuilder>(bindingsByFile.size());
        for (Map.Entry binding : bindingsByFile.entrySet()) {
            URI uri = (URI)binding.getKey();
            URI relPath = CoreUtils.relativizeURI((URI)rootWsdlUri, (URI)uri);
            StringBuilder jaxwsBindingContent = JaxWsUtils.getJaxwsBindingContent(targetPackage, relPath, (Collection)binding.getValue(), lineDelimiter);
            Path path = Paths.get(uri);
            if (path.getNameCount() < 1) {
                SdkLog.warning((String)"Zero length path found for jax-ws binding content of URI '{}'. Skipping.", (Object[])new Object[]{uri});
                continue;
            }
            result.put(path, jaxwsBindingContent);
        }
        return result;
    }

    static StringBuilder getJaxwsBindingContent(String wsPackage, URI wsdlLocation, Collection<JaxWsBindingMapping> names, String lineDelimiter) {
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>").append(lineDelimiter);
        sb.append("<!-- binding to customize webservice artifacts (jaxws-namespace: http://java.sun.com/xml/ns/jaxws) -->").append(lineDelimiter);
        sb.append("<jaxws:bindings wsdlLocation=\"").append(wsdlLocation).append("\"").append(lineDelimiter);
        sb.append("  xmlns:jaxws=\"http://java.sun.com/xml/ns/jaxws\"").append(lineDelimiter);
        sb.append("  xmlns:jaxb=\"http://java.sun.com/xml/ns/jaxb\"").append(lineDelimiter);
        sb.append("  xmlns:wsdl=\"http://schemas.xmlsoap.org/wsdl/\"").append(lineDelimiter);
        sb.append("  xmlns:xjc=\"http://java.sun.com/xml/ns/jaxb/xjc\"").append(lineDelimiter);
        sb.append("  xmlns:javaee=\"http://java.sun.com/xml/ns/javaee\"").append(lineDelimiter);
        sb.append("  xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\">").append(lineDelimiter);
        sb.append("  <jaxws:bindings node=\"wsdl:definitions\">").append(lineDelimiter);
        sb.append("    <jaxws:package name=\"").append(wsPackage).append("\"/>").append(lineDelimiter);
        sb.append("  </jaxws:bindings>").append(lineDelimiter);
        for (JaxWsBindingMapping mapping : names) {
            String nodeAttr = null;
            nodeAttr = mapping.isPortType() ? JaxWsUtils.getPortTypeXPath(mapping.getWsdlName()) : JaxWsUtils.getWebServiceXPath(mapping.getWsdlName());
            sb.append("  <jaxws:bindings node=\"").append(nodeAttr).append("\">").append(lineDelimiter);
            sb.append("    <jaxws:class name=\"").append(mapping.getClassName()).append("\" />").append(lineDelimiter);
            sb.append("  </jaxws:bindings>").append(lineDelimiter);
        }
        sb.append("</jaxws:bindings>").append(lineDelimiter);
        return sb;
    }

    public static String getWebServiceXPath(String webServiceNameInWsdl) {
        return WEB_SERVICE_XPATH_START + webServiceNameInWsdl + XPATH_END;
    }

    public static String getPortTypeXPath(String portTypeNameInWsdl) {
        return PORT_TYPE_XPATH_START + portTypeNameInWsdl + XPATH_END;
    }

    public static void addWsdlToPom(Document pomDocument, String wsdlFileName, String bindingFolderName, Iterable<String> bindingFileNames) {
        Element root = pomDocument.getDocumentElement();
        Element executions = JaxWsUtils.getExecutionsElement(root);
        String nextId = JaxWsUtils.getNextExecutionId(executions);
        Element newExecution = root.getOwnerDocument().createElement("execution");
        Element idElement = JaxWsUtils.getOrCreateElement(newExecution, "id");
        idElement.setTextContent(nextId);
        Element goalsElement = JaxWsUtils.getOrCreateElement(newExecution, "goals");
        Element goalElement = JaxWsUtils.getOrCreateElement(goalsElement, "goal");
        goalElement.setTextContent(WSIMPORT_TOOL_NAME);
        Element configurationElement = JaxWsUtils.getOrCreateElement(newExecution, "configuration");
        Element wsdlLocationElement = JaxWsUtils.getOrCreateElement(configurationElement, WSDL_LOCATION);
        wsdlLocationElement.setTextContent("WEB-INF/wsdl/" + wsdlFileName);
        Element wsdlFilesElement = JaxWsUtils.getOrCreateElement(configurationElement, WSDL_FILES_ELEMENT_NAME);
        Element wsdlFileElement = JaxWsUtils.getOrCreateElement(wsdlFilesElement, WSDL_FILE_ELEMENT_NAME);
        wsdlFileElement.setTextContent(wsdlFileName);
        Element bindingFilesElement = JaxWsUtils.getOrCreateElement(configurationElement, BINDING_FILES_ELEMENT_NAME);
        Element globalBindingFileElement = root.getOwnerDocument().createElement(BINDING_FILE_ELEMENT_NAME);
        globalBindingFileElement.setTextContent(GLOBAL_BINDINGS_FILE_NAME);
        bindingFilesElement.appendChild(globalBindingFileElement);
        for (String fileName : bindingFileNames) {
            Element bindingFileElement = root.getOwnerDocument().createElement(BINDING_FILE_ELEMENT_NAME);
            bindingFileElement.setTextContent(String.valueOf(bindingFolderName) + '/' + fileName);
            bindingFilesElement.appendChild(bindingFileElement);
        }
        executions.appendChild(newExecution);
    }

    public static List<String> getBindingPathsFromPom(Document pom, String wsdlFileName) throws XPathExpressionException {
        if (wsdlFileName.indexOf(39) >= 0) {
            throw new IllegalArgumentException("apos character (') is not allowed in a WSDL file name.");
        }
        String prefix = "p";
        String p = "p:";
        String lc = wsdlFileName.toLowerCase();
        String uc = wsdlFileName.toUpperCase();
        StringBuilder bindingFilesXpathBuilder = new StringBuilder();
        bindingFilesXpathBuilder.append("p:").append("project").append('/').append("p:").append("build").append('/').append("p:").append("plugins").append('/').append("p:").append("plugin").append("[./").append("p:").append("groupId").append("='").append(CODEHAUS_GROUP_ID).append("' and ./").append("p:").append("artifactId").append("='").append(JAXWS_MAVEN_PLUGIN_ARTIFACT_ID).append(XPATH_END).append('/').append("p:").append("executions").append('/').append("p:").append("execution").append('/').append("p:").append("configuration").append("[translate(./").append("p:").append(WSDL_FILES_ELEMENT_NAME).append('/').append("p:").append(WSDL_FILE_ELEMENT_NAME).append(", '").append(uc).append("', '").append(lc).append("')='").append(lc).append("']/").append("p:").append(BINDING_FILES_ELEMENT_NAME).append('/').append("p:").append(BINDING_FILE_ELEMENT_NAME);
        List nl = CoreUtils.evaluateXPath((String)bindingFilesXpathBuilder.toString(), (Document)pom, (String)"p", (String)"http://maven.apache.org/POM/4.0.0");
        if (nl.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> paths = new ArrayList<String>(nl.size());
        for (Element e : nl) {
            String content = e.getTextContent();
            if (!StringUtils.isNotBlank((CharSequence)content)) continue;
            paths.add(content.trim());
        }
        return paths;
    }

    static String getNextExecutionId(Element executions) {
        int curNum = 1;
        String idPrefix = "wsimport-";
        NodeList children = executions.getChildNodes();
        while (JaxWsUtils.isExecutionIdUsed("wsimport-" + curNum, children)) {
            ++curNum;
        }
        return "wsimport-" + curNum;
    }

    static boolean isExecutionIdUsed(String id, NodeList executionList) {
        int i = 0;
        while (i < executionList.getLength()) {
            Element idElement;
            Node node = executionList.item(i);
            if (node.getNodeType() == 1 && (idElement = CoreUtils.getFirstChildElement((Element)((Element)node), (String)"id")) != null && id.equals(idElement.getTextContent())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    static Element getExecutionsElement(Element root) {
        Element build = JaxWsUtils.getOrCreateElement(root, "build");
        Element plugins = JaxWsUtils.getOrCreateElement(build, "plugins");
        Element jaxWsMavenPluginElement = JaxWsUtils.getOrCreateJaxWsMavenPluginElement(plugins);
        return JaxWsUtils.getOrCreateElement(jaxWsMavenPluginElement, "executions");
    }

    static Element getOrCreateJaxWsMavenPluginElement(Element pluginsElement) {
        NodeList plugins = pluginsElement.getChildNodes();
        int i = 0;
        while (i < plugins.getLength()) {
            Node plugin = plugins.item(i);
            if (plugin.getNodeType() == 1 && "plugin".equals(plugin.getNodeName())) {
                Element pluginCandidate = (Element)plugin;
                Element group = CoreUtils.getFirstChildElement((Element)pluginCandidate, (String)"groupId");
                Element artifact = CoreUtils.getFirstChildElement((Element)pluginCandidate, (String)"artifactId");
                if (group != null && CODEHAUS_GROUP_ID.equals(group.getTextContent()) && artifact != null && JAXWS_MAVEN_PLUGIN_ARTIFACT_ID.equals(artifact.getTextContent())) {
                    return pluginCandidate;
                }
            }
            ++i;
        }
        Element plugin = JaxWsUtils.getOrCreateElement(pluginsElement, "plugin");
        Element groupId = JaxWsUtils.getOrCreateElement(plugin, "groupId");
        groupId.setTextContent(CODEHAUS_GROUP_ID);
        Element artifactId = JaxWsUtils.getOrCreateElement(plugin, "artifactId");
        artifactId.setTextContent(JAXWS_MAVEN_PLUGIN_ARTIFACT_ID);
        return plugin;
    }

    static Element getOrCreateElement(Element parent, String tagName) {
        Element element = CoreUtils.getFirstChildElement((Element)parent, (String)tagName);
        if (element != null) {
            return element;
        }
        element = parent.getOwnerDocument().createElement(tagName);
        parent.appendChild(element);
        return element;
    }

    public static Element getJaxWsBindingElement(String nodeValue, Document document) throws XPathExpressionException {
        StringBuilder xPath = new StringBuilder();
        String prefix = "jaxws";
        String p = "jaxws:";
        xPath.append("jaxws:").append(BINDINGS_ELEMENT_NAME).append('/').append("jaxws:").append(BINDINGS_ELEMENT_NAME);
        List bindings = CoreUtils.evaluateXPath((String)xPath.toString(), (Document)document, (String)"jaxws", (String)JAX_WS_NAMESPACE);
        for (Element binding : bindings) {
            String nodeAttribValue = binding.getAttribute(BINDINGS_NODE_ATTRIBUTE_NAME);
            if (!nodeValue.equals(nodeAttribValue)) continue;
            return binding;
        }
        return null;
    }

    public static String removeCommonSuffixes(String input) {
        if (StringUtils.isBlank((CharSequence)input)) {
            return input;
        }
        LinkedList<String> suffixes = new LinkedList<String>();
        suffixes.add("xml");
        suffixes.add("soap");
        suffixes.add("porttype");
        suffixes.add("port");
        suffixes.add("webservice");
        suffixes.add("services");
        suffixes.add("service");
        for (String s : suffixes) {
            if (!input.toLowerCase().endsWith(s)) continue;
            String newInputCandidate = input.substring(0, input.length() - s.length());
            if (StringUtils.isBlank((CharSequence)newInputCandidate)) {
                return input;
            }
            input = newInputCandidate;
        }
        return input;
    }

    public static class JaxWsBindingMapping {
        private final boolean m_isPortType;
        private final String m_wsdlName;
        private final String m_className;

        public JaxWsBindingMapping(boolean isPortType, String wsdlName, String className) {
            this.m_isPortType = isPortType;
            this.m_wsdlName = wsdlName;
            this.m_className = className;
        }

        public boolean isPortType() {
            return this.m_isPortType;
        }

        public String getWsdlName() {
            return this.m_wsdlName;
        }

        public String getClassName() {
            return this.m_className;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.m_className == null ? 0 : this.m_className.hashCode());
            result = 31 * result + (this.m_isPortType ? 1231 : 1237);
            result = 31 * result + (this.m_wsdlName == null ? 0 : this.m_wsdlName.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            JaxWsBindingMapping other = (JaxWsBindingMapping)obj;
            if (this.m_className == null ? other.m_className != null : !this.m_className.equals(other.m_className)) {
                return false;
            }
            if (this.m_isPortType != other.m_isPortType) {
                return false;
            }
            return !(this.m_wsdlName == null ? other.m_wsdlName != null : !this.m_wsdlName.equals(other.m_wsdlName));
        }
    }
}

