/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.s.model;

import org.eclipse.jdt.internal.compiler.util.SuffixConstants;
import org.eclipse.scout.sdk.core.importvalidator.IImportValidator;
import org.eclipse.scout.sdk.core.signature.Signature;
import org.eclipse.scout.sdk.core.sourcebuilder.ISourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.annotation.AnnotationSourceBuilderFactory;
import org.eclipse.scout.sdk.core.sourcebuilder.method.IMethodSourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.method.MethodSourceBuilder;
import org.eclipse.scout.sdk.core.util.CoreUtils;
import org.eclipse.scout.sdk.core.util.PropertyMap;

public final class ScoutMethodSourceBuilderFactory {
    private ScoutMethodSourceBuilderFactory() {
    }

    public static IMethodSourceBuilder createFieldGetter(final String fieldSignature) {
        String fieldSimpleName = CoreUtils.ensureStartWithUpperCase((String)Signature.getSignatureSimpleName((String)fieldSignature.replace('$', '.')));
        MethodSourceBuilder getterBuilder = new MethodSourceBuilder("get" + fieldSimpleName);
        getterBuilder.setFlags(1);
        getterBuilder.setReturnTypeSignature(fieldSignature);
        getterBuilder.setBody(new ISourceBuilder(){

            public void createSource(StringBuilder source, String lineDelimiter, PropertyMap context, IImportValidator validator) {
                source.append("return getFieldByClass(").append(validator.useSignature(fieldSignature)).append(SuffixConstants.SUFFIX_class).append(");");
            }
        });
        return getterBuilder;
    }

    public static IMethodSourceBuilder createNlsMethod(String methodName, final String nlsKeyName) {
        MethodSourceBuilder nlsMethod = new MethodSourceBuilder(methodName);
        nlsMethod.setFlags(4);
        nlsMethod.setReturnTypeSignature(Signature.createTypeSignature((String)"java.lang.String"));
        nlsMethod.setBody(new ISourceBuilder(){

            public void createSource(StringBuilder source, String lineDelimiter, PropertyMap context, IImportValidator validator) {
                source.append(CoreUtils.getCommentBlock((String)"verify translation")).append(lineDelimiter);
                source.append("return ").append(validator.useName("org.eclipse.scout.rt.shared.TEXTS")).append(".get(").append(CoreUtils.toStringLiteral((String)nlsKeyName)).append(");");
            }
        });
        nlsMethod.addAnnotation(AnnotationSourceBuilderFactory.createOverride());
        return nlsMethod;
    }
}

