/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.s.sourcebuilder.testcase;

import org.apache.commons.lang3.StringUtils;
import org.eclipse.scout.sdk.core.importvalidator.IImportValidator;
import org.eclipse.scout.sdk.core.model.api.IJavaEnvironment;
import org.eclipse.scout.sdk.core.s.model.ScoutAnnotationSourceBuilderFactory;
import org.eclipse.scout.sdk.core.sourcebuilder.ISourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.comment.CommentSourceBuilderFactory;
import org.eclipse.scout.sdk.core.sourcebuilder.compilationunit.AbstractEntitySourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.compilationunit.ICompilationUnitSourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.type.ITypeSourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.type.TypeSourceBuilder;
import org.eclipse.scout.sdk.core.util.CoreUtils;
import org.eclipse.scout.sdk.core.util.PropertyMap;

public class TestSourceBuilder
extends AbstractEntitySourceBuilder {
    private String m_runnerSignature;
    private String m_sessionSignature;
    private ISourceBuilder m_runWithSubjectValueBuilder;
    private boolean m_isClientTest;

    public TestSourceBuilder(String elementName, String packageName, IJavaEnvironment env) {
        super(elementName, packageName, env);
    }

    public void setup() {
        this.setComment(CommentSourceBuilderFactory.createDefaultCompilationUnitComment((ICompilationUnitSourceBuilder)this));
        TypeSourceBuilder testBuilder = new TypeSourceBuilder(this.getEntityName());
        testBuilder.setFlags(1);
        testBuilder.addType((ITypeSourceBuilder)new TypeSourceBuilder(""){

            public void createSource(StringBuilder source, String lineDelimiter, PropertyMap context, IImportValidator validator) {
                source.append(CoreUtils.getCommentBlock((String)"add test cases"));
            }
        });
        String runnerSignature = this.getRunnerSignature();
        if (StringUtils.isNotBlank((CharSequence)runnerSignature)) {
            testBuilder.addAnnotation(ScoutAnnotationSourceBuilderFactory.createRunWith(runnerSignature));
        }
        testBuilder.addAnnotation(ScoutAnnotationSourceBuilderFactory.createRunWithSubject(this.getRunWithSubjectValueBuilder()));
        String sessionSig = this.getSessionSignature();
        if (this.isClientTest()) {
            testBuilder.addAnnotation(ScoutAnnotationSourceBuilderFactory.createRunWithClientSession(sessionSig));
        } else if (StringUtils.isNotBlank((CharSequence)sessionSig)) {
            testBuilder.addAnnotation(ScoutAnnotationSourceBuilderFactory.createRunWithServerSession(sessionSig));
        }
        this.addType((ITypeSourceBuilder)testBuilder);
    }

    public String getRunnerSignature() {
        return this.m_runnerSignature;
    }

    public void setRunnerSignature(String runnerSignature) {
        this.m_runnerSignature = runnerSignature;
    }

    public String getSessionSignature() {
        return this.m_sessionSignature;
    }

    public void setSessionSignature(String sessionSignature) {
        this.m_sessionSignature = sessionSignature;
    }

    public boolean isClientTest() {
        return this.m_isClientTest;
    }

    public void setClientTest(boolean isClientTest) {
        this.m_isClientTest = isClientTest;
    }

    public ISourceBuilder getRunWithSubjectValueBuilder() {
        return this.m_runWithSubjectValueBuilder;
    }

    public void setRunWithSubjectValueBuilder(ISourceBuilder runWithSubjectValueBuilder) {
        this.m_runWithSubjectValueBuilder = runWithSubjectValueBuilder;
    }
}

