/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.s.util.maven;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.CodeSource;
import java.util.ArrayList;
import org.eclipse.scout.sdk.core.util.SdkException;

public final class MavenSandboxClassLoaderFactory {
    private MavenSandboxClassLoaderFactory() {
    }

    public static URLClassLoader build() {
        return URLClassLoader.newInstance(MavenSandboxClassLoaderFactory.getMavenJarsUrls(), null);
    }

    static URL[] getMavenJarsUrls() {
        String[] baseClasses = new String[]{"org.eclipse.scout.sdk.core.s.util.maven.MavenCliRunner", "org.apache.commons.lang3.StringUtils", "org.eclipse.scout.sdk.core.util.SdkLog", "org.apache.maven.cli.MavenCli", "org.apache.maven.settings.Settings", "org.apache.maven.Maven", "org.apache.maven.model.Site", "org.apache.maven.settings.building.DefaultSettingsBuilder", "org.apache.maven.artifact.repository.metadata.Metadata", "org.apache.maven.artifact.Artifact", "org.apache.maven.repository.internal.MavenAetherModule", "org.eclipse.aether.impl.ArtifactResolver", "com.google.inject.Guice", "javax.inject.Inject", "org.codehaus.plexus.interpolation.Interpolator", "org.apache.maven.plugin.AbstractMojo", "org.apache.maven.model.building.ModelBuilder", "org.apache.maven.building.ProblemCollector", "com.google.common.base.Predicate", "org.apache.maven.artifact.ArtifactStatus", "org.codehaus.plexus.util.CachedMap", "org.codehaus.plexus.classworlds.ClassWorld", "org.codehaus.plexus.ContainerConfiguration", "javax.decorator.Delegate", "org.eclipse.sisu.inject.MutableBeanLocator", "org.codehaus.plexus.component.annotations.Requirement", "org.sonatype.plexus.components.sec.dispatcher.SecDispatcher", "org.sonatype.plexus.components.cipher.PlexusCipher", "org.apache.commons.cli.CommandLineParser", "org.eclipse.aether.connector.basic.BasicRepositoryConnectorFactory", "org.eclipse.aether.RepositoryCache", "org.eclipse.aether.spi.connector.RepositoryConnector", "org.eclipse.aether.util.ChecksumUtils", "org.eclipse.aether.internal.transport.wagon.PlexusWagonConfigurator", "io.takari.aether.client.AetherClient", "com.squareup.okhttp.Interceptor", "okio.Okio", "org.slf4j.ILoggerFactory", "org.apache.maven.wagon.AbstractWagon"};
        return MavenSandboxClassLoaderFactory.getJarsUrls(baseClasses);
    }

    static URL[] getJarsUrls(String[] baseClasses) {
        ArrayList<URL> urls = new ArrayList<URL>(baseClasses.length);
        String[] stringArray = baseClasses;
        int n = baseClasses.length;
        int n2 = 0;
        while (n2 < n) {
            String className = stringArray[n2];
            urls.add(MavenSandboxClassLoaderFactory.getJarContaining(className));
            ++n2;
        }
        return urls.toArray(new URL[urls.size()]);
    }

    static URL getJarContaining(String className) {
        try {
            Class<?> clazz = MavenSandboxClassLoaderFactory.class.getClassLoader().loadClass(className);
            URL url = MavenSandboxClassLoaderFactory.getJarContaining(clazz);
            if (url == null) {
                throw new SdkException("Could not find jar of '" + className + "'.");
            }
            return url;
        }
        catch (ClassNotFoundException e) {
            throw new SdkException((Throwable)e);
        }
    }

    static URL getJarContaining(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        CodeSource codeSource = clazz.getProtectionDomain().getCodeSource();
        if (codeSource == null) {
            return null;
        }
        URL url = codeSource.getLocation();
        if (url == null) {
            return url;
        }
        if (url.getPath().endsWith(".jar")) {
            return url;
        }
        try {
            URL fileUrl = new URL(url, "target/classes/");
            File f = new File(fileUrl.getPath());
            if (f.exists()) {
                return fileUrl;
            }
            fileUrl = url;
            f = new File(fileUrl.getPath());
            if (f.exists()) {
                return fileUrl;
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return url;
    }
}

