/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.model.api.internal;

import java.util.List;
import org.eclipse.scout.sdk.core.model.api.IMember;
import org.eclipse.scout.sdk.core.model.api.IType;
import org.eclipse.scout.sdk.core.model.api.ITypeParameter;
import org.eclipse.scout.sdk.core.model.api.internal.AbstractJavaElementImplementor;
import org.eclipse.scout.sdk.core.model.api.internal.JavaModelPrinter;
import org.eclipse.scout.sdk.core.model.api.internal.WrappedList;
import org.eclipse.scout.sdk.core.model.spi.JavaElementSpi;
import org.eclipse.scout.sdk.core.model.spi.TypeParameterSpi;
import org.eclipse.scout.sdk.core.signature.Signature;

public class TypeParameterImplementor
extends AbstractJavaElementImplementor<TypeParameterSpi>
implements ITypeParameter {
    private String m_signature;

    public TypeParameterImplementor(TypeParameterSpi spi) {
        super(spi);
    }

    @Override
    public IMember declaringMember() {
        return ((TypeParameterSpi)this.m_spi).getDeclaringMember().wrap();
    }

    @Override
    public List<IType> bounds() {
        return new WrappedList<IType>(((TypeParameterSpi)this.m_spi).getBounds());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        JavaModelPrinter.print(this, sb);
        return sb.toString();
    }

    @Override
    public void internalSetSpi(JavaElementSpi spi) {
        super.internalSetSpi(spi);
        this.m_signature = null;
    }

    @Override
    public String signature() {
        if (this.m_signature == null) {
            List<IType> bounds = this.bounds();
            String[] boundSignatures = new String[bounds.size()];
            int i = 0;
            while (i < boundSignatures.length) {
                boundSignatures[i] = bounds.get(i).signature();
                ++i;
            }
            this.m_signature = Signature.createTypeParameterSignature(this.elementName(), boundSignatures);
        }
        return this.m_signature;
    }
}

