/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.model.spi.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.Javadoc;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeParameter;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.scout.sdk.core.model.api.IMethod;
import org.eclipse.scout.sdk.core.model.api.ISourceRange;
import org.eclipse.scout.sdk.core.model.api.internal.MethodImplementor;
import org.eclipse.scout.sdk.core.model.spi.CompilationUnitSpi;
import org.eclipse.scout.sdk.core.model.spi.JavaElementSpi;
import org.eclipse.scout.sdk.core.model.spi.MethodParameterSpi;
import org.eclipse.scout.sdk.core.model.spi.MethodSpi;
import org.eclipse.scout.sdk.core.model.spi.TypeParameterSpi;
import org.eclipse.scout.sdk.core.model.spi.TypeSpi;
import org.eclipse.scout.sdk.core.model.spi.internal.AbstractMemberWithJdt;
import org.eclipse.scout.sdk.core.model.spi.internal.DeclarationAnnotationWithJdt;
import org.eclipse.scout.sdk.core.model.spi.internal.DeclarationTypeParameterWithJdt;
import org.eclipse.scout.sdk.core.model.spi.internal.DeclarationTypeWithJdt;
import org.eclipse.scout.sdk.core.model.spi.internal.JavaEnvironmentWithJdt;
import org.eclipse.scout.sdk.core.model.spi.internal.SpiWithJdtUtils;

public class DeclarationMethodWithJdt
extends AbstractMemberWithJdt<IMethod>
implements MethodSpi {
    private final DeclarationTypeWithJdt m_declaringType;
    private final AbstractMethodDeclaration m_astNode;
    private TypeSpi m_returnType;
    private List<DeclarationAnnotationWithJdt> m_annotations;
    private int m_flags;
    private List<MethodParameterSpi> m_arguments;
    private String m_name;
    private List<TypeSpi> m_exceptions;
    private List<TypeParameterSpi> m_typeParameters;
    private ISourceRange m_source;
    private ISourceRange m_bodySource;
    private ISourceRange m_javaDocSource;

    DeclarationMethodWithJdt(JavaEnvironmentWithJdt env, DeclarationTypeWithJdt declaringType, AbstractMethodDeclaration astNode) {
        super(env);
        this.m_declaringType = (DeclarationTypeWithJdt)Validate.notNull((Object)declaringType);
        this.m_astNode = (AbstractMethodDeclaration)Validate.notNull((Object)astNode);
        this.m_flags = -1;
    }

    @Override
    protected JavaElementSpi internalFindNewElement(JavaEnvironmentWithJdt newEnv) {
        TypeSpi newType = (TypeSpi)this.getDeclaringType().internalFindNewElement(newEnv);
        if (newType != null) {
            String oldSig = SpiWithJdtUtils.createMethodId(this);
            for (MethodSpi newM : newType.getMethods()) {
                if (!oldSig.equals(SpiWithJdtUtils.createMethodId(newM))) continue;
                return newM;
            }
        }
        return null;
    }

    @Override
    protected IMethod internalCreateApi() {
        return new MethodImplementor(this);
    }

    public AbstractMethodDeclaration getInternalMethodDeclaration() {
        return this.m_astNode;
    }

    @Override
    public boolean isConstructor() {
        return this.m_astNode.isConstructor();
    }

    @Override
    public TypeSpi getReturnType() {
        if (this.m_returnType == null && this.m_astNode instanceof MethodDeclaration) {
            TypeSpi result;
            TypeReference ref = ((MethodDeclaration)this.m_astNode).returnType;
            if (ref.resolvedType == null) {
                ref.resolveType((BlockScope)this.m_astNode.scope);
            }
            this.m_returnType = result = SpiWithJdtUtils.bindingToType(this.m_env, ref.resolvedType);
        }
        return this.m_returnType;
    }

    public List<DeclarationAnnotationWithJdt> getAnnotations() {
        if (this.m_annotations != null) {
            return this.m_annotations;
        }
        this.m_annotations = SpiWithJdtUtils.createDeclarationAnnotations(this.m_env, this, this.m_astNode.annotations);
        return this.m_annotations;
    }

    @Override
    public int getFlags() {
        if (this.m_flags < 0) {
            this.m_flags = SpiWithJdtUtils.getMethodFlags(this.m_astNode.modifiers, this.isVarArgs(), SpiWithJdtUtils.hasDeprecatedAnnotation(this.m_astNode.annotations));
        }
        return this.m_flags;
    }

    private boolean isVarArgs() {
        Argument[] arguments = this.m_astNode.arguments;
        if (arguments != null && arguments.length > 0) {
            return arguments[arguments.length - 1].isVarArgs();
        }
        return false;
    }

    @Override
    public List<MethodParameterSpi> getParameters() {
        if (this.m_arguments == null) {
            Argument[] arguments = this.m_astNode.arguments;
            if (arguments == null || arguments.length < 1) {
                this.m_arguments = Collections.emptyList();
            } else {
                ArrayList<MethodParameterSpi> result = new ArrayList<MethodParameterSpi>(arguments.length);
                int i = 0;
                while (i < arguments.length) {
                    result.add(this.m_env.createDeclarationMethodParameter(this, arguments[i], i));
                    ++i;
                }
                this.m_arguments = result;
            }
        }
        return this.m_arguments;
    }

    @Override
    public DeclarationTypeWithJdt getDeclaringType() {
        return this.m_declaringType;
    }

    @Override
    public String getElementName() {
        if (this.m_name == null) {
            this.m_name = this.m_astNode.selector != null ? new String(this.m_astNode.selector) : (this.m_astNode.binding.selector != null ? new String(this.m_astNode.binding.selector) : "<clinit>");
        }
        return this.m_name;
    }

    @Override
    public List<TypeSpi> getExceptionTypes() {
        if (this.m_exceptions == null) {
            TypeReference[] exceptions = this.m_astNode.thrownExceptions;
            if (exceptions == null || exceptions.length < 1) {
                this.m_exceptions = Collections.emptyList();
            } else {
                ArrayList<TypeSpi> result = new ArrayList<TypeSpi>(exceptions.length);
                TypeReference[] typeReferenceArray = exceptions;
                int n = exceptions.length;
                int n2 = 0;
                while (n2 < n) {
                    TypeSpi t;
                    TypeReference r = typeReferenceArray[n2];
                    if (r.resolvedType == null) {
                        r.resolveType(SpiWithJdtUtils.classScopeOf(this));
                    }
                    if ((t = SpiWithJdtUtils.bindingToType(this.m_env, r.resolvedType)) != null) {
                        result.add(t);
                    }
                    ++n2;
                }
                this.m_exceptions = result;
            }
        }
        return this.m_exceptions;
    }

    @Override
    public List<TypeParameterSpi> getTypeParameters() {
        if (this.m_typeParameters != null) {
            return this.m_typeParameters;
        }
        TypeParameter[] typeParams = this.m_astNode.typeParameters();
        if (typeParams == null || typeParams.length < 1) {
            this.m_typeParameters = Collections.emptyList();
        } else {
            ArrayList<DeclarationTypeParameterWithJdt> result = new ArrayList<DeclarationTypeParameterWithJdt>(typeParams.length);
            int i = 0;
            while (i < typeParams.length) {
                result.add(this.m_env.createDeclarationTypeParameter(this, typeParams[i], i));
                ++i;
            }
            this.m_typeParameters = Collections.unmodifiableList(result);
        }
        return this.m_typeParameters;
    }

    @Override
    public boolean hasTypeParameters() {
        TypeParameter[] typeParams = this.m_astNode.typeParameters();
        return typeParams != null && typeParams.length > 0;
    }

    @Override
    public DeclarationMethodWithJdt getOriginalMethod() {
        return this;
    }

    @Override
    public ISourceRange getSource() {
        if (this.m_source == null) {
            CompilationUnitSpi cu = this.m_declaringType.getCompilationUnit();
            AbstractMethodDeclaration decl = this.m_astNode;
            this.m_source = this.m_env.getSource(cu, decl.declarationSourceStart, decl.declarationSourceEnd);
        }
        return this.m_source;
    }

    @Override
    public ISourceRange getSourceOfBody() {
        if (this.m_bodySource == null) {
            CompilationUnitSpi cu = this.m_declaringType.getCompilationUnit();
            AbstractMethodDeclaration decl = this.m_astNode;
            this.m_bodySource = this.m_env.getSource(cu, decl.bodyStart, decl.bodyEnd);
        }
        return this.m_bodySource;
    }

    @Override
    public ISourceRange getJavaDoc() {
        if (this.m_javaDocSource == null) {
            CompilationUnitSpi cu = this.m_declaringType.getCompilationUnit();
            AbstractMethodDeclaration decl = this.m_astNode;
            Javadoc doc = decl.javadoc;
            this.m_javaDocSource = doc != null ? this.m_env.getSource(cu, doc.sourceStart, doc.sourceEnd) : ISourceRange.NO_SOURCE;
        }
        return this.m_javaDocSource;
    }
}

