/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.model.sugar;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.eclipse.scout.sdk.core.model.api.IMethod;
import org.eclipse.scout.sdk.core.model.api.IType;
import org.eclipse.scout.sdk.core.model.api.internal.WrappedList;
import org.eclipse.scout.sdk.core.signature.SignatureUtils;

public class MethodQuery {
    private final IType m_type;
    private boolean m_includeSuperClasses = false;
    private boolean m_includeSuperInterfaces = false;
    private String m_name;
    private String m_annotationFqn;
    private String m_methodId;
    private int m_flags = -1;
    private Pattern m_methodNamePattern;
    private Predicate<IMethod> m_filter;
    private int m_maxResultCount = Integer.MAX_VALUE;

    public MethodQuery(IType type) {
        this.m_type = type;
    }

    public MethodQuery withSuperTypes(boolean b) {
        this.m_includeSuperClasses = b;
        this.m_includeSuperInterfaces = b;
        return this;
    }

    public MethodQuery withAnnotation(String fqn) {
        this.m_annotationFqn = fqn;
        return this;
    }

    public MethodQuery withFlags(int flags) {
        this.m_flags = flags;
        return this;
    }

    public MethodQuery withSuperClasses(boolean b) {
        this.m_includeSuperClasses = b;
        return this;
    }

    public MethodQuery withSuperInterfaces(boolean b) {
        this.m_includeSuperInterfaces = b;
        return this;
    }

    public MethodQuery withName(String name) {
        this.m_name = name;
        return this;
    }

    public MethodQuery withMethodIdentifier(String id) {
        this.m_methodId = id;
        return this;
    }

    public MethodQuery withName(Pattern namePattern) {
        this.m_methodNamePattern = namePattern;
        return this;
    }

    public MethodQuery withFilter(Predicate<IMethod> filter) {
        this.m_filter = filter;
        return this;
    }

    public MethodQuery withMaxResultCount(int maxResultCount) {
        this.m_maxResultCount = maxResultCount;
        return this;
    }

    protected boolean accept(IMethod f) {
        if (this.m_name != null && !this.m_name.equals(f.elementName())) {
            return false;
        }
        if (this.m_methodId != null && !this.m_methodId.equals(SignatureUtils.createMethodIdentifier(f))) {
            return false;
        }
        if (this.m_filter != null && !this.m_filter.test(f)) {
            return false;
        }
        if (this.m_flags >= 0 && (f.flags() & this.m_flags) != this.m_flags) {
            return false;
        }
        if (this.m_methodNamePattern != null && !this.m_methodNamePattern.matcher(f.elementName()).matches()) {
            return false;
        }
        return this.m_annotationFqn == null || f.annotations().withName(this.m_annotationFqn).existsAny();
    }

    protected void visitRec(IType t, List<IMethod> result, int maxCount, boolean onlyTraverse) {
        if (t == null) {
            return;
        }
        if (!onlyTraverse) {
            for (IMethod f : new WrappedList(t.unwrap().getMethods())) {
                if (!this.accept(f)) continue;
                result.add(f);
                if (result.size() < maxCount) continue;
                return;
            }
        }
        if (this.m_includeSuperClasses || this.m_includeSuperInterfaces) {
            this.visitRec(t.superClass(), result, maxCount, !this.m_includeSuperClasses);
            if (result.size() >= maxCount) {
                return;
            }
        }
        if (this.m_includeSuperInterfaces) {
            for (IType superInterface : t.superInterfaces()) {
                this.visitRec(superInterface, result, maxCount, false);
                if (result.size() < maxCount) continue;
                return;
            }
        }
    }

    public boolean existsAny() {
        return this.first() != null;
    }

    public IMethod first() {
        ArrayList<IMethod> result = new ArrayList<IMethod>(1);
        this.visitRec(this.m_type, result, 1, false);
        return result.isEmpty() ? null : (IMethod)result.get(0);
    }

    public List<IMethod> list() {
        ArrayList<IMethod> result = new ArrayList<IMethod>(this.m_type.unwrap().getMethods().size());
        this.visitRec(this.m_type, result, this.m_maxResultCount, false);
        return result;
    }
}

