/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.signature;

import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.eclipse.scout.sdk.core.signature.Signature;
import org.eclipse.scout.sdk.core.signature.SignatureUtils;

public class SignatureDescriptor {
    private final String m_signature;
    private final String m_packageName;
    private final String m_simpleName;
    private final String m_qualifier;
    private final String m_qualifiedName;

    public SignatureDescriptor(String signature) {
        this.m_signature = (String)Validate.notNull((Object)signature);
        if (this.isBaseType()) {
            this.m_packageName = null;
            this.m_simpleName = Signature.getSignatureSimpleName(signature);
            this.m_qualifier = null;
            this.m_qualifiedName = this.m_simpleName;
        } else if (this.isUnresolved()) {
            this.m_packageName = null;
            this.m_simpleName = Signature.toString(signature);
            this.m_qualifier = null;
            this.m_qualifiedName = this.m_simpleName;
        } else {
            String sigWithoutDollar = signature.replace('$', '.');
            this.m_qualifier = Signature.getSignatureQualifier(sigWithoutDollar);
            this.m_packageName = Signature.getSignatureQualifier(signature);
            this.m_simpleName = Signature.getSignatureSimpleName(sigWithoutDollar);
            this.m_qualifiedName = StringUtils.isEmpty((CharSequence)this.m_qualifier) ? this.m_simpleName : String.valueOf(this.m_qualifier) + '.' + this.m_simpleName;
        }
    }

    public boolean isBaseType() {
        return Signature.getTypeSignatureKind(this.m_signature) == 2;
    }

    public boolean isUnresolved() {
        return SignatureUtils.isUnresolved(this.m_signature);
    }

    public String getSignature() {
        return this.m_signature;
    }

    public String getPackageName() {
        return this.m_packageName;
    }

    public String getSimpleName() {
        return this.m_simpleName;
    }

    public String getQualifier() {
        return this.m_qualifier;
    }

    public String getQualifiedName() {
        return this.m_qualifiedName;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("SignatureDescriptor [");
        builder.append("signature=").append(this.m_signature).append(", ");
        if (this.m_packageName != null) {
            builder.append("packageName=").append(this.m_packageName).append(", ");
        }
        if (this.m_simpleName != null) {
            builder.append("simpleName=").append(this.m_simpleName).append(", ");
        }
        if (this.m_qualifier != null) {
            builder.append("qualifier=").append(this.m_qualifier).append(", ");
        }
        if (this.m_qualifiedName != null) {
            builder.append("qualifiedName=").append(this.m_qualifiedName);
        }
        builder.append("]");
        return builder.toString();
    }

    public int hashCode() {
        return this.m_signature.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SignatureDescriptor other = (SignatureDescriptor)obj;
        return Objects.equals(this.m_signature, other.m_signature);
    }
}

