/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.sourcebuilder.method;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.scout.sdk.core.model.api.Flags;
import org.eclipse.scout.sdk.core.model.api.IJavaEnvironment;
import org.eclipse.scout.sdk.core.model.api.IMethod;
import org.eclipse.scout.sdk.core.model.api.IType;
import org.eclipse.scout.sdk.core.signature.SignatureUtils;
import org.eclipse.scout.sdk.core.sourcebuilder.RawSourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.annotation.AnnotationSourceBuilderFactory;
import org.eclipse.scout.sdk.core.sourcebuilder.comment.CommentSourceBuilderFactory;
import org.eclipse.scout.sdk.core.sourcebuilder.compilationunit.CompilationUnitSourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.field.IFieldSourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.method.IMethodSourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.method.MethodBodySourceBuilderFactory;
import org.eclipse.scout.sdk.core.sourcebuilder.method.MethodSourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.methodparameter.IMethodParameterSourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.methodparameter.MethodParameterSourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.type.ITypeSourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.type.TypeSourceBuilder;
import org.eclipse.scout.sdk.core.util.CoreUtils;

public final class MethodSourceBuilderFactory {
    private static final AtomicLong tempTypeCounter = new AtomicLong(0L);

    private MethodSourceBuilderFactory() {
    }

    public static IMethodSourceBuilder createConstructor(String typeName) {
        return MethodSourceBuilderFactory.createConstructor(typeName, 1, new IMethodParameterSourceBuilder[0]);
    }

    public static IMethodSourceBuilder createConstructor(String typeName, int flags, IMethodParameterSourceBuilder ... parameters) {
        MethodSourceBuilder constructorSourceBuilder = new MethodSourceBuilder(typeName);
        constructorSourceBuilder.setFlags(flags);
        if (parameters != null) {
            IMethodParameterSourceBuilder[] iMethodParameterSourceBuilderArray = parameters;
            int n = parameters.length;
            int n2 = 0;
            while (n2 < n) {
                IMethodParameterSourceBuilder p = iMethodParameterSourceBuilderArray[n2];
                constructorSourceBuilder.addParameter(p);
                ++n2;
            }
        }
        return constructorSourceBuilder;
    }

    public static List<IMethodSourceBuilder> createUnimplementedMethods(ITypeSourceBuilder builder, String targetPackage, IJavaEnvironment env) {
        return MethodSourceBuilderFactory.createUnimplementedMethods(builder.getSuperTypeSignature(), builder.getInterfaceSignatures(), targetPackage, env);
    }

    public static List<IMethodSourceBuilder> createUnimplementedMethods(String superTypeSignature, Collection<String> superInterfacesSignatures, String targetPackage, IJavaEnvironment env) {
        IType tmpType = MethodSourceBuilderFactory.createTmpType(superTypeSignature, superInterfacesSignatures, targetPackage, env);
        List<IMethod> unimplementedMehtods = MethodSourceBuilderFactory.getUnimplementedMehtods(tmpType);
        if (unimplementedMehtods.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<IMethodSourceBuilder> result = new ArrayList<IMethodSourceBuilder>(unimplementedMehtods.size());
        for (IMethod method : unimplementedMehtods) {
            IMethodSourceBuilder unimplMethodBuilder = MethodSourceBuilderFactory.createOverride(method);
            if (unimplMethodBuilder.getBody() == null) {
                unimplMethodBuilder.setBody(MethodBodySourceBuilderFactory.createAutoGenerated(unimplMethodBuilder));
            }
            result.add(unimplMethodBuilder);
        }
        return result;
    }

    private static IType createTmpType(String superTypeSignature, Collection<String> superInterfacesSignatures, String targetPackage, IJavaEnvironment env) {
        String typeName = "ScoutSdkTempDummyClass" + tempTypeCounter.incrementAndGet() + "__";
        CompilationUnitSourceBuilder tmpCuBuilder = new CompilationUnitSourceBuilder(String.valueOf(typeName) + ".java", targetPackage);
        TypeSourceBuilder mainType = new TypeSourceBuilder(typeName);
        if (StringUtils.isNotBlank((CharSequence)superTypeSignature) && !"Ljava.lang.Object;".equals(superTypeSignature)) {
            mainType.setSuperTypeSignature(superTypeSignature);
        }
        if (superInterfacesSignatures != null && !superInterfacesSignatures.isEmpty()) {
            for (String ifcSig : superInterfacesSignatures) {
                mainType.addInterfaceSignature(ifcSig);
            }
        }
        tmpCuBuilder.addType(mainType);
        IJavaEnvironment emptyCopy = env.unwrap().emptyCopy().wrap();
        StringBuilder newSrc = new StringBuilder(CoreUtils.createJavaCode(tmpCuBuilder, emptyCopy, "\n", null));
        emptyCopy.registerCompilationUnitOverride(tmpCuBuilder.getPackageName(), tmpCuBuilder.getElementName(), newSrc);
        return emptyCopy.findType(mainType.getFullyQualifiedName());
    }

    private static List<IMethod> getUnimplementedMehtods(IType type) {
        if (type == null) {
            return Collections.emptyList();
        }
        HashMap<String, IMethod> abstractMethodIds = new HashMap<String, IMethod>();
        Predicate<IMethod> abstractMethodFilter = new Predicate<IMethod>(){

            @Override
            public boolean test(IMethod element) {
                int flags = element.flags();
                return Flags.isAbstract(flags) || Flags.isInterface(flags) || Flags.isInterface(element.declaringType().flags());
            }
        };
        Predicate<IMethod> notAbstractMethodFilter = abstractMethodFilter.negate();
        List<IMethod> abstractMethods = type.methods().withSuperTypes(true).withFilter(abstractMethodFilter).list();
        for (IMethod method : abstractMethods) {
            abstractMethodIds.put(SignatureUtils.createMethodIdentifier(method, true), method);
        }
        List<IMethod> notAbstractMethods = type.methods().withSuperClasses(true).withFilter(notAbstractMethodFilter).list();
        for (IMethod method : notAbstractMethods) {
            if (Flags.isPrivate(method.flags())) continue;
            abstractMethodIds.remove(SignatureUtils.createMethodIdentifier(method, true));
        }
        return new ArrayList<IMethod>(abstractMethodIds.values());
    }

    private static IMethod getMethodToOverride(ITypeSourceBuilder typeSourceBuilder, String targetPackage, IJavaEnvironment lookupContext, Predicate<IMethod> methodFilter) {
        IType tmpType = MethodSourceBuilderFactory.createTmpType(typeSourceBuilder.getSuperTypeSignature(), typeSourceBuilder.getInterfaceSignatures(), targetPackage, lookupContext);
        if (tmpType == null) {
            return null;
        }
        return tmpType.methods().withSuperTypes(true).withFilter(methodFilter).first();
    }

    public static IMethodSourceBuilder createOverride(ITypeSourceBuilder typeSourceBuilder, String targetPackage, IJavaEnvironment lookupContext, String methodName) {
        return MethodSourceBuilderFactory.createOverride(typeSourceBuilder, targetPackage, lookupContext, methodName, null);
    }

    public static IMethodSourceBuilder createOverride(ITypeSourceBuilder typeSourceBuilder, String targetPackage, IJavaEnvironment lookupContext, final String methodName, Predicate<IMethod> methodFilter) {
        Predicate<IMethod> filter = null;
        Predicate<IMethod> nameFilter = new Predicate<IMethod>(){

            @Override
            public boolean test(IMethod element) {
                return element.elementName().equals(methodName);
            }
        };
        filter = methodFilter == null ? nameFilter : nameFilter.and(methodFilter);
        IMethod methodToOverride = MethodSourceBuilderFactory.getMethodToOverride(typeSourceBuilder, targetPackage, lookupContext, filter);
        if (methodToOverride == null) {
            return null;
        }
        return MethodSourceBuilderFactory.createOverride(methodToOverride);
    }

    public static IMethodSourceBuilder createOverride(String methodName, IType declaringType) {
        IMethod methodToOverride = declaringType.methods().withSuperTypes(true).withName(methodName).first();
        if (methodToOverride == null) {
            return null;
        }
        return MethodSourceBuilderFactory.createOverride(methodToOverride);
    }

    public static IMethodSourceBuilder createOverride(IMethod method) {
        MethodSourceBuilder builder = new MethodSourceBuilder(method);
        if (!Flags.isInterface(method.declaringType().flags()) && !Flags.isAbstract(method.flags())) {
            builder.setBody(MethodBodySourceBuilderFactory.createSuperCall(builder, true));
        }
        builder.setFlags(builder.getFlags() & 0xFFFFFBFF & 0xFFFFFDFF);
        builder.setComment(null);
        for (IMethodParameterSourceBuilder parameterSourceBuilder : builder.getParameters()) {
            parameterSourceBuilder.removeAllAnnotations();
        }
        builder.removeAllAnnotations();
        builder.addAnnotation(AnnotationSourceBuilderFactory.createOverride());
        return builder;
    }

    public static IMethodSourceBuilder createGetter(IFieldSourceBuilder fieldSourceBuilder) {
        return MethodSourceBuilderFactory.createGetter(fieldSourceBuilder.getElementName(), fieldSourceBuilder.getSignature());
    }

    public static IMethodSourceBuilder createGetter(String fieldName, String signature) {
        return MethodSourceBuilderFactory.createGetter(fieldName, signature, 1, true);
    }

    public static IMethodSourceBuilder createGetter(String fieldName, String signature, int flags, boolean autoCreateBody) {
        StringBuilder methodName = new StringBuilder(CoreUtils.getGetterMethodPrefix(signature));
        methodName.append(MethodSourceBuilderFactory.getGetterSetterBaseName(fieldName));
        MethodSourceBuilder getterBuilder = new MethodSourceBuilder(methodName.toString());
        getterBuilder.setReturnTypeSignature(signature);
        getterBuilder.setFlags(flags);
        getterBuilder.setComment(CommentSourceBuilderFactory.createDefaultGetterMethodComment(getterBuilder));
        if (autoCreateBody) {
            getterBuilder.setBody(new RawSourceBuilder("return " + fieldName + ';'));
        }
        return getterBuilder;
    }

    public static IMethodSourceBuilder createSetter(IFieldSourceBuilder fieldSourceBuilder) {
        return MethodSourceBuilderFactory.createSetter(fieldSourceBuilder.getElementName(), fieldSourceBuilder.getSignature());
    }

    public static IMethodSourceBuilder createSetter(String fieldName, String signature) {
        return MethodSourceBuilderFactory.createSetter(fieldName, signature, 1, true);
    }

    private static String getGetterSetterBaseName(String fieldName) {
        StringBuilder sb = new StringBuilder(fieldName);
        if (sb.length() > 1 && sb.charAt(0) == 'm' && sb.charAt(1) == '_') {
            sb.delete(0, 2);
        }
        if (sb.length() > 0) {
            sb.setCharAt(0, Character.toUpperCase(sb.charAt(0)));
        }
        return sb.toString();
    }

    public static IMethodSourceBuilder createSetter(String fieldName, String signature, int flags, boolean autoCreateBody) {
        return MethodSourceBuilderFactory.createSetter(fieldName, signature, flags, autoCreateBody, null);
    }

    public static IMethodSourceBuilder createSetter(String fieldName, String signature, int flags, boolean autoCreateBody, String paramNamePrefix) {
        String name = MethodSourceBuilderFactory.getGetterSetterBaseName(fieldName);
        MethodSourceBuilder setterBuilder = new MethodSourceBuilder("set" + name);
        setterBuilder.setFlags(flags);
        setterBuilder.setReturnTypeSignature("V");
        StringBuilder paramNameBuilder = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)paramNamePrefix)) {
            paramNameBuilder.append(paramNamePrefix);
            paramNameBuilder.append(name);
        } else {
            paramNameBuilder.append(CoreUtils.ensureStartWithLowerCase(name));
        }
        String paramName = CoreUtils.ensureValidParameterName(paramNameBuilder.toString());
        setterBuilder.addParameter(new MethodParameterSourceBuilder(paramName, signature));
        setterBuilder.setComment(CommentSourceBuilderFactory.createDefaultSetterMethodComment(setterBuilder));
        if (autoCreateBody) {
            StringBuilder body = new StringBuilder(fieldName);
            body.append(" = ");
            body.append(paramName);
            body.append(';');
            setterBuilder.setBody(new RawSourceBuilder(body.toString()));
        }
        return setterBuilder;
    }
}

