/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.sourcebuilder.methodparameter;

import org.eclipse.scout.sdk.core.importvalidator.IImportValidator;
import org.eclipse.scout.sdk.core.model.api.Flags;
import org.eclipse.scout.sdk.core.model.api.IMethodParameter;
import org.eclipse.scout.sdk.core.signature.SignatureUtils;
import org.eclipse.scout.sdk.core.sourcebuilder.AbstractAnnotatableSourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.methodparameter.IMethodParameterSourceBuilder;
import org.eclipse.scout.sdk.core.util.PropertyMap;

public class MethodParameterSourceBuilder
extends AbstractAnnotatableSourceBuilder
implements IMethodParameterSourceBuilder {
    private int m_flags;
    private String m_dataTypeSignature;

    public MethodParameterSourceBuilder(IMethodParameter element) {
        super(element);
        this.setFlags(element.flags());
        this.setDataTypeSignature(SignatureUtils.getTypeSignature(element.dataType()));
    }

    public MethodParameterSourceBuilder(String elementName, String dataTypeSignature) {
        super(elementName);
        this.setDataTypeSignature(dataTypeSignature);
    }

    @Override
    public int getFlags() {
        return this.m_flags;
    }

    @Override
    public void setFlags(int flags) {
        this.m_flags = flags;
    }

    @Override
    public String getDataTypeSignature() {
        return this.m_dataTypeSignature;
    }

    @Override
    public void setDataTypeSignature(String dataTypeSignature) {
        this.m_dataTypeSignature = dataTypeSignature;
    }

    @Override
    public void createSource(StringBuilder source, String lineDelimiter, PropertyMap context, IImportValidator validator) {
        super.createSource(source, lineDelimiter, context, validator);
        if (this.m_flags != 0) {
            source.append(Flags.toString(this.m_flags)).append(' ');
        }
        source.append(validator.useSignature(this.m_dataTypeSignature)).append(' ');
        source.append(this.getElementName());
    }
}

