/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.sourcebuilder.type;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.eclipse.scout.sdk.core.importcollector.IImportCollector;
import org.eclipse.scout.sdk.core.importvalidator.IImportValidator;
import org.eclipse.scout.sdk.core.model.api.Flags;
import org.eclipse.scout.sdk.core.model.api.IField;
import org.eclipse.scout.sdk.core.model.api.IMethod;
import org.eclipse.scout.sdk.core.model.api.IType;
import org.eclipse.scout.sdk.core.model.api.ITypeParameter;
import org.eclipse.scout.sdk.core.signature.SignatureUtils;
import org.eclipse.scout.sdk.core.sourcebuilder.AbstractMemberSourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.ISourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.compilationunit.ICompilationUnitSourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.field.FieldSourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.field.IFieldSourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.method.IMethodSourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.method.MethodSourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.type.EnclosingTypeScopedImportCollector;
import org.eclipse.scout.sdk.core.sourcebuilder.type.ITypeSourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.typeparameter.ITypeParameterSourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.typeparameter.TypeParameterSourceBuilder;
import org.eclipse.scout.sdk.core.util.CompositeObject;
import org.eclipse.scout.sdk.core.util.PropertyMap;

public class TypeSourceBuilder
extends AbstractMemberSourceBuilder
implements ITypeSourceBuilder {
    private String m_superTypeSignature;
    private String m_parentFullyQualifiedName;
    private ISourceBuilder m_declaringElement;
    private final List<ITypeParameterSourceBuilder> m_typeParameters = new ArrayList<ITypeParameterSourceBuilder>();
    private final List<String> m_interfaceSignatures = new ArrayList<String>();
    private final List<IFieldSourceBuilder> m_fields = new ArrayList<IFieldSourceBuilder>();
    private final Map<CompositeObject, IFieldSourceBuilder> m_sortedFields = new TreeMap<CompositeObject, IFieldSourceBuilder>();
    private final List<IMethodSourceBuilder> m_methods = new ArrayList<IMethodSourceBuilder>();
    private final Map<CompositeObject, IMethodSourceBuilder> m_sortedMethods = new TreeMap<CompositeObject, IMethodSourceBuilder>();
    private final List<ITypeSourceBuilder> m_types = new ArrayList<ITypeSourceBuilder>();
    private final Map<CompositeObject, ITypeSourceBuilder> m_sortedTypes = new TreeMap<CompositeObject, ITypeSourceBuilder>();

    public TypeSourceBuilder(IType element) {
        super(element);
        for (ITypeParameter p : element.typeParameters()) {
            this.addTypeParameter(new TypeParameterSourceBuilder(p));
        }
        if (element.superClass() != null && !"java.lang.Object".equals(element.superClass().name())) {
            this.setSuperTypeSignature(SignatureUtils.getTypeSignature(element.superClass()));
        }
        for (IType i : element.superInterfaces()) {
            this.addInterfaceSignature(SignatureUtils.getTypeSignature(i));
        }
        for (IField field : element.fields().list()) {
            this.addField(new FieldSourceBuilder(field));
        }
        for (IMethod method : element.methods().list()) {
            this.addMethod(new MethodSourceBuilder(method));
        }
        for (IType type : element.innerTypes().list()) {
            this.addType(new TypeSourceBuilder(type));
        }
    }

    public TypeSourceBuilder(String elementName) {
        super(elementName);
    }

    @Override
    public void createSource(StringBuilder source, String lineDelimiter, PropertyMap context, IImportValidator validator) {
        IImportCollector origImportCollector = validator.getImportCollector();
        EnclosingTypeScopedImportCollector collector = new EnclosingTypeScopedImportCollector(origImportCollector, this);
        validator.setImportCollector(collector);
        try {
            Iterator<String> interfaceSigIterator;
            super.createSource(source, lineDelimiter, context, validator);
            if (Flags.isInterface(this.getFlags()) && this.getSuperTypeSignature() != null) {
                throw new IllegalArgumentException("An interface can not have a superclass.");
            }
            source.append(Flags.toString(this.getFlags())).append(' ');
            source.append((this.getFlags() & 0x200) != 0 ? "interface " : "class ");
            source.append(this.getElementName());
            if (!this.m_typeParameters.isEmpty()) {
                source.append('<');
                for (ITypeParameterSourceBuilder p : this.m_typeParameters) {
                    p.createSource(source, lineDelimiter, context, validator);
                    source.append(", ");
                }
                source.setLength(source.length() - 2);
                source.append('>');
            }
            if (!StringUtils.isEmpty((CharSequence)this.getSuperTypeSignature())) {
                String superTypeRefName = validator.useSignature(this.getSuperTypeSignature());
                source.append(" extends ").append(superTypeRefName);
            }
            if ((interfaceSigIterator = this.getInterfaceSignatures().iterator()).hasNext()) {
                source.append((this.getFlags() & 0x200) != 0 ? " extends " : " implements ");
                source.append(validator.useSignature(interfaceSigIterator.next()));
                while (interfaceSigIterator.hasNext()) {
                    source.append(", ").append(validator.useSignature(interfaceSigIterator.next()));
                }
            }
            source.append(" {");
            this.createTypeContent(source, lineDelimiter, context, validator);
            source.append(lineDelimiter);
            source.append('}');
        }
        finally {
            validator.setImportCollector(origImportCollector);
        }
    }

    protected void createTypeContent(StringBuilder source, String lineDelimiter, PropertyMap context, IImportValidator validator) {
        List<ITypeSourceBuilder> innerTypes;
        List<IMethodSourceBuilder> methodSourceBuilders;
        List<IFieldSourceBuilder> fieldSourceBuilders = this.getFields();
        if (!fieldSourceBuilders.isEmpty()) {
            source.append(lineDelimiter);
            for (IFieldSourceBuilder builder : fieldSourceBuilders) {
                if (builder == null) continue;
                source.append(lineDelimiter);
                builder.createSource(source, lineDelimiter, context, validator);
            }
        }
        if (!(methodSourceBuilders = this.getMethods()).isEmpty()) {
            source.append(lineDelimiter);
            for (IMethodSourceBuilder op : methodSourceBuilders) {
                if (op == null) continue;
                source.append(lineDelimiter);
                op.createSource(source, lineDelimiter, context, validator);
            }
        }
        if (!(innerTypes = this.getTypes()).isEmpty()) {
            source.append(lineDelimiter);
            for (ITypeSourceBuilder op : innerTypes) {
                if (op == null) continue;
                source.append(lineDelimiter);
                op.createSource(source, lineDelimiter, context, validator);
            }
        }
    }

    @Override
    public void addTypeParameter(ITypeParameterSourceBuilder typeParameter) {
        this.m_typeParameters.add(typeParameter);
    }

    @Override
    public boolean removeTypeParameter(String elementName) {
        Iterator<ITypeParameterSourceBuilder> it = this.m_typeParameters.iterator();
        while (it.hasNext()) {
            if (!elementName.equals(it.next().getElementName())) continue;
            it.remove();
            return true;
        }
        return false;
    }

    @Override
    public List<ITypeParameterSourceBuilder> getTypeParameters() {
        return Collections.unmodifiableList(this.m_typeParameters);
    }

    @Override
    public void setSuperTypeSignature(String superTypeSignature) {
        this.m_superTypeSignature = superTypeSignature;
    }

    @Override
    public String getSuperTypeSignature() {
        return this.m_superTypeSignature;
    }

    @Override
    public void addInterfaceSignature(String interfaceSignature) {
        this.m_interfaceSignatures.add(interfaceSignature);
    }

    @Override
    public boolean removeInterfaceSignature(String interfaceSignature) {
        return this.m_interfaceSignatures.remove(interfaceSignature);
    }

    @Override
    public void setInterfaceSignatures(Collection<String> interfaceSignatures) {
        this.m_interfaceSignatures.clear();
        if (interfaceSignatures != null) {
            this.m_interfaceSignatures.addAll(interfaceSignatures);
        }
    }

    @Override
    public List<String> getInterfaceSignatures() {
        return this.m_interfaceSignatures;
    }

    @Override
    public void addField(IFieldSourceBuilder builder) {
        if (builder == null) {
            throw new IllegalArgumentException("Source builder can not be null.");
        }
        if (!this.m_sortedFields.isEmpty()) {
            throw new IllegalStateException("This builder has already sorted field builder. A mix between sorted and unsorted field builders is not supported.");
        }
        this.m_fields.add(builder);
    }

    @Override
    public void addSortedField(CompositeObject sortKey, IFieldSourceBuilder builder) {
        if (builder == null) {
            throw new IllegalArgumentException("Source builder can not be null.");
        }
        if (!this.m_fields.isEmpty()) {
            throw new IllegalStateException("This builder has already unsorted field builder. A mix between sorted and unsorted field builders is not supported.");
        }
        this.m_sortedFields.put(sortKey, builder);
    }

    @Override
    public boolean removeField(String elementName) {
        Iterator<IFieldSourceBuilder> it = this.m_fields.iterator();
        while (it.hasNext()) {
            if (!elementName.equals(it.next().getElementName())) continue;
            it.remove();
            return true;
        }
        it = this.m_sortedFields.values().iterator();
        while (it.hasNext()) {
            if (!elementName.equals(it.next().getElementName())) continue;
            it.remove();
            return true;
        }
        return false;
    }

    @Override
    public List<IFieldSourceBuilder> getFields() {
        ArrayList<IFieldSourceBuilder> ops = new ArrayList<IFieldSourceBuilder>(this.m_fields.size() + this.m_sortedFields.size());
        ops.addAll(this.m_fields);
        ops.addAll(this.m_sortedFields.values());
        return ops;
    }

    @Override
    public void addMethod(IMethodSourceBuilder builder) {
        if (builder == null) {
            throw new IllegalArgumentException("Source builder can not be null.");
        }
        if (!this.m_sortedMethods.isEmpty()) {
            throw new IllegalStateException("This source builder has already sorted method builders. A mix between sorted and unsorted method builders is not supported.");
        }
        this.m_methods.add(builder);
    }

    @Override
    public void addSortedMethod(CompositeObject sortKey, IMethodSourceBuilder builder) {
        if (builder == null) {
            throw new IllegalArgumentException("Source builder can not be null.");
        }
        if (!this.m_methods.isEmpty()) {
            throw new IllegalStateException("This source builder has already unsorted method builders. A mix between sorted and unsorted method builders is not supported.");
        }
        this.m_sortedMethods.put(sortKey, builder);
    }

    @Override
    public boolean removeMethod(String elementName) {
        Iterator<IMethodSourceBuilder> it = this.m_methods.iterator();
        while (it.hasNext()) {
            if (!elementName.equals(it.next().getElementName())) continue;
            it.remove();
            return true;
        }
        it = this.m_sortedMethods.values().iterator();
        while (it.hasNext()) {
            if (!elementName.equals(it.next().getElementName())) continue;
            it.remove();
            return true;
        }
        return false;
    }

    @Override
    public IMethodSourceBuilder getMethod(String methodId) {
        for (IMethodSourceBuilder msb : this.getMethods()) {
            if (!methodId.equals(msb.getMethodIdentifier())) continue;
            return msb;
        }
        return null;
    }

    @Override
    public List<IMethodSourceBuilder> getMethods() {
        ArrayList<IMethodSourceBuilder> builders = new ArrayList<IMethodSourceBuilder>(this.m_methods.size() + this.m_sortedMethods.size());
        builders.addAll(this.m_methods);
        builders.addAll(this.m_sortedMethods.values());
        return builders;
    }

    @Override
    public void addType(ITypeSourceBuilder builder) {
        if (builder == null) {
            throw new IllegalArgumentException("Source builder can not be null.");
        }
        if (!this.m_sortedTypes.isEmpty()) {
            throw new IllegalStateException("This builder has already sorted inner type builders. A mix between sorted and unsorted inner type builders is not supported.");
        }
        this.m_types.add(builder);
        builder.setDeclaringElement(this);
    }

    @Override
    public void addSortedType(CompositeObject sortKey, ITypeSourceBuilder builder) {
        if (builder == null) {
            throw new IllegalArgumentException("Source builder can not be null.");
        }
        if (!this.m_types.isEmpty()) {
            throw new IllegalStateException("This builder has already unsorted inner type builders. A mix between sorted and unsorted inner type builders is not supported.");
        }
        this.m_sortedTypes.put(sortKey, builder);
        builder.setDeclaringElement(this);
    }

    @Override
    public boolean removeType(String elementName) {
        ITypeSourceBuilder builder = null;
        Iterator<ITypeSourceBuilder> it = this.m_types.iterator();
        while (it.hasNext()) {
            builder = it.next();
            if (!elementName.equals(builder.getElementName())) continue;
            builder.setDeclaringElement(null);
            it.remove();
            return true;
        }
        it = this.m_sortedTypes.values().iterator();
        while (it.hasNext()) {
            builder = it.next();
            if (!elementName.equals(builder.getElementName())) continue;
            builder.setDeclaringElement(null);
            it.remove();
            return true;
        }
        return false;
    }

    @Override
    public List<ITypeSourceBuilder> getTypes() {
        ArrayList<ITypeSourceBuilder> typeBuilders = new ArrayList<ITypeSourceBuilder>(this.m_types.size() + this.m_sortedTypes.size());
        typeBuilders.addAll(this.m_types);
        typeBuilders.addAll(this.m_sortedTypes.values());
        return typeBuilders;
    }

    @Override
    public ISourceBuilder getDeclaringElement() {
        return this.m_declaringElement;
    }

    @Override
    public void setDeclaringElement(ISourceBuilder declaringElement) {
        this.m_declaringElement = declaringElement;
    }

    @Override
    public String getFullyQualifiedName() {
        ISourceBuilder parent = this.getDeclaringElement();
        StringBuilder sb = new StringBuilder();
        if (parent instanceof ITypeSourceBuilder) {
            sb.append(((ITypeSourceBuilder)parent).getFullyQualifiedName()).append('$');
        } else if (parent instanceof ICompilationUnitSourceBuilder) {
            String packageName = ((ICompilationUnitSourceBuilder)parent).getPackageName();
            if (StringUtils.isNotBlank((CharSequence)packageName)) {
                sb.append(packageName).append('.');
            }
        } else {
            sb.append((String)Validate.notNull((Object)this.getParentFullyQualifiedName())).append('$');
        }
        sb.append(this.getElementName());
        return sb.toString();
    }

    @Override
    public String getParentFullyQualifiedName() {
        return this.m_parentFullyQualifiedName;
    }

    @Override
    public void setParentFullyQualifiedName(String parentFullyQualifiedName) {
        this.m_parentFullyQualifiedName = parentFullyQualifiedName;
    }
}

