/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.util;

import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.scout.sdk.core.util.SdkLog;

public class OptimisticLock {
    private final AtomicInteger m_lockCount = new AtomicInteger(0);

    public synchronized boolean acquire() {
        int count = this.m_lockCount.incrementAndGet();
        if (count == 1) {
            return true;
        }
        if (count > 10) {
            SdkLog.error("potential programming problem; lock was 10 times acquired and not released", new Exception("origin"));
        }
        return false;
    }

    public void release() {
        if (this.m_lockCount.decrementAndGet() < 0) {
            SdkLog.error("potential programming problem. lock is negative", new Exception("origin"));
        }
    }

    public boolean isAcquired() {
        return this.m_lockCount.get() > 0;
    }

    public boolean isReleased() {
        return !this.isAcquired();
    }
}

