/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.asd.design.editparts;

import java.util.Collections;
import java.util.List;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.wst.wsdl.ui.internal.asd.Messages;
import org.eclipse.wst.wsdl.ui.internal.asd.design.DesignViewGraphicsConstants;
import org.eclipse.wst.wsdl.ui.internal.asd.design.connections.CenteredConnectionAnchor;
import org.eclipse.wst.wsdl.ui.internal.asd.design.editparts.BaseConnectedEditPart;
import org.eclipse.wst.wsdl.ui.internal.asd.design.editparts.BindingColumnEditPart;
import org.eclipse.wst.wsdl.ui.internal.asd.design.editparts.EditPartNavigationHandlerUtil;
import org.eclipse.wst.wsdl.ui.internal.asd.design.editpolicies.ASDSelectionEditPolicy;
import org.eclipse.wst.wsdl.ui.internal.asd.design.figures.BoxComponentFigure;
import org.eclipse.wst.wsdl.ui.internal.asd.design.layouts.BindingColumnLayout;
import org.eclipse.wst.wsdl.ui.internal.asd.design.layouts.BindingContentLayout;
import org.eclipse.wst.wsdl.ui.internal.asd.design.layouts.BindingLayout;
import org.eclipse.wst.wsdl.ui.internal.asd.facade.IBinding;
import org.eclipse.wst.wsdl.ui.internal.asd.facade.IInterface;
import org.eclipse.wst.wsdl.ui.internal.asd.outline.ITreeElement;

public class BindingEditPart
extends BaseConnectedEditPart {
    protected BoxComponentFigure figure;
    protected boolean isExpanded = false;
    private Label hoverHelpLabel = new Label("");

    protected IFigure createFigure() {
        this.figure = new BoxComponentFigure();
        this.figure.getLabel().setBorder((Border)new MarginBorder(2, 2, 1, 2));
        this.figure.setBorder((Border)new LineBorder(0));
        this.figure.getContentPane().setLayoutManager((LayoutManager)new BindingContentLayout(this));
        this.figure.getContentPane().setOpaque(true);
        this.figure.getContentPane().setBackgroundColor(ColorConstants.yellow);
        this.figure.setLayoutManager((LayoutManager)new BindingLayout(this));
        return this.figure;
    }

    public IFigure getContentPane() {
        return this.figure.getContentPane();
    }

    protected List getModelChildren() {
        IBinding binding = (IBinding)this.getModel();
        return this.isExpanded ? binding.getBindingContentList() : Collections.EMPTY_LIST;
    }

    public void addFeedback() {
        LineBorder boxFigureLineBorder = (LineBorder)this.figure.getBorder();
        boxFigureLineBorder.setWidth(2);
        this.figure.setSelected(true);
        this.figure.repaint();
        super.addFeedback();
    }

    public void removeFeedback() {
        LineBorder boxFigureLineBorder = (LineBorder)this.figure.getBorder();
        boxFigureLineBorder.setWidth(1);
        boxFigureLineBorder.setColor(DesignViewGraphicsConstants.defaultForegroundColor);
        this.figure.setSelected(false);
        this.figure.repaint();
        super.removeFeedback();
    }

    protected boolean shouldDrawConnection() {
        if (this.isExpanded) {
            return false;
        }
        return super.shouldDrawConnection();
    }

    protected void refreshVisuals() {
        this.refreshConnections();
        if (this.getModel() instanceof IBinding) {
            IBinding binding = (IBinding)this.getModel();
            ((BoxComponentFigure)this.getFigure()).headingFigure.setIsReadOnly(((IBinding)this.getModel()).isReadOnly());
            if (binding instanceof ITreeElement) {
                this.figure.getLabel().setIcon(((ITreeElement)((Object)binding)).getImage());
            }
            String prependString = Messages._UI_LABEL_BINDING;
            this.hoverHelpLabel.setText(" " + prependString + " : " + binding.getName() + " ");
            this.figure.setToolTip((IFigure)this.hoverHelpLabel);
        }
        super.refreshVisuals();
    }

    protected AbstractGraphicalEditPart getConnectionTargetEditPart() {
        IBinding binding = (IBinding)this.getModel();
        IInterface typeBeingRef = binding.getInterface();
        if (typeBeingRef != null) {
            AbstractGraphicalEditPart referenceTypePart = (AbstractGraphicalEditPart)this.getViewer().getEditPartRegistry().get(typeBeingRef);
            return referenceTypePart;
        }
        return null;
    }

    public void refreshConnections() {
        if (this.shouldDrawConnection()) {
            if (this.connectionFigure != null) {
                AbstractGraphicalEditPart referenceTypePart = this.getConnectionTargetEditPart();
                IFigure refFigure = referenceTypePart.getFigure();
                this.connectionFigure.setSourceAnchor((ConnectionAnchor)new CenteredConnectionAnchor(this.getFigure(), 3, 0));
                this.connectionFigure.setTargetAnchor((ConnectionAnchor)new CenteredConnectionAnchor(refFigure, 4, 0, 11));
                this.connectionFigure.setHighlight(false);
                this.connectionFigure.setVisible(true);
                if (this.connectionFeedbackFigure != null) {
                    this.addConnectionFeedbackFigure();
                }
            } else {
                this.activateConnection();
            }
        } else if (this.connectionFigure != null) {
            this.connectionFigure.setVisible(false);
            this.removeConnectionFeedbackFigure();
        }
    }

    protected void createEditPolicies() {
        super.createEditPolicies();
        this.installEditPolicy("Selection Feedback", (EditPolicy)new ASDSelectionEditPolicy());
    }

    public boolean isExpanded() {
        return this.isExpanded;
    }

    public void setExpanded(boolean isExpanded) {
        this.isExpanded = isExpanded;
    }

    public void performRequest(Request request) {
        LayoutManager layoutManager;
        if (request.getType() == "open" && (layoutManager = this.getFigure().getParent().getLayoutManager()) instanceof BindingColumnLayout) {
            BindingColumnLayout bindingColumnLayout = (BindingColumnLayout)layoutManager;
            bindingColumnLayout.setExpanded(this, !this.isExpanded);
            ((BindingColumnEditPart)this.getParent()).refreshBindingEditParts();
        }
    }

    public EditPart getRelativeEditPart(int direction) {
        if (direction == 16) {
            if (this.connectionFigure != null) {
                return this.getConnectionTargetEditPart();
            }
            return EditPartNavigationHandlerUtil.getFirstInterface((EditPart)this);
        }
        if (direction == 8) {
            EditPart connectedService = EditPartNavigationHandlerUtil.getSourceConnectionEditPart(this);
            if (connectedService != null) {
                return connectedService;
            }
            return EditPartNavigationHandlerUtil.getFirstService((EditPart)this);
        }
        if (direction == 1) {
            return EditPartNavigationHandlerUtil.getPrevSibling((EditPart)this);
        }
        if (direction == 4 && !this.isExpanded()) {
            EditPart nextSibling = EditPartNavigationHandlerUtil.getNextSibling((EditPart)this);
            if (nextSibling != null) {
                return nextSibling;
            }
            return this;
        }
        return super.getRelativeEditPart(direction);
    }

    protected String getAccessibleName() {
        IBinding binding = (IBinding)this.getModel();
        String bindingName = binding != null && binding.getName() != null ? binding.getName() : "";
        return bindingName;
    }
}

