/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.autagent.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.Serializable;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.text.DefaultEditorKit;
import org.eclipse.jubula.autagent.desktop.DesktopIntegration;
import org.eclipse.jubula.autagent.desktop.listener.StopOMActionListener;
import org.eclipse.jubula.autagent.gui.ObjectMappingSettingsFrame;
import org.eclipse.jubula.autagent.i18n.Messages;
import org.eclipse.jubula.client.core.businessprocess.IObjectMappingObserver;
import org.eclipse.jubula.client.internal.utils.SerilizationUtils;
import org.eclipse.jubula.tools.internal.objects.ComponentIdentifier;
import org.eclipse.jubula.tools.internal.objects.IComponentIdentifier;
import org.eclipse.jubula.tools.internal.registration.AutIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum ObjectMappingFrame implements IObjectMappingObserver
{
    INSTANCE;

    private static final Logger LOG;
    private JLabel m_componentOMAut;
    private JTextField m_componentName = null;
    private JTextField m_componentClass = null;
    private JTextField m_componentIdentfier = null;
    private JFrame m_frame = null;
    private boolean m_firstStartup = false;

    static {
        LOG = LoggerFactory.getLogger(ObjectMappingFrame.class);
    }

    public void showObjectMappingPanel() {
        if (!this.m_firstStartup) {
            this.createFrame();
            this.m_firstStartup = true;
        } else {
            if (!this.m_frame.isVisible()) {
                this.m_frame.setVisible(true);
            }
            this.m_frame.toFront();
        }
    }

    private void createFrame() {
        this.m_frame = new JFrame();
        this.m_frame.setTitle(Messages.OMPaneTitle);
        this.m_frame.setDefaultCloseOperation(0);
        this.m_frame.addWindowListener(new AskBeforeCloseWindowListener());
        this.createMenuBar();
        this.createContent();
        this.m_frame.setSize(800, 200);
        this.m_frame.setVisible(true);
    }

    private void createContent() {
        GridBagLayout layout = new GridBagLayout();
        JPanel panel = new JPanel(layout);
        GridBagConstraints constraints = this.createDefaultConstraints();
        this.createAndAddLabel(panel, Messages.AutInOMM, 0);
        this.createAndAddLabel(panel, Messages.ComponentName, 1);
        this.createAndAddLabel(panel, Messages.ComponentType, 2);
        this.createAndAddLabel(panel, Messages.ComponentIdentifier, 3);
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.fill = 2;
        constraints.weightx = 2.0;
        this.m_componentOMAut = new JLabel();
        this.setOMAutName(null);
        panel.add((Component)this.m_componentOMAut, constraints);
        constraints.gridy = 1;
        this.m_componentName = new JTextField();
        this.m_componentName.setEditable(false);
        panel.add((Component)this.m_componentName, constraints);
        constraints.gridy = 2;
        this.m_componentClass = new JTextField();
        this.m_componentClass.setEditable(false);
        panel.add((Component)this.m_componentClass, constraints);
        constraints.gridy = 3;
        this.m_componentIdentfier = new JTextField();
        this.m_componentIdentfier.setEditable(false);
        this.m_componentIdentfier.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ObjectMappingFrame.this.m_componentIdentfier.selectAll();
            }
        });
        JMenuItem menuItem = new JMenuItem(new DefaultEditorKit.CopyAction());
        menuItem.setText(Messages.CopyToClipboard);
        menuItem.setMnemonic(67);
        JPopupMenu popup = new JPopupMenu();
        popup.add(menuItem);
        this.m_componentIdentfier.add(popup);
        this.m_componentIdentfier.setComponentPopupMenu(popup);
        panel.add((Component)this.m_componentIdentfier, constraints);
        this.m_frame.add(panel);
    }

    public void setOMAutName(String name) {
        if (this.m_componentOMAut != null) {
            if (name == null) {
                this.m_componentOMAut.setForeground(Color.LIGHT_GRAY);
                this.m_componentOMAut.setText(Messages.NoAutInOMM);
            } else {
                this.m_componentOMAut.setForeground(Color.DARK_GRAY);
                this.m_componentOMAut.setText(name);
            }
        }
    }

    public void createAndAddLabel(JPanel panel, String text, int y) {
        GridBagConstraints constraints = this.createDefaultConstraints();
        constraints.gridx = 0;
        constraints.gridy = y;
        JLabel componentIdLabel = new JLabel(text);
        panel.add((Component)componentIdLabel, constraints);
    }

    private GridBagConstraints createDefaultConstraints() {
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.insets = new Insets(2, 10, 0, 10);
        constraints.anchor = 17;
        return constraints;
    }

    private void createMenuBar() {
        JMenuBar menubar = new JMenuBar();
        this.m_frame.setJMenuBar(menubar);
        JMenu fileMenu = new JMenu(Messages.FileMenu);
        JMenuItem exitMenu = new JMenuItem(Messages.CloseMenu);
        exitMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ObjectMappingFrame.this.m_frame.dispose();
            }
        });
        JMenuItem settingsMenu = new JMenuItem(Messages.SettingsMenu);
        settingsMenu.addActionListener(new ActionListener(){
            private JFrame m_settings = new ObjectMappingSettingsFrame();

            @Override
            public void actionPerformed(ActionEvent e) {
                this.m_settings = new ObjectMappingSettingsFrame();
                this.m_settings.setVisible(true);
                this.m_settings.toFront();
            }
        });
        fileMenu.add(settingsMenu);
        fileMenu.add(exitMenu);
        menubar.add(fileMenu);
    }

    public void update(int event, Object obj) {
        if (event == 2) {
            IComponentIdentifier[] identifier = (IComponentIdentifier[])obj;
            if (identifier.length > 0 && identifier[0] instanceof ComponentIdentifier) {
                ComponentIdentifier id = (ComponentIdentifier)identifier[0];
                this.m_componentName.setText(identifier[0].getComponentName());
                this.m_componentClass.setText(identifier[0].getSupportedClassName());
                try {
                    this.m_componentIdentfier.setText(SerilizationUtils.encode((Serializable)id));
                }
                catch (IOException e) {
                    LOG.error("error occured during generation of Identifier", (Throwable)e);
                    this.m_componentIdentfier.setText("error generating Identifier please see logs");
                }
            }
            if (!this.m_frame.isVisible()) {
                this.m_frame.setVisible(true);
            }
        }
    }

    class AskBeforeCloseWindowListener
    extends WindowAdapter {
        AskBeforeCloseWindowListener() {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            int result = JOptionPane.showConfirmDialog(ObjectMappingFrame.this.m_frame, Messages.CloseWindowQuestion, Messages.CloseWindowTitle, 0);
            if (result == 0) {
                ObjectMappingFrame.this.m_frame.dispose();
                AutIdentifier identifier = DesktopIntegration.getObjectMappingAUT();
                if (identifier != null) {
                    StopOMActionListener stopOM = new StopOMActionListener(identifier);
                    stopOM.actionPerformed(null);
                }
            }
        }
    }
}

