/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.views.dataset;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.editors.CentralTestDataEditor;
import org.eclipse.jubula.client.ui.rcp.editors.IJBEditor;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.rcp.views.AbstractJBTreeView;
import org.eclipse.jubula.client.ui.rcp.views.CompNamesView;
import org.eclipse.jubula.client.ui.rcp.views.dataset.AbstractDataSetPage;
import org.eclipse.jubula.client.ui.rcp.views.dataset.ParamNodeDataSetPage;
import org.eclipse.jubula.client.ui.rcp.views.dataset.TestDataCubeDataSetPage;
import org.eclipse.jubula.client.ui.views.IJBPart;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.IContributedContentsView;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.IPageBookViewPage;
import org.eclipse.ui.part.MessagePage;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.part.PageBookView;
import org.eclipse.ui.views.properties.PropertySheet;

public class DataSetView
extends PageBookView
implements DataEventDispatcher.IProjectLoadedListener,
DataEventDispatcher.IParamChangedListener,
IContributedContentsView,
ISelectionListener {
    protected IPage createDefaultPage(PageBook book) {
        MessagePage page = new MessagePage();
        this.initPage((IPageBookViewPage)page);
        page.createControl((Composite)book);
        page.setMessage(Messages.DataSetViewNoDataSetInfo);
        return page;
    }

    protected PageBookView.PageRec doCreatePage(IWorkbenchPart part) {
        if (part instanceof AbstractJBTreeView || part.getAdapter(IJBEditor.class) != null) {
            AbstractDataSetPage page = part instanceof CentralTestDataEditor ? new TestDataCubeDataSetPage() : new ParamNodeDataSetPage();
            this.initPage((IPageBookViewPage)page);
            page.createControl((Composite)this.getPageBook());
            DataEventDispatcher.getInstance().addDataChangedListener((DataEventDispatcher.IDataChangedListener)page, true);
            return new PageBookView.PageRec(part, (IPage)page);
        }
        if (part instanceof IJBPart) {
            return new PageBookView.PageRec(part, this.createDefaultPage(this.getPageBook()));
        }
        return null;
    }

    protected void doDestroyPage(IWorkbenchPart part, PageBookView.PageRec pageRecord) {
        if (pageRecord.page instanceof DataEventDispatcher.IDataChangedListener) {
            DataEventDispatcher.getInstance().removeDataChangedListener((DataEventDispatcher.IDataChangedListener)pageRecord.page);
        }
        pageRecord.page.dispose();
        pageRecord.dispose();
    }

    protected IWorkbenchPart getBootstrapPart() {
        IWorkbenchPage page = this.getSite().getPage();
        if (page != null) {
            return page.getActivePart();
        }
        return null;
    }

    protected boolean isImportant(IWorkbenchPart part) {
        return part != this && !(part instanceof CompNamesView) && !(part instanceof PropertySheet);
    }

    public IWorkbenchPart getContributingPart() {
        return this.getCurrentContributingPart();
    }

    public void init(IViewSite site) throws PartInitException {
        site.getPage().addSelectionListener((ISelectionListener)this);
        DataEventDispatcher ded = DataEventDispatcher.getInstance();
        ded.addParamChangedListener((DataEventDispatcher.IParamChangedListener)this, true);
        ded.addProjectLoadedListener((DataEventDispatcher.IProjectLoadedListener)this, true);
        super.init(site);
    }

    public void dispose() {
        DataEventDispatcher dispatcher = DataEventDispatcher.getInstance();
        dispatcher.removeParamChangedListener((DataEventDispatcher.IParamChangedListener)this);
        dispatcher.removeProjectLoadedListener((DataEventDispatcher.IProjectLoadedListener)this);
        super.dispose();
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (!this.isImportant(part) || selection == null) {
            return;
        }
        IPage currentPage = this.getCurrentPage();
        if (currentPage instanceof ISelectionListener) {
            ((ISelectionListener)currentPage).selectionChanged(part, selection);
        }
    }

    public Object getAdapter(Class adapter) {
        if (((Object)((Object)this)).getClass().equals(adapter)) {
            return this;
        }
        return super.getAdapter(adapter);
    }

    public Composite getParentComposite() {
        return (Composite)this.getCurrentPage().getControl();
    }

    public void handleParamChanged(Object caller) {
        if (this.getCurrentPage() instanceof DataEventDispatcher.IParamChangedListener) {
            ((DataEventDispatcher.IParamChangedListener)this.getCurrentPage()).handleParamChanged(caller);
        }
    }

    public void handleProjectLoaded() {
        IPage curPage = this.getCurrentPage();
        if (curPage instanceof DataEventDispatcher.IProjectLoadedListener) {
            ((DataEventDispatcher.IProjectLoadedListener)curPage).handleProjectLoaded();
        }
    }

    public void setFocus() {
        Plugin.showStatusLine((IWorkbenchPart)this);
        super.setFocus();
    }
}

