/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.project.model;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Logger;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;
import org.eclipse.tracecompass.common.core.log.TraceCompassLog;
import org.eclipse.tracecompass.internal.tmf.ui.Activator;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfTraceException;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestampFormat;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.ui.project.model.ITmfProjectModelElement;
import org.eclipse.tracecompass.tmf.ui.project.model.ITmfStyledProjectModelElement;
import org.eclipse.tracecompass.tmf.ui.project.model.Messages;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTraceElement;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.ui.navigator.ICommonLabelProvider;

public class TmfNavigatorLabelProvider
implements ICommonLabelProvider,
DelegatingStyledCellLabelProvider.IStyledLabelProvider {
    private static final Logger LOGGER = TraceCompassLog.getLogger(TmfNavigatorLabelProvider.class);
    private static final String BOUNDS_FILE_NAME = "bounds";
    private static Queue<TmfTraceElement> boundsToUpdate = new ConcurrentLinkedQueue<TmfTraceElement>();
    private static Job updateBounds = new Job(Messages.TmfNavigatorLabelProvider_UpdateBoundsJobName){

        protected IStatus run(IProgressMonitor monitor) {
            while (!boundsToUpdate.isEmpty()) {
                TmfTraceElement tElement = (TmfTraceElement)boundsToUpdate.poll();
                ITmfTimestamp start = tElement.getStartTime();
                ITmfTimestamp end = tElement.getEndTime();
                if (start != null && end != null) continue;
                IFolder folder = tElement.getTraceSupplementaryFolder(tElement.getSupplementaryFolderPath());
                tElement.refreshSupplementaryFolder();
                File f = folder.getFile(TmfNavigatorLabelProvider.BOUNDS_FILE_NAME).getLocation().toFile();
                this.tryReadBoundsFile(tElement, f);
                start = tElement.getStartTime();
                end = tElement.getEndTime();
                if (start != null && end != null) continue;
                this.extractBoundsFromTrace(tElement);
                this.tryWriteBoundsFile(monitor, tElement, folder, f);
            }
            return Status.OK_STATUS;
        }

        private void extractBoundsFromTrace(TmfTraceElement traceElement) {
            block12: {
                boolean wasInitBefore;
                ITmfTrace trace = traceElement.getTrace();
                boolean bl = wasInitBefore = trace != null;
                if (!wasInitBefore) {
                    trace = traceElement.instantiateTrace();
                }
                if (trace == null) {
                    traceElement.setStartTime(TmfTimestamp.BIG_BANG);
                    traceElement.setEndTime(TmfTimestamp.BIG_BANG);
                } else {
                    try {
                        try {
                            ITmfTimestamp start;
                            if (!wasInitBefore) {
                                trace.initTrace(traceElement.getResource(), traceElement.getResource().getLocation().toOSString(), traceElement.instantiateEvent().getClass(), traceElement.getElementPath(), traceElement.getTraceType());
                            }
                            if ((start = trace.readStart()) != null) {
                                traceElement.setStartTime(start);
                                traceElement.refresh();
                                ITmfTimestamp end = trace.readEnd();
                                traceElement.setEndTime(end != null ? end : TmfTimestamp.BIG_BANG);
                                break block12;
                            }
                            traceElement.setStartTime(TmfTimestamp.BIG_BANG);
                            traceElement.setEndTime(TmfTimestamp.BIG_BANG);
                        }
                        catch (TmfTraceException e1) {
                            traceElement.setStartTime(TmfTimestamp.BIG_BANG);
                            traceElement.setEndTime(TmfTimestamp.BIG_BANG);
                            LOGGER.config("Failed to read time bounds from trace: " + traceElement.getName());
                            if (!wasInitBefore) {
                                trace.dispose();
                            }
                        }
                    }
                    finally {
                        if (!wasInitBefore) {
                            trace.dispose();
                        }
                    }
                }
            }
        }

        private void tryWriteBoundsFile(IProgressMonitor monitor, TmfTraceElement traceElement, IFolder folder, File boundsFile) {
            try {
                boundsFile.createNewFile();
                ByteBuffer writeBuffer = ByteBuffer.allocate(16);
                long writeStart = traceElement.getStartTime() != null ? traceElement.getStartTime().toNanos() : Long.MIN_VALUE;
                long writeEnd = traceElement.getEndTime() != null ? traceElement.getEndTime().toNanos() : Long.MIN_VALUE;
                writeBuffer.putLong(writeStart);
                writeBuffer.putLong(writeEnd);
                Files.write(boundsFile.toPath(), writeBuffer.array(), StandardOpenOption.WRITE);
                folder.refreshLocal(2, monitor);
            }
            catch (IOException e) {
                LOGGER.config("Failed to write time bounds supplementary file for trace: " + traceElement.getName());
            }
            catch (CoreException e) {
                LOGGER.config("Failed to refresh supplementary files for trace: " + traceElement.getName());
            }
        }

        private void tryReadBoundsFile(TmfTraceElement traceElement, File boundsFile) {
            if (boundsFile.exists()) {
                try {
                    byte[] bytes = Files.readAllBytes(boundsFile.toPath());
                    ByteBuffer readBuffer = ByteBuffer.allocate(16);
                    readBuffer.put(bytes);
                    readBuffer.flip();
                    long tmp = readBuffer.getLong();
                    if (tmp == Long.MIN_VALUE) {
                        traceElement.setStartTime(TmfTimestamp.BIG_BANG);
                    } else {
                        traceElement.setStartTime(TmfTimestamp.fromNanos((long)tmp));
                    }
                    tmp = readBuffer.getLong();
                    if (tmp == Long.MIN_VALUE) {
                        traceElement.setEndTime(TmfTimestamp.BIG_BANG);
                    } else {
                        traceElement.setEndTime(TmfTimestamp.fromNanos((long)tmp));
                    }
                    traceElement.refresh();
                }
                catch (IOException e) {
                    boundsFile.delete();
                    LOGGER.config("Failed to read time bounds supplementary file for trace: " + traceElement.getName());
                }
            }
        }
    };

    public Image getImage(Object element) {
        if (element instanceof ITmfProjectModelElement) {
            return ((ITmfProjectModelElement)element).getIcon();
        }
        return null;
    }

    public String getText(Object element) {
        if (element instanceof ITmfProjectModelElement) {
            return ((ITmfProjectModelElement)element).getLabelText();
        }
        return null;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public void restoreState(IMemento aMemento) {
    }

    public void saveState(IMemento aMemento) {
    }

    public String getDescription(Object anElement) {
        return this.getText(anElement);
    }

    public void init(ICommonContentExtensionSite aConfig) {
    }

    public StyledString getStyledText(Object element) {
        String text = this.getText(element);
        StyledString styledString = null;
        if (text != null) {
            boolean displayTimeRange;
            StyledString.Styler styler;
            if (element instanceof ITmfStyledProjectModelElement && (styler = ((ITmfStyledProjectModelElement)element).getStyler()) != null) {
                styledString = new StyledString(text, styler);
            }
            if (styledString == null) {
                styledString = new StyledString(text);
            }
            if ((displayTimeRange = Activator.getDefault().getPreferenceStore().getBoolean("EXPLORER_TIMERANGE")) && element instanceof TmfTraceElement) {
                styledString.append(TmfNavigatorLabelProvider.formatTraceRange(((TmfTraceElement)element).getElementUnderTraceFolder()));
            }
        }
        return styledString;
    }

    private static StyledString formatTraceRange(TmfTraceElement traceElement) {
        ITmfTimestamp start = traceElement.getStartTime();
        ITmfTimestamp end = traceElement.getEndTime();
        if (start == null) {
            boundsToUpdate.add(traceElement);
            if (updateBounds.getState() != 4) {
                updateBounds.schedule();
            }
            return new StyledString(" [...]", StyledString.DECORATIONS_STYLER);
        }
        if (start.equals(TmfTimestamp.BIG_BANG)) {
            return new StyledString();
        }
        if (end == null || end.equals(TmfTimestamp.BIG_BANG)) {
            return new StyledString(" [" + TmfTimestampFormat.getDefaulTimeFormat().format(start.toNanos()) + " - ...]", StyledString.DECORATIONS_STYLER);
        }
        return new StyledString(" [" + TmfTimestampFormat.getDefaulTimeFormat().format(start.toNanos()) + " - " + TmfTimestampFormat.getDefaulTimeFormat().format(end.toNanos()) + "]", StyledString.DECORATIONS_STYLER);
    }
}

