/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.views.filter;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.internal.tmf.ui.Activator;
import org.eclipse.tracecompass.tmf.core.filter.model.ITmfFilterTreeNode;
import org.eclipse.tracecompass.tmf.core.filter.model.TmfFilterRootNode;
import org.eclipse.tracecompass.tmf.core.filter.xml.TmfFilterXMLParser;
import org.eclipse.tracecompass.tmf.core.filter.xml.TmfFilterXMLWriter;
import org.xml.sax.SAXException;

public class FilterManager {
    private static final String SAVED_FILTERS_FILE_NAME = "saved_filters.xml";
    private static final String SAVED_FILTERS_PATH_NAME = Activator.getDefault().getStateLocation().addTrailingSeparator().append("saved_filters.xml").toString();
    private static final IPath SAVED_FILTERS_FILE_NAME_LEGACY = Activator.getDefault().getStateLocation().removeLastSegments(1).append("org.eclipse.linuxtools.tmf.ui").append("saved_filters.xml");
    private static ITmfFilterTreeNode fRoot = new TmfFilterRootNode();

    static {
        File defaultFile = new File(SAVED_FILTERS_PATH_NAME);
        try {
            File legacyFileCore;
            if (!defaultFile.exists() && (legacyFileCore = SAVED_FILTERS_FILE_NAME_LEGACY.toFile()).exists()) {
                ITmfFilterTreeNode root = new TmfFilterXMLParser(SAVED_FILTERS_FILE_NAME_LEGACY.toString()).getTree();
                FilterManager.setSavedFilters(root.getChildren());
            }
        }
        catch (FileNotFoundException legacyFileCore) {
        }
        catch (SAXException e) {
            Activator.getDefault().logError("Error parsing saved filter xml file: " + SAVED_FILTERS_FILE_NAME_LEGACY, e);
        }
        catch (IOException e) {
            Activator.getDefault().logError("Error parsing saved filter xml file: " + SAVED_FILTERS_FILE_NAME_LEGACY, e);
        }
        try {
            fRoot = new TmfFilterXMLParser(SAVED_FILTERS_PATH_NAME).getTree();
        }
        catch (FileNotFoundException e) {
        }
        catch (SAXException e) {
            Activator.getDefault().logError("Error parsing saved filter xml file: " + SAVED_FILTERS_PATH_NAME, e);
        }
        catch (IOException e) {
            Activator.getDefault().logError("Error parsing saved filter xml file: " + SAVED_FILTERS_PATH_NAME, e);
        }
    }

    public static @NonNull ITmfFilterTreeNode[] getSavedFilters() {
        return fRoot.clone().getChildren();
    }

    public static void setSavedFilters(ITmfFilterTreeNode[] filters) {
        fRoot = new TmfFilterRootNode();
        ITmfFilterTreeNode[] iTmfFilterTreeNodeArray = filters;
        int n = filters.length;
        int n2 = 0;
        while (n2 < n) {
            ITmfFilterTreeNode filter = iTmfFilterTreeNodeArray[n2];
            fRoot.addChild(filter.clone());
            ++n2;
        }
        try {
            TmfFilterXMLWriter writerXML = new TmfFilterXMLWriter(fRoot);
            writerXML.saveTree(SAVED_FILTERS_PATH_NAME);
        }
        catch (ParserConfigurationException e) {
            Activator.getDefault().logError("Error saving filter xml file: " + SAVED_FILTERS_PATH_NAME, e);
        }
    }
}

