/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.buildconsole;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.eclipse.cdt.core.ProblemMarkerInfo;
import org.eclipse.cdt.core.resources.IConsole;
import org.eclipse.cdt.internal.ui.buildconsole.BuildConsole;
import org.eclipse.cdt.internal.ui.buildconsole.BuildConsolePartition;
import org.eclipse.cdt.internal.ui.buildconsole.BuildConsolePartitioner;
import org.eclipse.cdt.internal.ui.buildconsole.BuildConsoleViewer;
import org.eclipse.cdt.internal.ui.buildconsole.ConsoleMessages;
import org.eclipse.cdt.internal.ui.buildconsole.CopyBuildLogAction;
import org.eclipse.cdt.internal.ui.buildconsole.GlobalBuildConsole;
import org.eclipse.cdt.internal.ui.buildconsole.IBuildConsoleStreamDecorator;
import org.eclipse.cdt.internal.ui.buildconsole.NextErrorAction;
import org.eclipse.cdt.internal.ui.buildconsole.PreviousErrorAction;
import org.eclipse.cdt.internal.ui.buildconsole.ScrollLockAction;
import org.eclipse.cdt.internal.ui.buildconsole.ShowErrorAction;
import org.eclipse.cdt.internal.ui.buildconsole.WrapLinesAction;
import org.eclipse.cdt.internal.ui.preferences.BuildConsolePreferencePage;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.IBuildConsoleEvent;
import org.eclipse.cdt.ui.IBuildConsoleListener;
import org.eclipse.cdt.ui.IBuildConsoleManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IFindReplaceTarget;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.console.IConsoleConstants;
import org.eclipse.ui.console.IConsoleView;
import org.eclipse.ui.console.actions.ClearOutputAction;
import org.eclipse.ui.console.actions.TextViewerAction;
import org.eclipse.ui.console.actions.TextViewerGotoLineAction;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.ide.ResourceUtil;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.texteditor.FindReplaceAction;
import org.eclipse.ui.texteditor.IUpdate;

public class BuildConsolePage
extends Page
implements ISelectionListener,
IPropertyChangeListener,
IBuildConsoleListener,
ITextListener,
IAdaptable {
    static final int POSITION_NEXT = -1;
    static final int POSITION_PREV = -2;
    static final int POSITION_FIST = -3;
    private BuildConsole fConsole;
    private IConsoleView fConsoleView;
    private String fContextMenuId;
    private BuildConsoleViewer fViewer;
    private IProject fProject;
    private ISelectionChangedListener fTextListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            BuildConsolePage.this.updateSelectionDependentActions();
        }
    };
    private ClearOutputAction fClearOutputAction;
    private Map<String, IAction> fGlobalActions = new HashMap<String, IAction>(10);
    private List<String> fSelectionActions = new ArrayList<String>(3);
    private CopyBuildLogAction fSaveLogAction;
    private Menu fMenu;
    private ScrollLockAction fScrollLockAction;
    private boolean fIsLocked;
    private NextErrorAction fNextErrorAction;
    private PreviousErrorAction fPreviousErrorAction;
    private ShowErrorAction fShowErrorAction;
    private WrapLinesAction fWrapAction;

    public BuildConsolePage(IConsoleView view, BuildConsole console, String contextId) {
        this.fConsole = console;
        this.fConsoleView = view;
        this.fContextMenuId = contextId;
    }

    protected void setProject(IProject project) {
        if (this.fProject != project && project.isAccessible()) {
            this.fProject = project;
        }
    }

    protected IProject getProject() {
        return this.fProject;
    }

    protected BuildConsole getConsole() {
        return this.fConsole;
    }

    protected IDocument setDocument() {
        IProject project = this.getProject();
        if (project != null) {
            IBuildConsoleManager consoleManager = this.getConsole().getConsoleManager();
            IDocument document = consoleManager.getConsoleDocument(project);
            IConsole console = consoleManager.getProjectConsole(project);
            this.getViewer().setDocument(document);
            if (console instanceof BuildConsolePartitioner) {
                BuildConsolePartitioner par = (BuildConsolePartitioner)console;
                this.showError(par, this.fShowErrorAction.isChecked() && !(this.getConsole() instanceof GlobalBuildConsole));
            }
        }
        return null;
    }

    @Override
    public void consoleChange(final IBuildConsoleEvent event) {
        Control control;
        if (!(event.getType() != 1 && event.getType() != 2 || (control = this.getControl()) == null || control.isDisposed())) {
            Display display = control.getDisplay();
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (BuildConsolePage.this.isAvailable()) {
                        if (event.getType() == 2 && BuildConsolePage.this.getProject() != event.getProject()) {
                            return;
                        }
                        BuildConsolePage.this.setProject(event.getProject());
                        if (BuildConsolePage.this.isAvailable()) {
                            BuildConsolePage.this.setDocument();
                            BuildConsolePage.this.getConsole().setTitle(BuildConsolePage.this.getProject());
                        }
                    }
                }
            });
        }
    }

    boolean isAvailable() {
        return this.getControl() != null;
    }

    public void createControl(Composite parent) {
        this.fViewer = new BuildConsoleViewer(parent);
        MenuManager manager = new MenuManager("#MessageConsole", "#MessageConsole");
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager m) {
                BuildConsolePage.this.contextMenuAboutToShow(m);
            }
        });
        this.fMenu = manager.createContextMenu(this.getControl());
        this.getControl().setMenu(this.fMenu);
        IPageSite site = this.getSite();
        site.registerContextMenu(this.fContextMenuId, manager, (ISelectionProvider)this.getViewer());
        site.setSelectionProvider((ISelectionProvider)this.getViewer());
        this.createActions();
        this.configureToolBar(site.getActionBars().getToolBarManager());
        this.fViewer.getSelectionProvider().addSelectionChangedListener(this.fTextListener);
        JFaceResources.getFontRegistry().addListener((IPropertyChangeListener)this);
        this.setFont(JFaceResources.getFont((String)"org.eclipse.cdt.ui.buildconsole.ConsoleFont"));
        this.setTabs(CUIPlugin.getDefault().getPreferenceStore().getInt("buildConsoleTabWith"));
        this.getConsole().addPropertyChangeListener(this);
        CUIPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        this.fViewer.addTextListener(this);
        this.fViewer.getTextWidget().setBackground(this.getConsole().getBackground());
        this.setInitialSelection();
    }

    protected void contextMenuAboutToShow(IMenuManager menu) {
        menu.add(this.fGlobalActions.get(ActionFactory.COPY.getId()));
        menu.add(this.fGlobalActions.get(ActionFactory.SELECT_ALL.getId()));
        menu.add((IContributionItem)new Separator("FIND"));
        menu.add(this.fGlobalActions.get(ActionFactory.FIND.getId()));
        menu.add(this.fGlobalActions.get("GotoLine"));
        menu.add((IAction)this.fClearOutputAction);
        menu.add((IContributionItem)new Separator("additions"));
    }

    public void propertyChange(PropertyChangeEvent event) {
        Object source = event.getSource();
        String property = event.getProperty();
        if ("org.eclipse.cdt.ui.CONSOLE_P_STREAM_COLOR".equals(property) && source instanceof IBuildConsoleStreamDecorator) {
            IBuildConsoleStreamDecorator stream = (IBuildConsoleStreamDecorator)source;
            if (stream.getConsole().equals((Object)this.getConsole()) && this.getControl() != null) {
                Display display = this.getControl().getDisplay();
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        BuildConsolePage.this.getViewer().getTextWidget().redraw();
                    }
                });
            }
        } else if (property.equals("org.eclipse.cdt.ui.buildconsole.ConsoleFont")) {
            this.setFont(JFaceResources.getFont((String)"org.eclipse.cdt.ui.buildconsole.ConsoleFont"));
        } else if (property.equals("buildConsoleTabWith")) {
            this.setTabs(CUIPlugin.getDefault().getPreferenceStore().getInt("buildConsoleTabWith"));
        } else if (IConsoleConstants.P_BACKGROUND_COLOR.equals(property)) {
            this.fViewer.getTextWidget().setBackground(this.fConsole.getBackground());
        } else if (property.equals("buildConsoleWrapLines")) {
            this.fWrapAction.setChecked(BuildConsolePreferencePage.isConsoleWrapLines());
        }
    }

    protected void createActions() {
        this.fClearOutputAction = new ClearOutputAction((ITextViewer)this.getViewer());
        this.fScrollLockAction = new ScrollLockAction(this.getViewer());
        this.fScrollLockAction.setChecked(this.fIsLocked);
        this.fWrapAction = new WrapLinesAction(this.getViewer());
        this.fNextErrorAction = new NextErrorAction(this);
        this.fPreviousErrorAction = new PreviousErrorAction(this);
        this.fShowErrorAction = new ShowErrorAction(this);
        this.fSaveLogAction = new CopyBuildLogAction(this);
        this.getViewer().setAutoScroll(!this.fIsLocked);
        IActionBars actionBars = this.getSite().getActionBars();
        TextViewerAction action = new TextViewerAction((ITextViewer)this.getViewer(), 4);
        action.configureAction(ConsoleMessages.BuildConsolePage__Copy_Ctrl_C_6, ConsoleMessages.BuildConsolePage_Copy_7, ConsoleMessages.BuildConsolePage_Copy_7);
        action.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_COPY"));
        action.setDisabledImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_COPY_DISABLED"));
        action.setHoverImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_COPY"));
        this.setGlobalAction(actionBars, ActionFactory.COPY.getId(), (IAction)action);
        action = new TextViewerAction((ITextViewer)this.getViewer(), 7);
        action.configureAction(ConsoleMessages.BuildConsolePage_Select__All_Ctrl_A_12, ConsoleMessages.BuildConsolePage_Select_All, ConsoleMessages.BuildConsolePage_Select_All);
        this.setGlobalAction(actionBars, ActionFactory.SELECT_ALL.getId(), (IAction)action);
        ResourceBundle bundle = ResourceBundle.getBundle("org.eclipse.cdt.internal.ui.buildconsole.ConsoleMessages");
        this.setGlobalAction(actionBars, ActionFactory.FIND.getId(), (IAction)new FindReplaceAction(bundle, "find_replace_action_", (IWorkbenchPart)this.getConsoleView()));
        action = new TextViewerGotoLineAction((ITextViewer)this.getViewer());
        this.setGlobalAction(actionBars, "GotoLine", (IAction)action);
        actionBars.updateActionBars();
        this.fSelectionActions.add(ActionFactory.COPY.getId());
        this.fSelectionActions.add(ActionFactory.FIND.getId());
    }

    protected void updateSelectionDependentActions() {
        Iterator<String> iterator = this.fSelectionActions.iterator();
        while (iterator.hasNext()) {
            this.updateAction(iterator.next());
        }
    }

    protected void updateAction(String actionId) {
        IAction action = this.fGlobalActions.get(actionId);
        if (action instanceof IUpdate) {
            ((IUpdate)action).update();
        }
    }

    protected void setGlobalAction(IActionBars actionBars, String actionID, IAction action) {
        this.fGlobalActions.put(actionID, action);
        actionBars.setGlobalActionHandler(actionID, action);
    }

    protected void configureToolBar(IToolBarManager mgr) {
        mgr.insertBefore("outputGroup", (IContributionItem)new GroupMarker("errorGroup"));
        mgr.appendToGroup("errorGroup", (IAction)this.fNextErrorAction);
        mgr.appendToGroup("errorGroup", (IAction)this.fPreviousErrorAction);
        mgr.appendToGroup("errorGroup", (IAction)this.fShowErrorAction);
        mgr.appendToGroup("outputGroup", (IAction)this.fSaveLogAction);
        mgr.appendToGroup("outputGroup", (IAction)this.fScrollLockAction);
        mgr.appendToGroup("outputGroup", (IAction)this.fWrapAction);
        mgr.appendToGroup("outputGroup", (IAction)this.fClearOutputAction);
    }

    protected BuildConsoleViewer getViewer() {
        return this.fViewer;
    }

    protected IConsoleView getConsoleView() {
        return this.fConsoleView;
    }

    public void dispose() {
        this.getSite().getPage().removeSelectionListener((ISelectionListener)this);
        this.getConsole().getConsoleManager().removeConsoleListener(this);
        this.fViewer.removeTextListener(this);
        super.dispose();
    }

    public void init(IPageSite pageSite) {
        super.init(pageSite);
        this.getSite().getPage().addSelectionListener((ISelectionListener)this);
        this.getConsole().getConsoleManager().addConsoleListener(this);
    }

    protected void setInitialSelection() {
        IWorkbenchPage page = this.getSite().getPage();
        ISelection selection = null;
        if (page != null) {
            selection = page.getSelection();
        }
        if (this.convertSelectionToProject(selection) == null) {
            IWorkbenchPart part;
            if (selection instanceof ITextSelection && (part = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart()) instanceof IEditorPart && this.setSelectionFromEditor((IEditorPart)part)) {
                return;
            }
            IProject project = this.getConsole().getConsoleManager().getLastBuiltProject();
            if (project != null) {
                selection = new StructuredSelection((Object)project);
            }
        }
        this.selectionChanged(null, selection);
    }

    boolean setSelectionFromEditor(IEditorPart part) {
        IEditorInput ei;
        if (part == null) {
            return false;
        }
        IWorkbenchPartSite site = part.getSite();
        if (site == null) {
            return false;
        }
        ISelectionProvider provider = site.getSelectionProvider();
        if (provider != null && (ei = part.getEditorInput()) instanceof IFileEditorInput) {
            IFile file = ((IFileEditorInput)ei).getFile();
            this.selectionChanged((IWorkbenchPart)part, (ISelection)new StructuredSelection((Object)file));
            return true;
        }
        return false;
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        IProject newProject = this.convertSelectionToProject(selection);
        IProject oldProject = this.getProject();
        if (oldProject == null || newProject != null && !newProject.equals((Object)oldProject)) {
            this.setProject(newProject);
            this.setDocument();
            this.getConsole().setTitle(this.getProject());
        }
    }

    IProject convertSelectionToProject(ISelection selection) {
        IProject project = null;
        if (selection == null || !(selection instanceof IStructuredSelection)) {
            return project;
        }
        IStructuredSelection ssel = (IStructuredSelection)selection;
        Object element = ssel.getFirstElement();
        if (element instanceof IAdaptable) {
            IAdaptable input = (IAdaptable)element;
            IResource resource = null;
            resource = input instanceof IResource ? (IResource)input : (IResource)input.getAdapter(IResource.class);
            if (resource != null) {
                project = resource.getProject();
            }
        }
        return project;
    }

    public Control getControl() {
        if (this.fViewer != null) {
            return this.fViewer.getControl();
        }
        return null;
    }

    public void setFocus() {
        Control control = this.getControl();
        if (control != null) {
            control.setFocus();
        }
        this.updateSelectionDependentActions();
    }

    protected void setFont(Font font) {
        this.getViewer().getTextWidget().setFont(font);
    }

    protected void setTabs(int tabs) {
        StyledText textWidget = this.getViewer().getTextWidget();
        if (textWidget != null) {
            textWidget.setTabs(tabs);
        }
    }

    protected void refresh() {
        this.getViewer().refresh();
    }

    public <T> T getAdapter(Class<T> required) {
        if (IFindReplaceTarget.class.equals(required)) {
            return (T)this.getViewer().getFindReplaceTarget();
        }
        if (Widget.class.equals(required)) {
            return (T)this.getViewer().getTextWidget();
        }
        return null;
    }

    public void textChanged(TextEvent event) {
        IUpdate findReplace = (IUpdate)this.fGlobalActions.get(ActionFactory.FIND.getId());
        if (findReplace != null) {
            findReplace.update();
        }
    }

    private IConsole getCurrentConsole() {
        IBuildConsoleManager consoleManager = this.fConsole.getConsoleManager();
        return consoleManager.getProjectConsole(this.getProject());
    }

    void moveToError(int position) {
        IConsole console = this.getCurrentConsole();
        if (console == null) {
            return;
        }
        if (console instanceof BuildConsolePartitioner) {
            BuildConsolePartitioner par = (BuildConsolePartitioner)console;
            if (position == -1) {
                par.fDocumentMarkerManager.moveToNextError();
            } else if (position == -2) {
                par.fDocumentMarkerManager.moveToPreviousError();
            } else if (position == -3) {
                par.fDocumentMarkerManager.moveToFirstError();
            } else if (position >= 0 && !par.fDocumentMarkerManager.moveToErrorByOffset(position)) {
                return;
            }
            this.showError(par, position > 0 || this.fShowErrorAction.isChecked());
        }
    }

    public void showError(BuildConsolePartitioner par, boolean openInEditor) {
        BuildConsolePartition p = par.fDocumentMarkerManager.getCurrentPartition();
        if (p == null) {
            return;
        }
        this.getViewer().selectPartition(par, p);
        if (openInEditor) {
            BuildConsolePage.openErrorInEditor(par.fDocumentMarkerManager.getCurrentErrorMarker());
        }
    }

    public static void openErrorInEditor(ProblemMarkerInfo marker) {
        IEditorInput input;
        IFile file;
        IWorkbenchWindow window = CUIPlugin.getActiveWorkbenchWindow();
        if (marker == null || marker.file == null || window == null) {
            return;
        }
        IWorkbenchPage page = window.getActivePage();
        if (page == null) {
            return;
        }
        IEditorPart editor = page.getActiveEditor();
        if (editor != null && (file = ResourceUtil.getFile((IEditorInput)(input = editor.getEditorInput()))) != null && file.equals((Object)marker.file) && OpenStrategy.activateOnOpen()) {
            page.activate((IWorkbenchPart)editor);
        }
        if (marker.file instanceof IFile) {
            try {
                IMarker[] mrkrs;
                IMarker[] iMarkerArray = mrkrs = marker.file.findMarkers("org.eclipse.cdt.core.problem", true, 1);
                int n = mrkrs.length;
                int n2 = 0;
                while (n2 < n) {
                    IMarker m = iMarkerArray[n2];
                    if (marker.lineNumber == (Integer)m.getAttribute("lineNumber") && marker.description.equals(m.getAttribute("message")) && marker.severity == (Integer)m.getAttribute("severity")) {
                        IDE.openEditor((IWorkbenchPage)page, (IMarker)m, (boolean)OpenStrategy.activateOnOpen());
                        return;
                    }
                    ++n2;
                }
            }
            catch (PartInitException e) {
                CUIPlugin.log(e);
            }
            catch (CoreException e) {
                CUIPlugin.log(e);
            }
        }
    }
}

