/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.os.linux.ui.views.io.diskioactivity;

import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.tracecompass.analysis.os.linux.core.inputoutput.Disk;
import org.eclipse.tracecompass.analysis.os.linux.core.inputoutput.InputOutputAnalysisModule;
import org.eclipse.tracecompass.analysis.os.linux.core.inputoutput.InputOutputInformationProvider;
import org.eclipse.tracecompass.analysis.os.linux.core.inputoutput.IoOperationType;
import org.eclipse.tracecompass.common.core.format.DataSpeedWithUnitFormat;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.views.io.diskioactivity.Messages;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.exceptions.TimeRangeException;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;
import org.eclipse.tracecompass.tmf.ui.viewers.xycharts.linecharts.TmfCommonXLineChartViewer;
import org.swtchart.Chart;

public class DisksIOActivityViewer
extends TmfCommonXLineChartViewer {
    private static final long BUILD_UPDATE_TIMEOUT = 500L;
    private static final double RESOLUTION = 0.2;
    private static final int BYTES_PER_SECTOR = 512;
    private static final int SECOND_TO_NANOSECOND = (int)Math.pow(10.0, 9.0);
    private @Nullable InputOutputAnalysisModule fModule = null;

    public DisksIOActivityViewer(@Nullable Composite parent) {
        super(parent, Messages.DiskIOActivityViewer_Title, Messages.DiskIOActivityViewer_XAxis, Messages.DiskIOActivityViewer_YAxis);
        this.setResolution(0.2);
        Chart chart = this.getSwtChart();
        chart.getAxisSet().getYAxis(0).getTick().setFormat(DataSpeedWithUnitFormat.getInstance());
        chart.getLegend().setPosition(16384);
    }

    protected void initializeDataSource() {
        ITmfTrace trace = this.getTrace();
        if (trace != null) {
            InputOutputAnalysisModule module = (InputOutputAnalysisModule)TmfTraceUtils.getAnalysisModuleOfClass((ITmfTrace)trace, InputOutputAnalysisModule.class, (String)"org.eclipse.tracecompass.analysis.os.linux.inputoutput");
            if (module == null) {
                return;
            }
            module.schedule();
            this.fModule = module;
        }
    }

    protected void updateData(long start, long end, int nb, @Nullable IProgressMonitor monitor) {
        InputOutputAnalysisModule module = this.fModule;
        if (this.getTrace() == null || module == null) {
            return;
        }
        if (!module.waitForInitialization()) {
            return;
        }
        ITmfStateSystem ss = module.getStateSystem();
        if (ss == null) {
            return;
        }
        double[] xvalues = DisksIOActivityViewer.getXAxis((long)start, (long)end, (int)nb);
        this.setXAxis(xvalues);
        boolean complete = false;
        long currentEnd = start;
        while (!complete && currentEnd < end) {
            if (monitor != null && monitor.isCanceled()) {
                return;
            }
            complete = ss.waitUntilBuilt(500L);
            currentEnd = ss.getCurrentEndTime();
            long traceStart = this.getStartTime();
            long traceEnd = this.getEndTime();
            long offset = this.getTimeOffset();
            Collection disks = InputOutputInformationProvider.getDisks((InputOutputAnalysisModule)module);
            for (Disk disk : disks) {
                if (!disk.hasActivity()) continue;
                String diskName = disk.getDiskName();
                double[] yValuesWritten = new double[xvalues.length];
                double[] yValuesRead = new double[xvalues.length];
                String seriesNameWritten = new String(String.valueOf(diskName) + Messages.DisksIOActivityViewer_Write);
                String seriesNameRead = new String(String.valueOf(diskName) + Messages.DisksIOActivityViewer_Read);
                double prevX = xvalues[0];
                long prevTime = (long)prevX + offset;
                prevTime = Math.max(traceStart, prevTime);
                prevTime = Math.min(traceEnd, prevTime);
                long prevCountRead = disk.getSectorsAt(prevTime, IoOperationType.READ);
                long prevCountWrite = disk.getSectorsAt(prevTime, IoOperationType.WRITE);
                int i = 1;
                while (i < xvalues.length) {
                    if (monitor != null && monitor.isCanceled()) {
                        return;
                    }
                    double x = xvalues[i];
                    long time = (long)x + offset;
                    time = Math.max(traceStart, time);
                    time = Math.min(traceEnd, time);
                    try {
                        long count = disk.getSectorsAt(time, IoOperationType.WRITE);
                        yValuesWritten[i] = (double)((count - prevCountWrite) * 512L) / ((double)(time - prevTime) / (double)SECOND_TO_NANOSECOND);
                        prevCountWrite = count;
                        count = disk.getSectorsAt(time, IoOperationType.READ);
                        yValuesRead[i] = (double)((count - prevCountRead) * 512L) / ((double)(time - prevTime) / (double)SECOND_TO_NANOSECOND);
                        prevCountRead = count;
                    }
                    catch (TimeRangeException e) {
                        yValuesWritten[i] = 0.0;
                        yValuesRead[i] = 0.0;
                    }
                    prevTime = time;
                    ++i;
                }
                this.setSeries(seriesNameRead, yValuesRead);
                this.setSeries(seriesNameWritten, yValuesWritten);
                if (monitor != null && monitor.isCanceled()) {
                    return;
                }
                this.updateDisplay();
            }
        }
    }
}

