/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.lttng2.ust.ui.views.memusage;

import java.lang.invoke.LambdaMetafactory;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.common.core.format.DataSizeWithUnitFormat;
import org.eclipse.tracecompass.internal.lttng2.ust.ui.Activator;
import org.eclipse.tracecompass.internal.lttng2.ust.ui.views.memusage.Messages;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateValueTypeException;
import org.eclipse.tracecompass.statesystem.core.exceptions.TimeRangeException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.tmf.core.statesystem.TmfStateSystemAnalysisModule;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;
import org.eclipse.tracecompass.tmf.ui.viewers.xycharts.linecharts.TmfCommonXLineChartViewer;
import org.swtchart.Chart;

public class MemoryUsageViewer
extends TmfCommonXLineChartViewer {
    private TmfStateSystemAnalysisModule fModule = null;
    private final Map<Integer, double[]> fYValues = new HashMap<Integer, double[]>();
    private final Map<Integer, Integer> fMemoryQuarks = new HashMap<Integer, Integer>();
    private final Map<Integer, String> fSeriesName = new HashMap<Integer, String>();
    private static final long BUILD_UPDATE_TIMEOUT = 500L;

    public MemoryUsageViewer(Composite parent) {
        super(parent, Messages.MemoryUsageViewer_Title, Messages.MemoryUsageViewer_XAxis, Messages.MemoryUsageViewer_YAxis);
        Chart chart = this.getSwtChart();
        chart.getLegend().setPosition(16384);
        chart.getAxisSet().getYAxis(0).getTick().setFormat(DataSizeWithUnitFormat.getInstance());
    }

    protected void initializeDataSource() {
        ITmfTrace trace = this.getTrace();
        if (trace != null) {
            this.fModule = (TmfStateSystemAnalysisModule)TmfTraceUtils.getAnalysisModuleOfClass((ITmfTrace)trace, TmfStateSystemAnalysisModule.class, (String)"org.eclipse.linuxtools.lttng2.ust.analysis.memory");
            if (this.fModule == null) {
                return;
            }
            this.fModule.schedule();
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void updateData(long start, long end, int nb, IProgressMonitor monitor) {
        try {
            if (this.getTrace() == null || this.fModule == null) {
                return;
            }
            if (!this.fModule.waitForInitialization()) {
                return;
            }
            ss = this.fModule.getStateSystem();
            if (ss == null) {
                return;
            }
            xvalues = MemoryUsageViewer.getXAxis((long)start, (long)end, (int)nb);
            this.setXAxis(xvalues);
            complete = false;
            currentEnd = Math.max(ss.getStartTime(), start);
            while (!complete && currentEnd < end) {
                if (monitor.isCanceled()) {
                    return;
                }
                complete = ss.waitUntilBuilt(500L);
                currentEnd = ss.getCurrentEndTime();
                tidQuarks = ss.getSubAttributes(-1, false);
                traceStart = Math.max(this.getStartTime(), ss.getStartTime());
                traceEnd = this.getEndTime();
                offset = this.getTimeOffset();
                queryStart = Math.max(ss.getStartTime(), start);
                fullState = Collections.emptyList();
                if (queryStart <= currentEnd) {
                    fullState = ss.queryFullState(queryStart);
                    var23_19 = tidQuarks.iterator();
                    while (var23_19.hasNext()) {
                        quark = (Integer)var23_19.next();
                        this.fYValues.put(quark, new double[xvalues.length]);
                        this.fMemoryQuarks.put(quark, ss.getQuarkRelative(quark, new String[]{"Memory"}));
                        procNameQuark = ss.getQuarkRelative(quark, new String[]{"Procname"});
                        oldSeriesName = this.fSeriesName.get(quark);
                        seriesName = null;
                        try {
                            procnameValue = ((ITmfStateInterval)fullState.get(procNameQuark)).getStateValue();
                            procname = "";
                            if (!procnameValue.isNull()) {
                                procname = procnameValue.unboxStr();
                            }
                            seriesName = (String.valueOf(procname) + ' ' + '(' + ss.getAttributeName(quark) + ')').trim();
                        }
                        catch (TimeRangeException e) {
                            seriesName = String.valueOf('(') + ss.getAttributeName(quark) + ')';
                        }
                        if (oldSeriesName != null && !oldSeriesName.equals(seriesName) && !(display = Display.getDefault()).isDisposed()) {
                            display.syncExec((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$0(java.lang.String ), ()V)((MemoryUsageViewer)this, (String)oldSeriesName));
                        }
                        this.fSeriesName.put(quark, seriesName);
                    }
                } else {
                    Display.getDefault().asyncExec((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$1(), ()V)((MemoryUsageViewer)this));
                    continue;
                }
                yvalue = 0.0;
                i = 0;
                while (i < xvalues.length) {
                    block22: {
                        if (monitor.isCanceled()) {
                            return;
                        }
                        x = xvalues[i];
                        time = (long)x + offset;
                        time = time < traceStart ? traceStart : time;
                        time = time > traceEnd ? traceEnd : time;
                        try {
                            fullState = ss.queryFullState(time);
                            var30_31 = tidQuarks.iterator();
                            while (var30_31.hasNext()) {
                                quark = (Integer)var30_31.next();
                                values = (double[])NonNullUtils.checkNotNull((Object)this.fYValues.get(quark));
                                memQuark = (Integer)NonNullUtils.checkNotNull((Object)this.fMemoryQuarks.get(quark));
                                values[i] = yvalue = (double)((ITmfStateInterval)fullState.get(memQuark)).getStateValue().unboxLong();
                            }
                            break block22;
                        }
                        catch (TimeRangeException e) {
                            var31_33 = tidQuarks.iterator();
                            ** while (var31_33.hasNext())
                        }
lbl-1000:
                        // 1 sources

                        {
                            quark = (Integer)var31_33.next();
                            values = (double[])NonNullUtils.checkNotNull((Object)this.fYValues.get(quark));
                            values[i] = 0.0;
                            continue;
                        }
                    }
                    ++i;
                }
                var25_21 = tidQuarks.iterator();
                while (var25_21.hasNext()) {
                    quark = (Integer)var25_21.next();
                    this.setSeries(this.fSeriesName.get(quark), this.fYValues.get(quark));
                }
                this.updateDisplay();
            }
        }
        catch (AttributeNotFoundException | StateValueTypeException e) {
            Activator.getDefault().logError("Error updating the data of the Memory usage view", e);
        }
        catch (StateSystemDisposedException var7_7) {
            // empty catch block
        }
    }

    private /* synthetic */ void lambda$0(String string) {
        this.deleteSeries(string);
    }

    private /* synthetic */ void lambda$1() {
        this.clearContent();
    }
}

