/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.asciidoc.internal.phrase;

import java.util.regex.Pattern;
import org.eclipse.mylyn.wikitext.parser.Attributes;
import org.eclipse.mylyn.wikitext.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.parser.markup.PatternBasedElement;
import org.eclipse.mylyn.wikitext.parser.markup.PatternBasedElementProcessor;

public class SimplePhraseModifier
extends PatternBasedElement {
    private final String delimiter;
    private final DocumentBuilder.SpanType spanType;
    private final boolean wordBoundary;

    public SimplePhraseModifier(String delimiter, DocumentBuilder.SpanType spanType) {
        this(delimiter, spanType, false);
    }

    public SimplePhraseModifier(String delimiter, DocumentBuilder.SpanType spanType, boolean wordBoundary) {
        this.delimiter = delimiter;
        this.spanType = spanType;
        this.wordBoundary = wordBoundary;
    }

    protected String getPattern(int groupOffset) {
        String pattern;
        String quotedDelimiter = Pattern.quote(this.delimiter);
        if (this.wordBoundary) {
            pattern = quotedDelimiter + "(?!" + quotedDelimiter + ") *(.+?) *" + quotedDelimiter + "(?!" + quotedDelimiter + ")";
            pattern = "(^|\\W)" + pattern + "($|\\W)";
        } else {
            pattern = quotedDelimiter + " *(.+?) *" + quotedDelimiter;
        }
        return pattern;
    }

    protected int getPatternGroupCount() {
        return this.wordBoundary ? 3 : 1;
    }

    protected PatternBasedElementProcessor newProcessor() {
        return new CodePhraseModifierProcessor();
    }

    private class CodePhraseModifierProcessor
    extends PatternBasedElementProcessor {
        private CodePhraseModifierProcessor() {
        }

        public int getLineStartOffset() {
            int value;
            if (SimplePhraseModifier.this.wordBoundary && (value = this.end(1)) >= 0) {
                return value;
            }
            return super.getLineStartOffset();
        }

        public int getLineEndOffset() {
            int value;
            if (SimplePhraseModifier.this.wordBoundary && (value = this.start(3)) >= 0) {
                return value;
            }
            return super.getLineEndOffset();
        }

        public void emit() {
            String content = this.group(SimplePhraseModifier.this.wordBoundary ? 2 : 1);
            this.getBuilder().beginSpan(SimplePhraseModifier.this.spanType, new Attributes());
            this.getMarkupLanguage().emitMarkupText(this.parser, this.state, content);
            this.getBuilder().endSpan();
        }
    }
}

