/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.changes;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.manipulation.util.BasicElementLabels;
import org.eclipse.jdt.internal.corext.refactoring.AbstractJavaElementRenameChange;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.ltk.core.refactoring.Change;

public final class RenameCompilationUnitChange
extends AbstractJavaElementRenameChange {
    public RenameCompilationUnitChange(ICompilationUnit unit, String newName) {
        this(unit.getResource().getFullPath(), unit.getElementName(), newName, -1L);
        Assert.isTrue((!unit.isReadOnly() ? 1 : 0) != 0, (String)"compilation unit must not be read-only");
    }

    private RenameCompilationUnitChange(IPath resourcePath, String oldName, String newName, long stampToRestore) {
        super(resourcePath, oldName, newName, stampToRestore);
        this.setValidationMethod(5);
    }

    @Override
    protected IPath createNewPath() {
        IPath path = this.getResourcePath();
        if (path.getFileExtension() != null) {
            return path.removeFileExtension().removeLastSegments(1).append(this.getNewName());
        }
        return path.removeLastSegments(1).append(this.getNewName());
    }

    @Override
    protected Change createUndoChange(long stampToRestore) throws JavaModelException {
        return new RenameCompilationUnitChange(this.createNewPath(), this.getNewName(), this.getOldName(), stampToRestore);
    }

    @Override
    protected void doRename(IProgressMonitor pm) throws CoreException {
        ICompilationUnit cu = (ICompilationUnit)this.getModifiedElement();
        if (cu != null) {
            cu.rename(this.getNewName(), false, pm);
        }
    }

    public String getName() {
        Object[] keys = new String[]{BasicElementLabels.getJavaElementName((String)this.getOldName()), BasicElementLabels.getJavaElementName((String)this.getNewName())};
        return Messages.format(RefactoringCoreMessages.RenameCompilationUnitChange_name, keys);
    }
}

