/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.chain.rcp;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jdt.internal.codeassist.InternalCompletionContext;
import org.eclipse.jdt.internal.codeassist.complete.CompletionOnMessageSend;
import org.eclipse.jdt.internal.codeassist.complete.CompletionOnQualifiedAllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.Assignment;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.LocalDeclaration;
import org.eclipse.jdt.internal.compiler.ast.MessageSend;
import org.eclipse.jdt.internal.compiler.ast.ReturnStatement;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.BaseTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.InvocationSite;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.util.ObjectVector;
import org.eclipse.recommenders.completion.rcp.IRecommendersCompletionContext;
import org.eclipse.recommenders.internal.chain.rcp.ChainElement;
import org.eclipse.recommenders.internal.chain.rcp.l10n.LogMessages;
import org.eclipse.recommenders.utils.Logs;
import org.eclipse.recommenders.utils.names.ITypeName;

public final class TypeBindingAnalyzer {
    private static final Predicate<FieldBinding> NON_STATIC_FIELDS_ONLY_FILTER = new Predicate<FieldBinding>(){

        public boolean apply(FieldBinding m) {
            return m.isStatic();
        }
    };
    private static final Predicate<MethodBinding> RELEVANT_NON_STATIC_METHODS_ONLY_FILTER = new Predicate<MethodBinding>(){

        public boolean apply(MethodBinding m) {
            return m.isStatic() || TypeBindingAnalyzer.isVoid(m) || m.isConstructor() || TypeBindingAnalyzer.hasPrimitiveReturnType(m);
        }
    };
    private static final Predicate<FieldBinding> STATIC_FIELDS_ONLY_FILTER = new Predicate<FieldBinding>(){

        public boolean apply(FieldBinding m) {
            return !m.isStatic();
        }
    };
    private static final Predicate<MethodBinding> STATIC_NON_VOID_NON_PRIMITIVE_METHODS_ONLY_FILTER = new Predicate<MethodBinding>(){

        public boolean apply(MethodBinding m) {
            return !m.isStatic() || TypeBindingAnalyzer.isVoid(m) || m.isConstructor() || TypeBindingAnalyzer.hasPrimitiveReturnType(m);
        }
    };

    private TypeBindingAnalyzer() {
    }

    static boolean isVoid(MethodBinding m) {
        return TypeBindingAnalyzer.hasPrimitiveReturnType(m) && m.returnType.constantPoolName()[0] == 'V';
    }

    static boolean hasPrimitiveReturnType(MethodBinding m) {
        return m.returnType.constantPoolName().length == 1;
    }

    public static Collection<Binding> findVisibleInstanceFieldsAndRelevantInstanceMethods(TypeBinding type, InvocationSite invocationSite, Scope scope) {
        return TypeBindingAnalyzer.findFieldsAndMethods(type, invocationSite, scope, NON_STATIC_FIELDS_ONLY_FILTER, RELEVANT_NON_STATIC_METHODS_ONLY_FILTER);
    }

    public static Collection<Binding> findAllPublicStaticFieldsAndNonVoidNonPrimitiveStaticMethods(TypeBinding type, InvocationSite invocationSite, Scope scope) {
        return TypeBindingAnalyzer.findFieldsAndMethods(type, invocationSite, scope, STATIC_FIELDS_ONLY_FILTER, STATIC_NON_VOID_NON_PRIMITIVE_METHODS_ONLY_FILTER);
    }

    private static Collection<Binding> findFieldsAndMethods(TypeBinding type, InvocationSite invocationSite, Scope scope, Predicate<FieldBinding> fieldFilter, Predicate<MethodBinding> methodFilter) {
        LinkedHashMap<String, MethodBinding> tmp = new LinkedHashMap<String, MethodBinding>();
        SourceTypeBinding receiverType = scope.classScope().referenceContext.binding;
        for (ReferenceBinding cur : TypeBindingAnalyzer.findAllSupertypesIncludeingArgument(type)) {
            String key;
            MethodBinding[] methodBindingArray = cur.methods();
            int n = methodBindingArray.length;
            int n2 = 0;
            while (n2 < n) {
                MethodBinding method = methodBindingArray[n2];
                if (!methodFilter.apply((Object)method) && method.canBeSeenBy(invocationSite, scope) && !tmp.containsKey(key = TypeBindingAnalyzer.createMethodKey(method))) {
                    tmp.put(key, method);
                }
                ++n2;
            }
            methodBindingArray = cur.fields();
            n = methodBindingArray.length;
            n2 = 0;
            while (n2 < n) {
                MethodBinding field = methodBindingArray[n2];
                if (!fieldFilter.apply((Object)field) && field.canBeSeenBy((TypeBinding)receiverType, invocationSite, scope) && !tmp.containsKey(key = TypeBindingAnalyzer.createFieldKey((FieldBinding)field))) {
                    tmp.put(key, field);
                }
                ++n2;
            }
        }
        return tmp.values();
    }

    private static List<ReferenceBinding> findAllSupertypesIncludeingArgument(TypeBinding type) {
        TypeBinding base = TypeBindingAnalyzer.removeArrayWrapper(type);
        if (!(base instanceof ReferenceBinding)) {
            return Collections.emptyList();
        }
        LinkedList<ReferenceBinding> supertypes = new LinkedList<ReferenceBinding>();
        LinkedList<ReferenceBinding> queue = new LinkedList<ReferenceBinding>();
        queue.add((ReferenceBinding)base);
        while (!queue.isEmpty()) {
            ReferenceBinding superType = (ReferenceBinding)queue.poll();
            if (superType == null || supertypes.contains(superType)) continue;
            supertypes.add(superType);
            queue.add(superType.superclass());
            ReferenceBinding[] referenceBindingArray = superType.superInterfaces();
            int n = referenceBindingArray.length;
            int n2 = 0;
            while (n2 < n) {
                ReferenceBinding interfc = referenceBindingArray[n2];
                queue.add(interfc);
                ++n2;
            }
        }
        return supertypes;
    }

    private static String createFieldKey(FieldBinding field) {
        return "" + field.name + field.type.signature();
    }

    private static String createMethodKey(MethodBinding method) {
        String signature = String.valueOf(method.signature());
        String signatureWithoutReturnType = StringUtils.substringBeforeLast((String)signature, (String)")");
        return method.readableName() + signatureWithoutReturnType;
    }

    public static boolean isAssignable(ChainElement edge, TypeBinding expectedType, int expectedDimension) {
        if (expectedDimension <= edge.getReturnTypeDimension()) {
            TypeBinding base = TypeBindingAnalyzer.removeArrayWrapper(edge.getReturnType());
            if (base instanceof BaseTypeBinding) {
                return false;
            }
            if (base.isCompatibleWith(expectedType)) {
                return true;
            }
            LinkedList<ReferenceBinding> supertypes = new LinkedList<ReferenceBinding>();
            supertypes.add((ReferenceBinding)base);
            String expectedSignature = String.valueOf(expectedType.signature());
            while (!supertypes.isEmpty()) {
                ReferenceBinding type = (ReferenceBinding)supertypes.poll();
                if (String.valueOf(type.signature()).equals(expectedSignature)) {
                    return true;
                }
                ReferenceBinding superclass = type.superclass();
                if (superclass != null) {
                    supertypes.add(superclass);
                }
                ReferenceBinding[] referenceBindingArray = type.superInterfaces();
                int n = referenceBindingArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ReferenceBinding intf = referenceBindingArray[n2];
                    supertypes.add(intf);
                    ++n2;
                }
            }
        }
        return false;
    }

    public static TypeBinding removeArrayWrapper(TypeBinding type) {
        TypeBinding base = type;
        while (base instanceof ArrayBinding) {
            base = ((ArrayBinding)base).elementsType();
        }
        return base;
    }

    public static List<Optional<TypeBinding>> resolveBindingsForExpectedTypes(IRecommendersCompletionContext ctx, Scope scope) {
        InternalCompletionContext context = (InternalCompletionContext)ctx.getJavaContext().getCoreContext();
        ASTNode parent = context.getCompletionNodeParent();
        LinkedList<Optional<TypeBinding>> bindings = new LinkedList<Optional<TypeBinding>>();
        if (parent instanceof LocalDeclaration) {
            bindings.add(Optional.fromNullable((Object)((LocalDeclaration)parent).type.resolvedType));
        } else if (parent instanceof ReturnStatement) {
            bindings.add(TypeBindingAnalyzer.resolveReturnStatement(context));
        } else if (parent instanceof FieldDeclaration) {
            bindings.add((Optional<TypeBinding>)Optional.fromNullable((Object)((FieldDeclaration)parent).type.resolvedType));
        } else if (parent instanceof Assignment) {
            bindings.add((Optional<TypeBinding>)Optional.fromNullable((Object)((Assignment)parent).resolvedType));
        } else if (TypeBindingAnalyzer.isCompletionOnMethodParameter(context)) {
            for (ITypeName type : ctx.getExpectedTypeNames()) {
                bindings.add((Optional<TypeBinding>)Optional.of((Object)scope.getType(type.getClassName().toCharArray())));
            }
        } else {
            Logs.log((Logs.ILogMessage)LogMessages.WARNING_CANNOT_USE_AS_PARENT_OF_COMPLETION_LOCATION, (Object[])new Object[]{parent.getClass()});
        }
        return bindings;
    }

    private static boolean isCompletionOnMethodParameter(InternalCompletionContext context) {
        return context.getCompletionNode() instanceof CompletionOnQualifiedAllocationExpression || context.getCompletionNode() instanceof CompletionOnMessageSend || context.getCompletionNodeParent() instanceof MessageSend;
    }

    private static Optional<TypeBinding> resolveReturnStatement(InternalCompletionContext context) {
        String expected = String.valueOf(context.getExpectedTypesKeys()[0]);
        ObjectVector methods = context.getVisibleMethods();
        int i = 0;
        while (i < methods.size) {
            TypeBinding type = ((MethodBinding)methods.elementAt((int)i)).returnType;
            String key = String.valueOf(type.computeUniqueKey());
            if (key.equals(expected)) {
                return Optional.of((Object)type);
            }
            ++i;
        }
        return Optional.absent();
    }
}

