/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.snipmatch.rcp;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.eventbus.EventBus;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.recommenders.internal.snipmatch.rcp.Repositories;
import org.eclipse.recommenders.internal.snipmatch.rcp.RepositoryConfigurations;
import org.eclipse.recommenders.internal.snipmatch.rcp.SnipmatchRcpPreferences;
import org.eclipse.recommenders.internal.snipmatch.rcp.SnippetRepositoryTypeSelectionWizard;
import org.eclipse.recommenders.internal.snipmatch.rcp.WizardDescriptor;
import org.eclipse.recommenders.internal.snipmatch.rcp.WizardDescriptors;
import org.eclipse.recommenders.internal.snipmatch.rcp.l10n.Messages;
import org.eclipse.recommenders.snipmatch.ISnippetRepository;
import org.eclipse.recommenders.snipmatch.model.SnippetRepositoryConfiguration;
import org.eclipse.recommenders.snipmatch.rcp.ISnippetRepositoryWizard;
import org.eclipse.recommenders.snipmatch.rcp.model.SnippetRepositoryConfigurations;
import org.eclipse.recommenders.utils.Checks;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class SnipmatchPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private final SnipmatchRcpPreferences prefs;
    private final EventBus bus;
    private final Repositories repos;
    private final SnippetRepositoryConfigurations configuration;
    private final File repositoryConfigurationFile;
    private boolean dirty;

    @Inject
    public SnipmatchPreferencePage(EventBus bus, Repositories repos, SnippetRepositoryConfigurations configuration, @Named(value="REPOSITORY_CONFIGURATION_FILE") File repositoryConfigurationFile, SnipmatchRcpPreferences prefs) {
        super(1);
        this.setDescription(Messages.PREFPAGE_DESCRIPTION);
        this.bus = bus;
        this.repos = repos;
        this.configuration = configuration;
        this.repositoryConfigurationFile = repositoryConfigurationFile;
        this.prefs = prefs;
    }

    public void createFieldEditors() {
        ConfigurationEditor configurationEditor = new ConfigurationEditor("", Messages.PREFPAGE_LABEL_REMOTE_SNIPPETS_REPOSITORY, this.getFieldEditorParent());
        this.addField(configurationEditor);
        Dialog.applyDialogFont((Control)this.getControl());
        this.dirty = false;
    }

    public void init(IWorkbench workbench) {
        ScopedPreferenceStore store = new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.eclipse.recommenders.snipmatch.rcp");
        this.setPreferenceStore((IPreferenceStore)store);
    }

    private final class ConfigurationEditor
    extends FieldEditor {
        private CheckboxTableViewer tableViewer;
        private Composite buttonBox;
        private Button newButton;
        private Button editButton;
        private Button removeButton;

        private ConfigurationEditor(String name, String labelText, Composite parent) {
            super(name, labelText, parent);
        }

        protected void adjustForNumColumns(int numColumns) {
        }

        protected void doFillIntoGrid(Composite parent, int numColumns) {
            Label control = this.getLabelControl(parent);
            GridDataFactory.swtDefaults().span(numColumns, 1).applyTo((Control)control);
            this.tableViewer = this.getTableControl(parent);
            GridDataFactory.fillDefaults().align(4, 4).span(numColumns - 1, 1).grab(true, true).applyTo((Control)this.tableViewer.getTable());
            this.tableViewer.getTable().addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (e.detail == 32) {
                        SnipmatchPreferencePage.this.dirty = true;
                    }
                    ConfigurationEditor.this.updateButtonStatus();
                }
            });
            this.tableViewer.getTable().addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDoubleClick(MouseEvent e) {
                    boolean isClickOnCheckbox;
                    TableItem item = ConfigurationEditor.this.tableViewer.getTable().getItem(new Point(e.x, e.y));
                    if (item == null) {
                        return;
                    }
                    Rectangle bounds = item.getBounds();
                    boolean bl = isClickOnCheckbox = e.x < bounds.x;
                    if (isClickOnCheckbox) {
                        return;
                    }
                    SnippetRepositoryConfiguration selectedConfiguration = (SnippetRepositoryConfiguration)Checks.cast((Object)item.getData());
                    if (!selectedConfiguration.isDefaultConfiguration()) {
                        ConfigurationEditor.this.editConfiguration(selectedConfiguration);
                    }
                    ConfigurationEditor.this.updateButtonStatus();
                }
            });
            this.buttonBox = this.getButtonControl(parent);
            this.updateButtonStatus();
            GridDataFactory.fillDefaults().align(4, 1).applyTo((Control)this.buttonBox);
        }

        private void updateButtonStatus() {
            boolean selected = this.tableViewer.getTable().getSelectionIndex() != -1;
            SnippetRepositoryConfiguration selectedConfiguration = this.getSelectedConfiguration();
            if (selectedConfiguration == null) {
                this.editButton.setEnabled(false);
                this.removeButton.setEnabled(false);
                return;
            }
            boolean wizardAvailable = WizardDescriptors.isWizardAvailable(selectedConfiguration);
            boolean defaultConfiguration = selectedConfiguration.isDefaultConfiguration();
            this.editButton.setEnabled(selected && wizardAvailable && !defaultConfiguration);
            this.removeButton.setEnabled(selected && !defaultConfiguration);
        }

        private Composite getButtonControl(Composite parent) {
            Composite box = new Composite(parent, 0);
            GridLayoutFactory.fillDefaults().applyTo(box);
            this.newButton = this.createButton(box, Messages.PREFPAGE_BUTTON_NEW);
            this.newButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ConfigurationEditor.this.addNewConfiguration();
                    ConfigurationEditor.this.updateButtonStatus();
                }
            });
            this.editButton = this.createButton(box, Messages.PREFPAGE_BUTTON_EDIT);
            this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ConfigurationEditor.this.editConfiguration(ConfigurationEditor.this.getSelectedConfiguration());
                    ConfigurationEditor.this.updateButtonStatus();
                }
            });
            this.editButton.setEnabled(false);
            this.removeButton = this.createButton(box, Messages.PREFPAGE_BUTTON_REMOVE);
            this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ConfigurationEditor.this.removeConfiguration(ConfigurationEditor.this.getSelectedConfiguration());
                    ConfigurationEditor.this.updateButtonStatus();
                }
            });
            return box;
        }

        private SnippetRepositoryConfiguration getSelectedConfiguration() {
            List<SnippetRepositoryConfiguration> tableInput = this.getTableInput();
            int index = this.tableViewer.getTable().getSelectionIndex();
            if (index != -1) {
                return tableInput.get(index);
            }
            return null;
        }

        protected void removeConfiguration(SnippetRepositoryConfiguration configuration) {
            ISnippetRepository repo;
            boolean confirmed;
            List<SnippetRepositoryConfiguration> configurations = this.getTableInput();
            MessageDialogWithToggle confirmDialog = MessageDialogWithToggle.openOkCancelConfirm((Shell)SnipmatchPreferencePage.this.getShell(), (String)Messages.CONFIRM_DIALOG_DELETE_REPOSITORY_TITLE, (String)MessageFormat.format(Messages.CONFIRM_DIALOG_DELETE_REPOSITORY_MESSAGE, configuration.getName()), (String)Messages.CONFIRM_DIALOG_DELETE_REPOSITORY_TOGGLE_MESSAGE, (boolean)true, null, null);
            boolean bl = confirmed = confirmDialog.getReturnCode() == 0;
            if (!confirmed) {
                return;
            }
            boolean delete = confirmDialog.getToggleState();
            if (delete && (repo = (ISnippetRepository)SnipmatchPreferencePage.this.repos.getRepository(configuration.getId()).orNull()) != null) {
                repo.delete();
            }
            configurations.remove(configuration);
            this.updateTableContent(configurations);
            SnipmatchPreferencePage.this.dirty = true;
        }

        protected void editConfiguration(SnippetRepositoryConfiguration oldConfiguration) {
            List<WizardDescriptor> suitableWizardDescriptors = WizardDescriptors.filterApplicableWizardDescriptors(WizardDescriptors.loadAvailableWizards(), oldConfiguration);
            if (!suitableWizardDescriptors.isEmpty()) {
                ISnippetRepositoryWizard wizard;
                if (suitableWizardDescriptors.size() == 1) {
                    wizard = ((WizardDescriptor)Iterables.getOnlyElement(suitableWizardDescriptors)).getWizard();
                    wizard.setConfiguration(oldConfiguration);
                } else {
                    wizard = new SnippetRepositoryTypeSelectionWizard(oldConfiguration);
                }
                WizardDialog dialog = new WizardDialog(this.getPage().getShell(), (IWizard)wizard);
                dialog.setHelpAvailable(false);
                if (dialog.open() == 0) {
                    List<SnippetRepositoryConfiguration> configurations = this.getTableInput();
                    configurations.add(configurations.indexOf(oldConfiguration), wizard.getConfiguration());
                    configurations.remove(oldConfiguration);
                    this.updateTableContent(configurations);
                    SnipmatchPreferencePage.this.dirty = true;
                }
            }
        }

        private List<SnippetRepositoryConfiguration> getTableInput() {
            List configurations = (List)Checks.cast((Object)this.tableViewer.getInput());
            if (configurations == null) {
                return new ArrayList<SnippetRepositoryConfiguration>();
            }
            return new ArrayList<SnippetRepositoryConfiguration>(configurations);
        }

        protected void addNewConfiguration() {
            List<WizardDescriptor> availableWizards = WizardDescriptors.loadAvailableWizards();
            if (!availableWizards.isEmpty()) {
                SnippetRepositoryTypeSelectionWizard newWizard = new SnippetRepositoryTypeSelectionWizard();
                WizardDialog dialog = new WizardDialog(this.getPage().getShell(), (IWizard)newWizard);
                dialog.setHelpAvailable(false);
                if (dialog.open() == 0) {
                    List<SnippetRepositoryConfiguration> configurations = this.getTableInput();
                    SnippetRepositoryConfiguration newConfiguration = newWizard.getConfiguration();
                    newConfiguration.setId(UUID.randomUUID().toString());
                    configurations.add(newConfiguration);
                    this.updateTableContent(configurations);
                    SnipmatchPreferencePage.this.dirty = true;
                }
            }
        }

        private Button createButton(Composite box, String text) {
            Button button = new Button(box, 8);
            button.setText(text);
            int widthHint = Math.max(this.convertHorizontalDLUsToPixels((Control)button, 61), button.computeSize((int)-1, (int)-1, (boolean)true).x);
            GridDataFactory.swtDefaults().align(4, 0x1000000).hint(widthHint, -1).applyTo((Control)button);
            return button;
        }

        private CheckboxTableViewer getTableControl(Composite parent) {
            CheckboxTableViewer tableViewer = CheckboxTableViewer.newCheckList((Composite)parent, (int)67584);
            tableViewer.setLabelProvider((IBaseLabelProvider)new ColumnLabelProvider(){

                public String getText(Object element) {
                    SnippetRepositoryConfiguration config = (SnippetRepositoryConfiguration)Checks.cast((Object)element);
                    return config.getName();
                }

                public String getToolTipText(Object element) {
                    SnippetRepositoryConfiguration config = (SnippetRepositoryConfiguration)Checks.cast((Object)element);
                    return config.getDescription();
                }
            });
            ColumnViewerToolTipSupport.enableFor((ColumnViewer)tableViewer);
            tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
            return tableViewer;
        }

        protected void doLoad() {
            this.updateTableContent(Lists.newArrayList(SnipmatchPreferencePage.this.configuration.getRepos()));
        }

        public void updateTableContent(List<SnippetRepositoryConfiguration> configurations) {
            final List<SnippetRepositoryConfiguration> oldConfigurations = this.getTableInput();
            Collection checkedConfigurations = Collections2.filter(configurations, (Predicate)new Predicate<SnippetRepositoryConfiguration>(){

                public boolean apply(SnippetRepositoryConfiguration input) {
                    if (oldConfigurations != null && oldConfigurations.contains(input)) {
                        return ConfigurationEditor.this.tableViewer.getChecked((Object)input);
                    }
                    return SnipmatchPreferencePage.this.prefs.isRepositoryEnabled(input);
                }
            });
            this.tableViewer.setInput(configurations);
            this.tableViewer.setCheckedElements(checkedConfigurations.toArray());
        }

        public void loadDefault() {
            super.loadDefault();
            this.setPresentsDefaultValue(false);
        }

        protected void doLoadDefault() {
            List<SnippetRepositoryConfiguration> defaultConfigurations = RepositoryConfigurations.fetchDefaultConfigurations();
            this.updateTableContent(defaultConfigurations);
            this.tableViewer.setCheckedElements(defaultConfigurations.toArray());
            SnipmatchPreferencePage.this.dirty = true;
        }

        protected void doStore() {
            if (!SnipmatchPreferencePage.this.dirty) {
                return;
            }
            List<SnippetRepositoryConfiguration> oldconfigs = this.getTableInput();
            ArrayList<SnippetRepositoryConfiguration> newConfigs = new ArrayList<SnippetRepositoryConfiguration>();
            for (SnippetRepositoryConfiguration config : oldconfigs) {
                SnipmatchPreferencePage.this.prefs.setRepositoryEnabled(config, this.tableViewer.getChecked((Object)config));
                newConfigs.add(config);
            }
            SnipmatchPreferencePage.this.configuration.getRepos().clear();
            SnipmatchPreferencePage.this.configuration.getRepos().addAll(newConfigs);
            RepositoryConfigurations.storeConfigurations(SnipmatchPreferencePage.this.configuration, SnipmatchPreferencePage.this.repositoryConfigurationFile);
            SnipmatchPreferencePage.this.bus.post((Object)new Repositories.SnippetRepositoryConfigurationChangedEvent());
            SnipmatchPreferencePage.this.dirty = false;
        }

        public int getNumberOfControls() {
            return 2;
        }
    }
}

