/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.javaeditor;

import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditorMessages;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;

public class ToggleTextHoverAction
extends TextEditorAction
implements IPropertyChangeListener {
    private IPreferenceStore fStore;

    public ToggleTextHoverAction() {
        super(JavaEditorMessages.getBundleForConstructedKeys(), "ToggleTextHover.", null);
        JavaPluginImages.setToolImageDescriptors((IAction)this, "jdoc_hover_edit.png");
        this.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.toggle.text.hover");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.jdt.ui.toggle_texthover_action_context");
        this.update();
    }

    public void run() {
        ITextEditor editor = this.getTextEditor();
        if (editor == null) {
            return;
        }
        boolean showHover = !this.fStore.getBoolean("org.eclipse.jdt.ui.editor.showHover");
        this.setChecked(showHover);
        this.fStore.removePropertyChangeListener((IPropertyChangeListener)this);
        this.fStore.setValue("org.eclipse.jdt.ui.editor.showHover", showHover);
        this.fStore.addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public void update() {
        boolean showHover = this.fStore != null && this.fStore.getBoolean("org.eclipse.jdt.ui.editor.showHover");
        this.setChecked(showHover);
        this.setEnabled(this.getTextEditor() != null);
    }

    public void setEditor(ITextEditor editor) {
        super.setEditor(editor);
        if (editor != null) {
            if (this.fStore == null) {
                this.fStore = JavaPlugin.getDefault().getPreferenceStore();
                this.fStore.addPropertyChangeListener((IPropertyChangeListener)this);
            }
        } else if (this.fStore != null) {
            this.fStore.removePropertyChangeListener((IPropertyChangeListener)this);
            this.fStore = null;
        }
        this.update();
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("org.eclipse.jdt.ui.editor.showHover")) {
            this.update();
        }
    }
}

