/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.event;

import java.lang.reflect.Method;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.internal.dispatch.Dispatch;
import org.gradle.internal.dispatch.MethodInvocation;
import org.gradle.internal.dispatch.ReflectionDispatch;
import org.gradle.internal.event.AbstractBroadcastDispatch;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableCollection;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;
import org.gradle.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BroadcastDispatch<T>
extends AbstractBroadcastDispatch<T> {
    private BroadcastDispatch(Class<T> type) {
        super(type);
    }

    public static <T> BroadcastDispatch<T> empty(Class<T> type) {
        return new EmptyDispatch<T>(type);
    }

    public Class<T> getType() {
        return this.type;
    }

    public abstract boolean isEmpty();

    public BroadcastDispatch<T> add(Dispatch<MethodInvocation> dispatch) {
        return this.add(dispatch, dispatch);
    }

    public BroadcastDispatch<T> add(T listener) {
        return this.add(listener, new ReflectionDispatch(listener));
    }

    public BroadcastDispatch<T> add(String methodName, Action<?> action) {
        this.assertIsMethod(methodName);
        return this.add(action, new ActionInvocationHandler(methodName, action));
    }

    abstract BroadcastDispatch<T> add(Object var1, Dispatch<MethodInvocation> var2);

    private void assertIsMethod(String methodName) {
        for (Method method : this.type.getMethods()) {
            if (!method.getName().equals(methodName)) continue;
            return;
        }
        throw new IllegalArgumentException(String.format("Method %s() not found for listener type %s.", methodName, this.type.getSimpleName()));
    }

    public abstract BroadcastDispatch<T> remove(Object var1);

    public abstract BroadcastDispatch<T> addAll(Iterable<? extends T> var1);

    public abstract BroadcastDispatch<T> removeAll(Iterable<?> var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ActionInvocationHandler
    implements Dispatch<MethodInvocation> {
        private final String methodName;
        private final Action action;

        ActionInvocationHandler(String methodName, Action action) {
            this.methodName = methodName;
            this.action = action;
        }

        @Override
        public void dispatch(MethodInvocation message) {
            if (message.getMethod().getName().equals(this.methodName)) {
                this.action.execute(message.getArguments()[0]);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CompositeDispatch<T>
    extends BroadcastDispatch<T> {
        private final ImmutableSet<SingletonDispatch<T>> dispatchers;

        CompositeDispatch(Class<T> type, ImmutableSet<SingletonDispatch<T>> dispatchers) {
            super(type);
            this.dispatchers = dispatchers;
        }

        public String toString() {
            return this.dispatchers.toString();
        }

        @Override
        BroadcastDispatch<T> add(Object handler, Dispatch<MethodInvocation> dispatch) {
            ImmutableSet.Builder builder = ImmutableSet.builder();
            for (SingletonDispatch singletonDispatch : this.dispatchers) {
                if (singletonDispatch.handler == handler || singletonDispatch.handler.equals(handler)) {
                    return this;
                }
                builder.add(singletonDispatch);
            }
            builder.add(new SingletonDispatch(this.type, handler, dispatch));
            return new CompositeDispatch<T>(this.type, builder.build());
        }

        @Override
        public BroadcastDispatch<T> addAll(Iterable<? extends T> listeners) {
            ImmutableSet.Builder builder = ImmutableSet.builder();
            builder.addAll(this.dispatchers);
            for (T listener : listeners) {
                builder.add(new SingletonDispatch(this.type, listener, new ReflectionDispatch(listener)));
            }
            ImmutableCollection result = builder.build();
            if (((ImmutableSet)result).equals(this.dispatchers)) {
                return this;
            }
            return new CompositeDispatch<T>(this.type, result);
        }

        @Override
        public BroadcastDispatch<T> remove(Object listener) {
            ImmutableSet.Builder builder = ImmutableSet.builder();
            boolean found = false;
            for (SingletonDispatch singletonDispatch : this.dispatchers) {
                if (singletonDispatch.handler == listener || singletonDispatch.handler.equals(listener)) {
                    found = true;
                    continue;
                }
                builder.add(singletonDispatch);
            }
            if (!found) {
                return this;
            }
            ImmutableCollection result = builder.build();
            if (result.size() == 1) {
                return (BroadcastDispatch)((ImmutableSet)result).iterator().next();
            }
            return new CompositeDispatch<T>(this.type, result);
        }

        @Override
        public BroadcastDispatch<T> removeAll(Iterable<?> listeners) {
            Set<?> listenerList = CollectionUtils.toSet(listeners);
            ImmutableSet.Builder builder = ImmutableSet.builder();
            for (SingletonDispatch singletonDispatch : this.dispatchers) {
                if (listenerList.contains(singletonDispatch.handler)) continue;
                builder.add(singletonDispatch);
            }
            ImmutableCollection result = builder.build();
            if (result.size() == 0) {
                return new EmptyDispatch(this.type);
            }
            if (result.size() == 1) {
                return (BroadcastDispatch)((ImmutableSet)result).iterator().next();
            }
            if (((ImmutableSet)result).equals(this.dispatchers)) {
                return this;
            }
            return new CompositeDispatch<T>(this.type, result);
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public void dispatch(MethodInvocation message) {
            this.dispatch(message, this.dispatchers.iterator());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EmptyDispatch<T>
    extends BroadcastDispatch<T> {
        EmptyDispatch(Class<T> type) {
            super(type);
        }

        public String toString() {
            return "<empty>";
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public BroadcastDispatch<T> remove(Object listener) {
            return this;
        }

        @Override
        public BroadcastDispatch<T> removeAll(Iterable<?> listeners) {
            return this;
        }

        @Override
        BroadcastDispatch<T> add(Object handler, Dispatch<MethodInvocation> dispatch) {
            return new SingletonDispatch(this.type, handler, dispatch);
        }

        @Override
        public BroadcastDispatch<T> addAll(Iterable<? extends T> listeners) {
            ImmutableSet.Builder builder = ImmutableSet.builder();
            for (T listener : listeners) {
                builder.add(new SingletonDispatch(this.type, listener, new ReflectionDispatch(listener)));
            }
            ImmutableCollection result = builder.build();
            if (result.isEmpty()) {
                return this;
            }
            if (result.size() == 1) {
                return (BroadcastDispatch)((ImmutableSet)result).iterator().next();
            }
            return new CompositeDispatch(this.type, result);
        }

        @Override
        public void dispatch(MethodInvocation message) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SingletonDispatch<T>
    extends BroadcastDispatch<T> {
        private final Object handler;
        private final Dispatch<MethodInvocation> dispatch;

        SingletonDispatch(Class<T> type, Object handler, Dispatch<MethodInvocation> dispatch) {
            super(type);
            this.handler = handler;
            this.dispatch = dispatch;
        }

        public String toString() {
            return this.handler.toString();
        }

        public boolean equals(Object obj) {
            SingletonDispatch other = (SingletonDispatch)obj;
            return this.handler == other.handler || this.handler.equals(other.handler);
        }

        public int hashCode() {
            return this.handler.hashCode();
        }

        @Override
        BroadcastDispatch<T> add(Object handler, Dispatch<MethodInvocation> dispatch) {
            if (this.handler == handler || this.handler.equals(handler)) {
                return this;
            }
            return new CompositeDispatch<T>(this.type, ImmutableSet.of(this, new SingletonDispatch<T>(this.type, handler, dispatch)));
        }

        @Override
        public BroadcastDispatch<T> addAll(Iterable<? extends T> listeners) {
            ImmutableSet.Builder builder = ImmutableSet.builder();
            builder.add(this);
            for (T listener : listeners) {
                if (this.handler == listener || this.handler.equals(listener)) continue;
                builder.add(new SingletonDispatch<T>(this.type, listener, new ReflectionDispatch(listener)));
            }
            ImmutableCollection result = builder.build();
            if (result.size() == 1) {
                return this;
            }
            return new CompositeDispatch(this.type, result);
        }

        @Override
        public BroadcastDispatch<T> remove(Object listener) {
            if (this.handler == listener || this.handler.equals(listener)) {
                return new EmptyDispatch(this.type);
            }
            return this;
        }

        @Override
        public BroadcastDispatch<T> removeAll(Iterable<?> listeners) {
            for (Object listener : listeners) {
                if (this.handler != listener && !this.handler.equals(listener)) continue;
                return new EmptyDispatch(this.type);
            }
            return this;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public void dispatch(MethodInvocation message) {
            this.dispatch(message, this.dispatch);
        }
    }
}

