/*
 * Decompiled with CFR 0.152.
 */
package io.takari.aether.okhttp;

import io.takari.aether.client.AetherClient;
import io.takari.aether.client.AetherClientAuthentication;
import io.takari.aether.client.AetherClientConfig;
import io.takari.aether.client.AetherClientProxy;
import io.takari.aether.client.RetryableSource;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import okhttp3.Authenticator;
import okhttp3.Credentials;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.Route;
import okhttp3.internal.tls.OkHostnameVerifier;
import okio.BufferedSink;

public class OkHttpAetherClient
implements AetherClient {
    private final Authenticator PROXY_AUTH = new Authenticator(){

        public Request authenticate(Route route, Response response) throws IOException {
            if (response.code() == 407) {
                return this.authenticateProxy(route.proxy(), response);
            }
            return null;
        }

        private Request authenticateProxy(Proxy proxy, Response response) throws IOException {
            Request req = response.request();
            if (req.header("Proxy-Authorization") == null && OkHttpAetherClient.this.config.getProxy() != null && OkHttpAetherClient.this.config.getProxy().getAuthentication() != null) {
                boolean tunneled;
                String value = OkHttpAetherClient.this.toHeaderValue(OkHttpAetherClient.this.config.getProxy().getAuthentication());
                boolean bl = tunneled = req.isHttps() && proxy.type() == Proxy.Type.HTTP;
                if (!tunneled) {
                    OkHttpAetherClient.this.headers.put("Proxy-Authorization", value);
                }
                return req.newBuilder().header("Proxy-Authorization", value).build();
            }
            return null;
        }
    };
    private final Map<String, String> headers;
    private final AetherClientConfig config;
    private final OkHttpClient httpClient;

    public OkHttpAetherClient(AetherClientConfig config) {
        this.config = config;
        this.headers = new HashMap<String, String>();
        if (config.getHeaders() != null) {
            this.headers.putAll(config.getHeaders());
        }
        if (!this.headers.containsKey("User-Agent")) {
            this.headers.put("User-Agent", config.getUserAgent());
        }
        OkHttpClient.Builder builder = new OkHttpClient.Builder().proxy(this.getProxy(config.getProxy())).hostnameVerifier((HostnameVerifier)OkHostnameVerifier.INSTANCE).authenticator(this.PROXY_AUTH).proxyAuthenticator(this.PROXY_AUTH).connectTimeout((long)config.getConnectionTimeout(), TimeUnit.MILLISECONDS).readTimeout((long)config.getRequestTimeout(), TimeUnit.MILLISECONDS);
        if (config.getSslSocketFactory() != null) {
            builder.sslSocketFactory(config.getSslSocketFactory());
        }
        if (config.getHostnameVerifier() != null) {
            builder.hostnameVerifier(config.getHostnameVerifier());
        }
        this.httpClient = builder.build();
    }

    @Override
    public io.takari.aether.client.Response head(String uri) throws IOException {
        io.takari.aether.client.Response response;
        while ((response = this.execute(this.httpClient, this.builder(uri, null).head().build())) == null) {
        }
        return response;
    }

    @Override
    public io.takari.aether.client.Response get(String uri) throws IOException {
        io.takari.aether.client.Response response;
        while ((response = this.execute(this.httpClient, this.builder(uri, null).get().build())) == null) {
        }
        return response;
    }

    @Override
    public io.takari.aether.client.Response get(String uri, Map<String, String> requestHeaders) throws IOException {
        io.takari.aether.client.Response response;
        while ((response = this.execute(this.httpClient, this.builder(uri, requestHeaders).get().build())) == null) {
        }
        return response;
    }

    @Override
    public io.takari.aether.client.Response put(String uri, final RetryableSource source) throws IOException {
        Request.Builder builder;
        OkHttpClient httpClient;
        io.takari.aether.client.Response response;
        do {
            httpClient = this.httpClient.newBuilder().cache(null).build();
            final MediaType mediaType = MediaType.parse((String)"application/octet-stream");
            RequestBody body = new RequestBody(){

                public void writeTo(BufferedSink sink) throws IOException {
                    source.copyTo(sink.outputStream());
                }

                public MediaType contentType() {
                    return mediaType;
                }

                public long contentLength() throws IOException {
                    return source.length();
                }
            };
            builder = this.builder(uri, null).put(body);
            if (source.length() <= 0L) continue;
            builder.header("Content-Length", String.valueOf(source.length()));
        } while ((response = this.execute(httpClient, builder.build())) == null);
        return response;
    }

    private io.takari.aether.client.Response execute(OkHttpClient httpClient, Request request) throws IOException {
        Response response = httpClient.newCall(request).execute();
        switch (response.code()) {
            case 401: {
                if (this.config.getAuthentication() == null || this.headers.containsKey("Authorization")) break;
                this.headers.put("Authorization", this.toHeaderValue(this.config.getAuthentication()));
                response.body().close();
                return null;
            }
        }
        return new ResponseAdapter(response);
    }

    private String toHeaderValue(AetherClientAuthentication auth) {
        return Credentials.basic((String)auth.getUsername(), (String)auth.getPassword());
    }

    private Proxy getProxy(AetherClientProxy proxy) {
        Proxy ohp;
        if (proxy == null) {
            ohp = Proxy.NO_PROXY;
        } else {
            InetSocketAddress addr = new InetSocketAddress(proxy.getHost(), proxy.getPort());
            ohp = new Proxy(Proxy.Type.HTTP, addr);
        }
        return ohp;
    }

    private Request.Builder builder(String uri, Map<String, String> requestHeaders) throws IOException {
        Request.Builder builder = new Request.Builder().url(uri);
        if (this.headers != null) {
            for (String headerName : this.headers.keySet()) {
                builder.addHeader(headerName, this.headers.get(headerName));
            }
        }
        if (requestHeaders != null) {
            for (String headerName : requestHeaders.keySet()) {
                builder.addHeader(headerName, requestHeaders.get(headerName));
            }
        }
        return builder;
    }

    @Override
    public void close() {
    }

    class ResponseAdapter
    implements io.takari.aether.client.Response {
        Response conn;

        ResponseAdapter(Response conn) {
            this.conn = conn;
        }

        @Override
        public int getStatusCode() throws IOException {
            return this.conn.code();
        }

        @Override
        public String getStatusMessage() throws IOException {
            return this.conn.message();
        }

        @Override
        public String getHeader(String name) {
            return this.conn.header(name);
        }

        @Override
        public Map<String, List<String>> getHeaders() {
            HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
            for (String header : this.conn.headers().names()) {
                headers.put(header, this.conn.headers(header));
            }
            return headers;
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return this.conn.body().byteStream();
        }
    }
}

