/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.projectimport;

import com.gradleware.tooling.toolingmodel.repository.FixedRequestAttributes;
import com.gradleware.tooling.toolingutils.binding.Property;
import com.gradleware.tooling.toolingutils.binding.Validator;
import com.gradleware.tooling.toolingutils.binding.Validators;
import java.io.File;
import java.util.List;
import org.eclipse.buildship.core.util.configuration.FixedRequestAttributesBuilder;
import org.eclipse.buildship.core.util.gradle.GradleDistributionWrapper;

public final class ProjectImportConfiguration {
    private final Property<File> projectDir;
    private final Property<GradleDistributionWrapper> gradleDistribution;
    private final Property<Boolean> applyWorkingSets;
    private final Property<List<String>> workingSets;

    public ProjectImportConfiguration() {
        this((Validator<File>)Validators.noOp(), (Validator<GradleDistributionWrapper>)Validators.noOp(), (Validator<Boolean>)Validators.noOp(), (Validator<List<String>>)Validators.noOp());
    }

    public ProjectImportConfiguration(Validator<File> projectDirValidator, Validator<GradleDistributionWrapper> gradleDistributionValidator, Validator<Boolean> applyWorkingSetsValidator, Validator<List<String>> workingSetsValidators) {
        this.projectDir = Property.create(projectDirValidator);
        this.gradleDistribution = Property.create(gradleDistributionValidator);
        this.applyWorkingSets = Property.create(applyWorkingSetsValidator);
        this.workingSets = Property.create(workingSetsValidators);
    }

    public Property<File> getProjectDir() {
        return this.projectDir;
    }

    public void setProjectDir(File projectDir) {
        this.projectDir.setValue((Object)projectDir);
    }

    public Property<GradleDistributionWrapper> getGradleDistribution() {
        return this.gradleDistribution;
    }

    public void setGradleDistribution(GradleDistributionWrapper gradleDistribution) {
        this.gradleDistribution.setValue((Object)gradleDistribution);
    }

    public Property<Boolean> getApplyWorkingSets() {
        return this.applyWorkingSets;
    }

    public void setApplyWorkingSets(Boolean applyWorkingSets) {
        this.applyWorkingSets.setValue((Object)applyWorkingSets);
    }

    public Property<List<String>> getWorkingSets() {
        return this.workingSets;
    }

    public void setWorkingSets(List<String> workingSets) {
        this.workingSets.setValue(workingSets);
    }

    public FixedRequestAttributes toFixedAttributes() {
        return FixedRequestAttributesBuilder.fromWorkspaceSettings((File)this.getProjectDir().getValue()).gradleDistribution(((GradleDistributionWrapper)this.getGradleDistribution().getValue()).toGradleDistribution()).build();
    }
}

