/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.workspace.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.gradleware.tooling.toolingmodel.OmniEclipseLinkedResource;
import com.gradleware.tooling.toolingmodel.OmniEclipseProject;
import com.gradleware.tooling.toolingmodel.OmniGradleProject;
import com.gradleware.tooling.toolingmodel.util.Maybe;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import org.eclipse.buildship.core.GradlePluginsRuntimeException;
import org.eclipse.buildship.core.preferences.PersistentModel;
import org.eclipse.buildship.core.util.file.RelativePathUtils;
import org.eclipse.buildship.core.workspace.internal.PersistentModelBuilder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;

final class GradleFolderUpdater {
    private final IProject workspaceProject;
    private final OmniEclipseProject modelProject;

    private GradleFolderUpdater(IProject workspaceProject, OmniEclipseProject modelProject) {
        this.workspaceProject = (IProject)Preconditions.checkNotNull((Object)workspaceProject);
        this.modelProject = (OmniEclipseProject)Preconditions.checkNotNull((Object)modelProject);
    }

    private void update(PersistentModelBuilder persistentModel, IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)3);
        try {
            GradleFolderInfo folderInfo = this.collectFolderInfo((IProgressMonitor)progress.newChild(1));
            Collection<IPath> folderPaths = folderInfo.toPathList();
            persistentModel.buildDir(folderInfo.getProjectBuildDir());
            persistentModel.subprojectPaths(folderInfo.getNestedProjectPaths());
            this.removePreviousMarkers(folderPaths, persistentModel, progress.newChild(1));
            this.addNewMarkers(folderPaths, persistentModel, progress.newChild(1));
        }
        catch (CoreException e) {
            String message = String.format("Could not update folder information on project %s.", this.workspaceProject.getName());
            throw new GradlePluginsRuntimeException(message, e);
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    private GradleFolderInfo collectFolderInfo(IProgressMonitor monitor) {
        IPath currentProjectPath = this.workspaceProject.getLocation();
        IPath currentProjectBuildDirPath = null;
        ArrayList nestedProjectPaths = Lists.newArrayList();
        ArrayList nestedBuildDirPaths = Lists.newArrayList();
        for (OmniEclipseProject project : this.modelProject.getAll()) {
            OmniGradleProject gradleProject = project.getGradleProject();
            IPath projectPath = Path.fromOSString((String)project.getProjectDirectory().getPath());
            if (!currentProjectPath.isPrefixOf(projectPath)) continue;
            IPath relativePath = RelativePathUtils.getRelativePath(currentProjectPath, projectPath);
            IPath buildDirPath = this.getBuildDirectoryPath((Maybe<File>)gradleProject.getBuildDirectory(), relativePath);
            if (relativePath.segmentCount() == 0) {
                currentProjectBuildDirPath = buildDirPath;
                continue;
            }
            nestedProjectPaths.add(relativePath);
            if (buildDirPath == null) continue;
            nestedBuildDirPaths.add(buildDirPath);
        }
        return new GradleFolderInfo(currentProjectBuildDirPath, nestedProjectPaths, nestedBuildDirPaths);
    }

    private void removePreviousMarkers(Collection<IPath> folderPaths, PersistentModelBuilder persistentModel, SubMonitor progress) throws CoreException {
        PersistentModel previousModel = persistentModel.getPrevious();
        Collection<Object> previouslyKnownPaths = previousModel.isPresent() ? previousModel.getDerivedResources() : Collections.emptyList();
        progress.setWorkRemaining(previouslyKnownPaths.size());
        for (IPath iPath : previouslyKnownPaths) {
            IResource resource = this.workspaceProject.findMember(iPath);
            if (resource != null) {
                resource.setDerived(false, (IProgressMonitor)progress.newChild(1));
                continue;
            }
            progress.worked(1);
        }
    }

    private void addNewMarkers(Collection<IPath> folderPaths, PersistentModelBuilder persistentModel, SubMonitor progress) throws CoreException {
        progress.setWorkRemaining(folderPaths.size());
        for (IPath resourcePath : folderPaths) {
            IResource resource = this.workspaceProject.findMember(resourcePath);
            if (resource != null) {
                resource.setDerived(true, (IProgressMonitor)progress.newChild(1));
                continue;
            }
            progress.worked(1);
        }
        persistentModel.derivedResources(folderPaths);
    }

    private IPath getBuildDirectoryPath(Maybe<File> buildDirectory, IPath prefix) {
        IPath buildDirPath = null;
        if (buildDirectory.isPresent() && buildDirectory.get() != null) {
            buildDirPath = this.normalizeBuildDirectoryPath((IPath)new Path(((File)buildDirectory.get()).getPath()));
        }
        return buildDirPath != null ? buildDirPath : prefix.append("build");
    }

    private IPath normalizeBuildDirectoryPath(IPath buildDirLocation) {
        IPath projectLocation = this.workspaceProject.getLocation();
        if (projectLocation.isPrefixOf(buildDirLocation)) {
            IPath relativePath = RelativePathUtils.getRelativePath(projectLocation, buildDirLocation);
            return relativePath;
        }
        for (OmniEclipseLinkedResource linkedResource : this.modelProject.getLinkedResources()) {
            if (!buildDirLocation.toString().equals(linkedResource.getLocation())) continue;
            return new Path(linkedResource.getName());
        }
        return null;
    }

    static void update(IProject workspaceProject, OmniEclipseProject project, PersistentModelBuilder persistentModel, IProgressMonitor monitor) {
        new GradleFolderUpdater(workspaceProject, project).update(persistentModel, monitor);
    }

    private static final class GradleFolderInfo {
        private final IPath projectBuildDir;
        private final Collection<IPath> nestedProjectPaths;
        private final Collection<IPath> nestedProjectBuildDirs;

        public GradleFolderInfo(IPath projectBuildDir, Collection<IPath> nestedProjectPaths, Collection<IPath> nestedProjectBuildDirs) {
            this.projectBuildDir = projectBuildDir;
            this.nestedProjectPaths = nestedProjectPaths;
            this.nestedProjectBuildDirs = nestedProjectBuildDirs;
        }

        public IPath getProjectBuildDir() {
            return this.projectBuildDir;
        }

        public Collection<IPath> getNestedProjectPaths() {
            return this.nestedProjectPaths;
        }

        public Collection<IPath> toPathList() {
            LinkedHashSet result = Sets.newLinkedHashSet();
            result.add(new Path(".gradle"));
            if (this.projectBuildDir != null) {
                result.add(this.projectBuildDir);
            }
            result.addAll(this.nestedProjectBuildDirs);
            return result;
        }
    }
}

