/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.css.core.dom.properties.providers;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.e4.ui.css.core.dom.CSSStylableElement;
import org.eclipse.e4.ui.css.core.dom.properties.ICSSPropertyHandler;
import org.eclipse.e4.ui.css.core.dom.properties.css2.ICSSPropertyBackgroundHandler;
import org.eclipse.e4.ui.css.core.dom.properties.css2.ICSSPropertyBorderHandler;
import org.eclipse.e4.ui.css.core.dom.properties.css2.ICSSPropertyClassificationHandler;
import org.eclipse.e4.ui.css.core.dom.properties.css2.ICSSPropertyDimensionHandler;
import org.eclipse.e4.ui.css.core.dom.properties.css2.ICSSPropertyFontHandler;
import org.eclipse.e4.ui.css.core.dom.properties.css2.ICSSPropertyMarginHandler;
import org.eclipse.e4.ui.css.core.dom.properties.css2.ICSSPropertyPaddingHandler;
import org.eclipse.e4.ui.css.core.dom.properties.css2.ICSSPropertyTextHandler;
import org.eclipse.e4.ui.css.core.dom.properties.providers.AbstractCSSPropertyHandlerProvider;
import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.w3c.dom.css.CSSStyleDeclaration;

public class CSSPropertyHandlerSimpleProviderImpl
extends AbstractCSSPropertyHandlerProvider {
    private static Map<String, Class<? extends ICSSPropertyHandler>> defaultCSSProperties = new HashMap<String, Class<? extends ICSSPropertyHandler>>();
    private Map<Class<?>, List<ICSSPropertyHandler>> propertiesHandler = new HashMap();
    private Map<String, Class<? extends ICSSPropertyHandler>> customCSSProperties = new HashMap<String, Class<? extends ICSSPropertyHandler>>();
    private boolean isCSSPropertiesInitialized;

    static {
        CSSPropertyHandlerSimpleProviderImpl.registerDefaultCSSProperty("background", ICSSPropertyBackgroundHandler.class);
        CSSPropertyHandlerSimpleProviderImpl.registerDefaultCSSProperty("background-attachment", ICSSPropertyBackgroundHandler.class);
        CSSPropertyHandlerSimpleProviderImpl.registerDefaultCSSProperty("background-color", ICSSPropertyBackgroundHandler.class);
        CSSPropertyHandlerSimpleProviderImpl.registerDefaultCSSProperty("background-image", ICSSPropertyBackgroundHandler.class);
        CSSPropertyHandlerSimpleProviderImpl.registerDefaultCSSProperty("background-position", ICSSPropertyBackgroundHandler.class);
        CSSPropertyHandlerSimpleProviderImpl.registerDefaultCSSProperty("background-repeat", ICSSPropertyBackgroundHandler.class);
        CSSPropertyHandlerSimpleProviderImpl.registerDefaultCSSProperty("border", ICSSPropertyBorderHandler.class);
        CSSPropertyHandlerSimpleProviderImpl.registerDefaultCSSProperty("border-bottom", ICSSPropertyBorderHandler.class);
        CSSPropertyHandlerSimpleProviderImpl.registerDefaultCSSProperty("border-bottom-color", ICSSPropertyBorderHandler.class);
        CSSPropertyHandlerSimpleProviderImpl.registerDefaultCSSProperty("border-bottom-style", ICSSPropertyBorderHandler.class);
        CSSPropertyHandlerSimpleProviderImpl.registerDefaultCSSProperty("border-bottom-width", ICSSPropertyBorderHandler.class);
        CSSPropertyHandlerSimpleProviderImpl.registerDefaultCSSProperty("border-color", ICSSPropertyBorderHandler.class);
        CSSPropertyHandlerSimpleProviderImpl.registerDefaultCSSProperty("border-left", ICSSPropertyBorderHandler.class);
        CSSPropertyHandlerSimpleProviderImpl.registerDefaultCSSProperty("border-left-color", ICSSPropertyBorderHandler.class);
        CSSPropertyHandlerSimpleProviderImpl.registerDefaultCSSProperty("border-left-style", ICSSPropertyBorderHandler.class);
        CSSPropertyHandlerSimpleProviderImpl.registerDefaultCSSProperty("border-left-width", ICSSPropertyBorderHandler.class);
        CSSPropertyHandlerSimpleProviderImpl.registerDefaultCSSProperty("border-right", ICSSPropertyBorderHandler.class);
        CSSPropertyHandlerSimpleProviderImpl.registerDefaultCSSProperty("border-right-color", ICSSPropertyBorderHandler.class);
        CSSPropertyHandlerSimpleProviderImpl.registerDefaultCSSProperty("border-right-style", ICSSPropertyBorderHandler.class);
        CSSPropertyHandlerSimpleProviderImpl.registerDefaultCSSProperty("border-right-width", ICSSPropertyBorderHandler.class);
        CSSPropertyHandlerSimpleProviderImpl.registerDefaultCSSProperty("border-style", ICSSPropertyBorderHandler.class);
        CSSPropertyHandlerSimpleProviderImpl.registerDefaultCSSProperty("border-top", ICSSPropertyBorderHandler.class);
        CSSPropertyHandlerSimpleProviderImpl.registerDefaultCSSProperty("border-top-color", ICSSPropertyBorderHandler.class);
        CSSPropertyHandlerSimpleProviderImpl.registerDefaultCSSProperty("border-top-style", ICSSPropertyBorderHandler.class);
        CSSPropertyHandlerSimpleProviderImpl.registerDefaultCSSProperty("border-top-width", ICSSPropertyBorderHandler.class);
        CSSPropertyHandlerSimpleProviderImpl.registerDefaultCSSProperty("border-width", ICSSPropertyBorderHandler.class);
        CSSPropertyHandlerSimpleProviderImpl.registerDefaultCSSProperty("clear", ICSSPropertyClassificationHandler.class);
        CSSPropertyHandlerSimpleProviderImpl.registerDefaultCSSProperty("cursor", ICSSPropertyClassificationHandler.class);
        CSSPropertyHandlerSimpleProviderImpl.registerDefaultCSSProperty("display", ICSSPropertyClassificationHandler.class);
        CSSPropertyHandlerSimpleProviderImpl.registerDefaultCSSProperty("float", ICSSPropertyClassificationHandler.class);
        CSSPropertyHandlerSimpleProviderImpl.registerDefaultCSSProperty("position", ICSSPropertyClassificationHandler.class);
        CSSPropertyHandlerSimpleProviderImpl.registerDefaultCSSProperty("visibility", ICSSPropertyClassificationHandler.class);
        CSSPropertyHandlerSimpleProviderImpl.registerDefaultCSSProperty("height", ICSSPropertyDimensionHandler.class);
        CSSPropertyHandlerSimpleProviderImpl.registerDefaultCSSProperty("line-height", ICSSPropertyDimensionHandler.class);
        CSSPropertyHandlerSimpleProviderImpl.registerDefaultCSSProperty("max-height", ICSSPropertyDimensionHandler.class);
        CSSPropertyHandlerSimpleProviderImpl.registerDefaultCSSProperty("max-width", ICSSPropertyDimensionHandler.class);
        CSSPropertyHandlerSimpleProviderImpl.registerDefaultCSSProperty("min-height", ICSSPropertyDimensionHandler.class);
        CSSPropertyHandlerSimpleProviderImpl.registerDefaultCSSProperty("min-width", ICSSPropertyDimensionHandler.class);
        CSSPropertyHandlerSimpleProviderImpl.registerDefaultCSSProperty("width", ICSSPropertyDimensionHandler.class);
        CSSPropertyHandlerSimpleProviderImpl.registerDefaultCSSProperty("font", ICSSPropertyFontHandler.class);
        CSSPropertyHandlerSimpleProviderImpl.registerDefaultCSSProperty("font-family", ICSSPropertyFontHandler.class);
        CSSPropertyHandlerSimpleProviderImpl.registerDefaultCSSProperty("font-size", ICSSPropertyFontHandler.class);
        CSSPropertyHandlerSimpleProviderImpl.registerDefaultCSSProperty("font-size-adjust", ICSSPropertyFontHandler.class);
        CSSPropertyHandlerSimpleProviderImpl.registerDefaultCSSProperty("font-stretch", ICSSPropertyFontHandler.class);
        CSSPropertyHandlerSimpleProviderImpl.registerDefaultCSSProperty("font-style", ICSSPropertyFontHandler.class);
        CSSPropertyHandlerSimpleProviderImpl.registerDefaultCSSProperty("font-variant", ICSSPropertyFontHandler.class);
        CSSPropertyHandlerSimpleProviderImpl.registerDefaultCSSProperty("font-weight", ICSSPropertyFontHandler.class);
        CSSPropertyHandlerSimpleProviderImpl.registerDefaultCSSProperty("color", ICSSPropertyTextHandler.class);
        CSSPropertyHandlerSimpleProviderImpl.registerDefaultCSSProperty("text-transform", ICSSPropertyTextHandler.class);
        CSSPropertyHandlerSimpleProviderImpl.registerDefaultCSSProperty("margin", ICSSPropertyMarginHandler.class);
        CSSPropertyHandlerSimpleProviderImpl.registerDefaultCSSProperty("margin-bottom", ICSSPropertyMarginHandler.class);
        CSSPropertyHandlerSimpleProviderImpl.registerDefaultCSSProperty("margin-left", ICSSPropertyMarginHandler.class);
        CSSPropertyHandlerSimpleProviderImpl.registerDefaultCSSProperty("margin-top", ICSSPropertyMarginHandler.class);
        CSSPropertyHandlerSimpleProviderImpl.registerDefaultCSSProperty("margin-right", ICSSPropertyMarginHandler.class);
        CSSPropertyHandlerSimpleProviderImpl.registerDefaultCSSProperty("padding", ICSSPropertyPaddingHandler.class);
        CSSPropertyHandlerSimpleProviderImpl.registerDefaultCSSProperty("padding-bottom", ICSSPropertyPaddingHandler.class);
        CSSPropertyHandlerSimpleProviderImpl.registerDefaultCSSProperty("padding-left", ICSSPropertyPaddingHandler.class);
        CSSPropertyHandlerSimpleProviderImpl.registerDefaultCSSProperty("padding-top", ICSSPropertyPaddingHandler.class);
        CSSPropertyHandlerSimpleProviderImpl.registerDefaultCSSProperty("padding-right", ICSSPropertyPaddingHandler.class);
    }

    @Override
    public Collection<ICSSPropertyHandler> getCSSPropertyHandlers(String property) throws Exception {
        Class<? extends ICSSPropertyHandler> cl = this.getCSSPropertyHandlerClass(property);
        return this.propertiesHandler.get(cl);
    }

    public void registerCSSPropertyHandler(Class<?> cl, ICSSPropertyHandler handler) {
        List<ICSSPropertyHandler> handlers = this.propertiesHandler.get(cl);
        if (handlers == null) {
            handlers = new LinkedList<ICSSPropertyHandler>();
            this.propertiesHandler.put(cl, handlers);
        }
        handlers.add(handler);
    }

    protected Class<? extends ICSSPropertyHandler> getCSSPropertyHandlerClass(String property) {
        this.initializeCSSPropertiesIfNeed();
        return this.customCSSProperties.get(property);
    }

    public void registerCSSProperty(String propertyName, Class<? extends ICSSPropertyHandler> propertyHandlerClass) {
        this.customCSSProperties.put(propertyName, propertyHandlerClass);
    }

    public static void registerDefaultCSSProperty(String propertyName, Class<? extends ICSSPropertyHandler> propertyHandlerClass) {
        defaultCSSProperties.put(propertyName, propertyHandlerClass);
    }

    private void initializeCSSPropertiesIfNeed() {
        if (this.isCSSPropertiesInitialized) {
            return;
        }
        this.customCSSProperties.putAll(defaultCSSProperties);
        this.isCSSPropertiesInitialized = true;
    }

    public Collection<String> getAllCSSPropertyNames() {
        this.initializeCSSPropertiesIfNeed();
        return this.customCSSProperties.keySet();
    }

    @Override
    public CSSStyleDeclaration getDefaultCSSStyleDeclaration(CSSEngine engine, CSSStylableElement stylableElement, CSSStyleDeclaration newStyle, String pseudoE) throws Exception {
        CSSStyleDeclaration defaultStyleDeclaration = stylableElement.getDefaultStyleDeclaration(pseudoE);
        if (defaultStyleDeclaration != null) {
            return defaultStyleDeclaration;
        }
        StringBuffer style = null;
        Collection<String> propertyNames = this.getAllCSSPropertyNames();
        for (String propertyName : propertyNames) {
            String s = this.getCSSPropertyStyle(engine, stylableElement, propertyName, pseudoE);
            if (s == null) continue;
            if (style == null) {
                style = new StringBuffer();
            }
            style.append(s);
        }
        if (style != null) {
            defaultStyleDeclaration = engine.parseStyleDeclaration(style.toString());
            stylableElement.setDefaultStyleDeclaration(pseudoE, defaultStyleDeclaration);
            return defaultStyleDeclaration;
        }
        return null;
    }

    @Override
    public Collection<ICSSPropertyHandler> getCSSPropertyHandlers(Object element, String property) throws Exception {
        return this.getCSSPropertyHandlers(property);
    }

    @Override
    public Collection<String> getCSSProperties(Object element) {
        return this.getAllCSSPropertyNames();
    }
}

