/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import org.sat4j.Messages;
import org.sat4j.minisat.SolverFactory;
import org.sat4j.reader.InstanceReader;
import org.sat4j.reader.ParseFormatException;
import org.sat4j.reader.Reader;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IProblem;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.IVecInt;
import org.sat4j.specs.TimeoutException;
import org.sat4j.tools.RemiUtils;
import org.sat4j.tools.SolutionCounter;

public final class MoreThanSAT {
    private MoreThanSAT() {
    }

    public static void main(String[] args) {
        ISolver solver = SolverFactory.newDefault();
        SolutionCounter sc = new SolutionCounter(solver);
        solver.setTimeout(3600);
        InstanceReader reader = new InstanceReader(solver);
        try {
            IProblem problem = ((Reader)reader).parseInstance(args[0]);
            if (problem.isSatisfiable()) {
                System.out.println(Messages.getString("MoreThanSAT.0"));
                ((Reader)reader).decode(problem.model(), new PrintWriter(System.out));
                IVecInt backbone = RemiUtils.backbone(solver);
                System.out.println(String.valueOf(Messages.getString("MoreThanSAT.1")) + backbone);
                System.out.println(Messages.getString("MoreThanSAT.2"));
                System.out.println(String.valueOf(Messages.getString("MoreThanSAT.3")) + sc.countSolutions());
            } else {
                System.out.println(Messages.getString("MoreThanSAT.4"));
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (ParseFormatException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ContradictionException contradictionException) {
            System.out.println(Messages.getString("MoreThanSAT.5"));
        }
        catch (TimeoutException timeoutException) {
            System.out.println(Messages.getString("MoreThanSAT.6"));
        }
    }
}

